/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters;

import de.jstacs.DataType;
import de.jstacs.Storable;
import de.jstacs.io.FileManager;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import de.jstacs.tools.ui.galaxy.GalaxyAdaptor;
import de.jstacs.utils.Compression;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.StringReader;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;

public class FileParameter
extends Parameter
implements GalaxyConvertible {
    private boolean required;
    private String mime;
    private String extendedType;
    private FileRepresentation value;
    private FileRepresentation defaultValue;
    private boolean isSet;
    private String errorMessage;
    private ParameterValidator valid;
    private boolean checkMimeType;

    @Override
    public FileParameter clone() throws CloneNotSupportedException {
        FileParameter clone = (FileParameter)super.clone();
        clone.value = this.value == null ? null : this.value.clone();
        clone.defaultValue = this.defaultValue == null ? null : this.defaultValue.clone();
        return clone;
    }

    public FileParameter(StringBuffer buf) throws NonParsableException {
        super(buf);
    }

    public FileParameter(String name, String comment, String filetype, boolean required) {
        super(name, comment, DataType.FILE);
        this.mime = filetype;
        this.required = required;
    }

    public FileParameter(String name, String comment, String filetype, boolean required, ParameterValidator validator) {
        this(name, comment, filetype, required, validator, false);
    }

    public FileParameter(String name, String comment, String filetype, boolean required, ParameterValidator validator, boolean checkMimeType) {
        this(name, comment, filetype, required);
        this.valid = validator;
        this.checkMimeType = checkMimeType;
    }

    public boolean checkMimeType() {
        return this.checkMimeType;
    }

    @Override
    public boolean isAtomic() {
        return true;
    }

    @Override
    public boolean isRequired() {
        return this.required;
    }

    @Override
    public void reset() {
        this.value = null;
        this.isSet = false;
        this.errorMessage = null;
    }

    public FileRepresentation getFileContents() {
        return this.value;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value instanceof String) {
            value = new FileRepresentation((String)value);
        }
        if (this.valid != null) {
            if (this.valid.checkValue(value)) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = this.valid.getErrorMessage();
            return false;
        }
        if (value != null && value instanceof FileRepresentation) {
            FileRepresentation f = (FileRepresentation)value;
            if (f.getFilename() != null && f.getFilename().length() != 0 || f.getContent() != null && f.getContent().length() != 0) {
                this.errorMessage = null;
                return true;
            }
            this.errorMessage = "No file specified or file is empty.";
            return false;
        }
        this.errorMessage = "Value is no file or null.";
        return false;
    }

    @Override
    public void setDefault(Object defaultValue) throws SimpleParameter.IllegalValueException {
        if (defaultValue instanceof String) {
            defaultValue = new FileRepresentation((String)defaultValue);
        }
        if (!this.checkValue(defaultValue)) {
            throw new SimpleParameter.IllegalValueException(this.name, this.errorMessage);
        }
        this.defaultValue = (FileRepresentation)defaultValue;
        this.setValue(defaultValue);
        this.isSet = false;
    }

    @Override
    public void setValue(Object value) throws SimpleParameter.IllegalValueException {
        if (value instanceof String) {
            value = new FileRepresentation((String)value);
        }
        if (!this.checkValue(value)) {
            value = null;
            this.isSet = false;
            throw new SimpleParameter.IllegalValueException(this.name, this.errorMessage);
        }
        this.value = (FileRepresentation)value;
        this.isSet = true;
    }

    @Override
    public String getValue() {
        if (this.value == null) {
            return null;
        }
        return this.value.getFilename();
    }

    @Override
    public boolean hasDefaultOrIsSet() {
        return this.isSet();
    }

    @Override
    public boolean isSet() {
        return this.isSet;
    }

    @Override
    public String getXMLTag() {
        return "fileParameter";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer buf) {
        super.appendFurtherInfos(buf);
        XMLParser.appendObjectWithTags(buf, this.mime, "mime");
        XMLParser.appendObjectWithTags(buf, this.checkMimeType, "checkMimeType");
        XMLParser.appendObjectWithTags(buf, this.required, "required");
        XMLParser.appendObjectWithTags(buf, this.isSet, "isSet");
        XMLParser.appendObjectWithTags(buf, this.errorMessage, "errorMessage");
        XMLParser.appendObjectWithTags(buf, this.value, "value");
        XMLParser.appendObjectWithTags(buf, this.valid, "validator");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer buf) throws NonParsableException {
        super.extractFurtherInfos(buf);
        this.mime = XMLParser.extractObjectForTags(buf, "mime", String.class);
        this.checkMimeType = XMLParser.extractObjectForTags(buf, "checkMimeType", Boolean.TYPE);
        this.required = XMLParser.extractObjectForTags(buf, "required", Boolean.TYPE);
        this.isSet = XMLParser.extractObjectForTags(buf, "isSet", Boolean.TYPE);
        this.errorMessage = XMLParser.parseString(XMLParser.extractObjectForTags(buf, "errorMessage", String.class));
        this.value = XMLParser.extractObjectForTags(buf, "value", FileRepresentation.class);
        this.valid = XMLParser.extractObjectForTags(buf, "validator", ParameterValidator.class);
    }

    public String getAcceptedMimeType() {
        return this.mime;
    }

    public String getExtendedType() {
        return this.extendedType;
    }

    public void setExtendedType(String extendedType) {
        this.extendedType = extendedType;
    }

    private String mimeToGalaxy(String mime) {
        String[] supported = new String[]{"gb", "genbank", "ab1", "afg", "arff", "asn1", "asn1-binary", "axt", "fli", "bam", "bed", "bedgraph", "bedstrict", "bed6", "bed12", "len", "bigbed", "bigwig", "cxb", "chrint", "csv", "customtrack", "bowtie_color_index", "bowtie_base_index", "csfasta", "data", "data_manager_json", "fasta", "fasta.gz", "fastq", "fastq.gz", "fastqsanger", "fastqsolexa", "fastqcssanger", "fastqillumina", "fqtoc", "eland", "elandmulti", "genetrack", "gff", "gff3", "gif", "gmaj.zip", "gtf", "toolshed.gz", "h5", "html", "interval", "picard_interval_list", "gatk_interval", "gatk_report", "gatk_dbsnp", "gatk_tranche", "gatk_recal", "jpg", "tiff", "bmp", "im", "pcd", "pcx", "ppm", "psd", "xbm", "xpm", "rgb", "pbm", "pgm", "rna_eps", "searchgui_archive", "peptideshaker_archive", "eps", "rast", "laj", "lav", "maf", "mafcustomtrack", "encodepeak", "pdf", "pileup", "obo", "owl", "png", "qual", "qualsolexa", "qualillumina", "qualsolid", "qual454", "Roadmaps", "sam", "scf", "Sequences", "snpeffdb", "snpsiftdbnsfp", "dbnsfp.tabular", "sff", "svg", "taxonomy", "tabular", "twobit", "sqlite", "gemini.sqlite", "txt", "linecount", "memexml", "cisml", "xml", "vcf", "bcf", "velvet", "wig", "interval_index", "tabix", "bgzip", "vcf_bgzip", "bgzip", "phyloxml", "nhx", "nex", "affybatch", "eigenstratgeno", "eigenstratpca", "eset", "fped", "fphe", "gg", "ldindep", "malist", "lped", "pbed", "pheno", "pphe", "rexpbase", "rgenetics", "snptest", "snpmatrix", "xls", "ipynb", "json", "xgmml", "sif", "rdf", "xlsx"};
        HashSet set = new HashSet();
        Collections.addAll(set, supported);
        String[] mimes = mime.split(",");
        LinkedList<String> res = new LinkedList<String>();
        int i = 0;
        while (i < mimes.length) {
            mimes[i] = mimes[i].trim();
            if (set.contains(mimes[i])) {
                res.add(mimes[i]);
            }
            ++i;
        }
        if (res.size() == 0) {
            return mime;
        }
        StringBuffer sb = new StringBuffer();
        int i2 = 0;
        while (i2 < res.size()) {
            sb.append((String)res.get(i2));
            if (i2 < res.size() - 1) {
                sb.append(",");
            }
            ++i2;
        }
        return sb.toString();
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine, int indentation) {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer buf = new StringBuffer();
        String line = "";
        if (addLine) {
            line = "&lt;hr /&gt;";
        }
        XMLParser.addTagsAndAttributes(buf, "param", "type=\"data\" format=\"" + this.mimeToGalaxy(this.mime) + "\" name=\"" + namePrefix + "\" label=\"" + line + this.getName() + "\" help=\"" + this.getComment() + "\" value=\"" + (this.defaultValue == null ? "" : this.defaultValue) + "\" optional=\"" + !this.isRequired() + "\"", indentation);
        descBuffer.append(buf);
        buf = new StringBuffer();
        buf.append("${" + configPrefix + namePrefix + "}");
        XMLParser.addTags(buf, "value");
        StringBuffer buf2 = new StringBuffer();
        buf2.append("${" + configPrefix + namePrefix + ".ext}");
        XMLParser.addTags(buf2, "extension");
        buf.append(buf2);
        XMLParser.addTags(buf, namePrefix);
        configBuffer.append(buf);
    }

    public String toString() {
        return String.valueOf(this.name) + " (" + this.comment + (this.defaultValue != null ? ", default = " + this.defaultValue.getFilename() : "") + (this.mime != null ? ", type = " + this.mime : "") + (this.required ? "" : ", OPTIONAL") + ")\t= " + (this.value != null ? this.value.getFilename() : "null");
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
        namePrefix = String.valueOf(namePrefix) + "_" + GalaxyAdaptor.getLegalName(this.getName());
        StringBuffer cont = XMLParser.extractForTag(command, namePrefix);
        try {
            String val = XMLParser.extractForTag(cont, "value").toString();
            if (val.equalsIgnoreCase("none")) {
                this.isSet = false;
                return;
            }
            String ext = XMLParser.extractForTag(cont, "extension").toString().trim();
            this.value = new FileRepresentation(val);
            this.value.setExtension(ext);
        }
        catch (NonParsableException e) {
            this.value = new FileRepresentation(cont.toString());
        }
        this.isSet = true;
    }

    @Override
    public void toGalaxyTest(String namePrefix, int depth, StringBuffer testBuffer, int indentation) throws Exception {
        if (this.isSet) {
            XMLParser.insertIndentation(testBuffer, indentation, testBuffer.length());
            testBuffer.append("<param name=\"" + namePrefix + "_" + GalaxyAdaptor.getLegalName(this.getName()) + "\" file=\"" + this.getValue() + "\" />\n");
        }
    }

    public static class FileRepresentation
    implements Storable,
    Cloneable {
        private String filename;
        private String ext;
        private String content;
        private boolean compressed;

        public FileRepresentation(String filename, String content) {
            this.filename = filename;
            if (content.length() < 100000) {
                this.content = content;
            } else {
                try {
                    this.content = Compression.zip(content);
                    this.compressed = true;
                }
                catch (IOException e) {
                    this.content = content;
                    this.compressed = false;
                }
            }
            int idx = filename.lastIndexOf(46);
            if (idx >= 0) {
                this.ext = filename.substring(idx + 1);
            }
        }

        public FileRepresentation(String filename) {
            this.filename = filename;
            int idx = filename.lastIndexOf(46);
            if (idx >= 0) {
                this.ext = filename.substring(idx + 1);
            }
        }

        public FileRepresentation(StringBuffer buf) throws NonParsableException {
            this.fromXML(buf);
        }

        public FileRepresentation clone() throws CloneNotSupportedException {
            return (FileRepresentation)super.clone();
        }

        public String getFilename() {
            return this.filename;
        }

        public void setFilename(String filename) {
            this.filename = filename;
        }

        public long getFilesize() {
            if (this.filename == null) {
                return -1L;
            }
            return new File(this.filename).length();
        }

        public String getContent() {
            if (this.content == null) {
                if (this.filename != null) {
                    try {
                        String temp = FileManager.readFile(this.filename).toString();
                        if (temp.length() < 100000) {
                            this.content = temp;
                        } else {
                            try {
                                this.content = Compression.zip(temp);
                                this.compressed = true;
                            }
                            catch (IOException e) {
                                this.content = temp;
                                this.compressed = false;
                            }
                        }
                        return temp;
                    }
                    catch (IOException e) {
                        return null;
                    }
                }
            } else if (this.compressed) {
                try {
                    return Compression.unzip(this.content);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return null;
                }
            }
            return this.content;
        }

        public void setExtension(String ext) {
            this.ext = ext;
        }

        public String getExtension() {
            return this.ext;
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer buf = new StringBuffer();
            if (this.filename == null || !new File(this.filename).exists()) {
                if (this.content == null) {
                    System.err.println("WARNING: empty TextResult");
                }
                this.filename = null;
                XMLParser.appendObjectWithTags(buf, this.content, "content");
                XMLParser.appendObjectWithTags(buf, this.ext, "ext");
            }
            XMLParser.appendObjectWithTags(buf, this.filename, "filename");
            XMLParser.appendObjectWithTags(buf, this.compressed, "compressed");
            XMLParser.addTags(buf, "fileRepresentation");
            return buf;
        }

        private void fromXML(StringBuffer representation) throws NonParsableException {
            representation = XMLParser.extractForTag(representation, "fileRepresentation");
            this.filename = XMLParser.extractObjectForTags(representation, "filename", String.class);
            this.compressed = XMLParser.extractObjectForTags(representation, "compressed", Boolean.class);
            if (this.filename != null) {
                int idx = this.filename.lastIndexOf(46);
                if (idx >= 0) {
                    this.ext = this.filename.substring(idx + 1);
                }
            } else {
                try {
                    this.content = XMLParser.extractObjectForTags(representation, "content", String.class);
                }
                catch (NonParsableException e) {
                    this.content = null;
                }
                if (XMLParser.hasTag(representation, "ext", null, null)) {
                    this.ext = (String)XMLParser.extractObjectForTags(representation, "ext");
                }
            }
        }

        public boolean equals(Object o) {
            block16: {
                String line2;
                String line1;
                Character ignore;
                FileRepresentation fr;
                block17: {
                    if (this == o) {
                        return true;
                    }
                    if (!(o instanceof FileRepresentation)) break block16;
                    fr = (FileRepresentation)o;
                    ignore = null;
                    if (this.ext == null) break block17;
                    switch (this.ext) {
                        case "gff": 
                        case "gff3": {
                            ignore = Character.valueOf('#');
                            break;
                        }
                        default: {
                            ignore = null;
                        }
                    }
                }
                int i = 0;
                try {
                    BufferedReader r1 = new BufferedReader(this.content == null ? new FileReader(this.filename) : new StringReader(this.compressed ? Compression.unzip(this.content) : this.content));
                    BufferedReader r2 = new BufferedReader(fr.content == null ? new FileReader(fr.filename) : new StringReader(fr.compressed ? Compression.unzip(fr.content) : fr.content));
                    while (true) {
                        if ((line1 = r1.readLine()) != null && line1.length() > 0 && Character.valueOf(line1.charAt(0)).equals(ignore)) {
                            continue;
                        }
                        while ((line2 = r2.readLine()) != null && line2.length() > 0 && Character.valueOf(line2.charAt(0)).equals(ignore)) {
                        }
                        ++i;
                        if (line1 == null || line2 == null || !line1.equals(line2)) break;
                    }
                    r1.close();
                    r2.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    return false;
                }
                if (line1 != null || line2 != null) {
                    System.err.println("Files differ at line " + i);
                    System.err.println(String.valueOf(this.filename) + "\t" + line1);
                    System.err.println(String.valueOf(fr.filename) + "\t" + line2);
                }
                return line1 == null && line2 == null;
            }
            return false;
        }
    }
}

