/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.validation.ParameterValidator;
import java.io.File;

public class FileExistsValidator
implements ParameterValidator {
    private String errorMsg;

    public FileExistsValidator() {
    }

    public FileExistsValidator(StringBuffer xml) throws NonParsableException {
        StringBuffer part = XMLParser.extractForTag(xml, "FileExistsValidator");
        this.errorMsg = XMLParser.extractObjectForTags(part, "errorMsg", String.class);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.errorMsg, "errorMsg");
        XMLParser.addTags(xml, "FileExistsValidator");
        return xml;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null) {
            this.errorMsg = "Value is null.";
            return false;
        }
        if (value instanceof FileParameter.FileRepresentation) {
            FileParameter.FileRepresentation fr = (FileParameter.FileRepresentation)value;
            boolean ex = new File(fr.getFilename()).exists();
            if (!ex) {
                this.errorMsg = "File " + fr.getFilename() + " does not exist";
            }
            return ex;
        }
        this.errorMsg = "The object is no FileRepresentation.";
        return false;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMsg;
    }

    @Override
    public FileExistsValidator clone() throws CloneNotSupportedException {
        return (FileExistsValidator)super.clone();
    }
}

