/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.parameters.validation;

import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.GalaxyConvertible;
import de.jstacs.parameters.validation.ParameterValidator;
import java.util.regex.Pattern;

public class RegExpValidator
implements ParameterValidator,
GalaxyConvertible {
    private String regExp;
    private String errorMessage;

    public RegExpValidator(String regExp) {
        this.regExp = regExp;
    }

    public RegExpValidator(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, "RegExpValidator");
        this.regExp = (String)XMLParser.extractObjectForTags(xml, "regExp");
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.regExp, "regExp");
        XMLParser.addTags(xml, "RegExpValidator");
        return xml;
    }

    @Override
    public boolean checkValue(Object value) {
        if (value == null) {
            this.errorMessage = "Value is null.";
            return false;
        }
        if (!(value instanceof String)) {
            this.errorMessage = "Value is no String.";
            return false;
        }
        String str = (String)value;
        if (Pattern.matches(this.regExp, str)) {
            this.errorMessage = null;
            return true;
        }
        this.errorMessage = "String does not match " + this.regExp;
        return false;
    }

    public String getRegExp() {
        return this.regExp;
    }

    @Override
    public String getErrorMessage() {
        return this.errorMessage;
    }

    @Override
    public RegExpValidator clone() throws CloneNotSupportedException {
        RegExpValidator val = (RegExpValidator)super.clone();
        return val;
    }

    @Override
    public void toGalaxy(String namePrefix, String configPrefix, int depth, StringBuffer descBuffer, StringBuffer configBuffer, boolean addLine, int indentation) throws Exception {
        XMLParser.addIndentation(descBuffer, indentation);
        descBuffer.append("<validator type=\"regex\" message=\"Value does not match " + XMLParser.escape(this.regExp) + ".\">^" + XMLParser.escape(this.regExp) + "$</validator>\n");
    }

    @Override
    public void fromGalaxy(String namePrefix, StringBuffer command) throws Exception {
    }

    @Override
    public void toGalaxyTest(String namePrefix, int depth, StringBuffer testBuffer, int indentation) throws Exception {
    }
}

