/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.Base64;
import javax.imageio.ImageIO;

public class ImageResult
extends Result {
    private BufferedImage image;

    public ImageResult(String name, String comment, BufferedImage image) {
        super(name, comment, DataType.PNG);
        this.image = image;
    }

    public ImageResult(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public BufferedImage getValue() {
        return this.image;
    }

    @Override
    public String getXMLTag() {
        return "ImageResult";
    }

    @Override
    protected void appendFurtherInfos(StringBuffer xml) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream(1000);
        try {
            ImageIO.write((RenderedImage)this.image, "png", baos);
        }
        catch (IOException e) {
            throw new RuntimeException(e.getMessage());
        }
        XMLParser.appendObjectWithTags(xml, Base64.getEncoder().encodeToString(baos.toByteArray()), "image");
    }

    @Override
    protected void extractFurtherInfos(StringBuffer representation) throws NonParsableException {
        try {
            byte[] bytearray = Base64.getDecoder().decode((String)XMLParser.extractObjectForTags(representation, "image"));
            this.image = ImageIO.read(new ByteArrayInputStream(bytearray));
        }
        catch (Exception e) {
            throw new NonParsableException(e.getMessage());
        }
    }

    public String toString() {
        return String.valueOf(this.name) + ": [image]";
    }
}

