/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable;

import de.jstacs.NotTrainedException;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.IndependentProductDiffSS;
import de.jstacs.sequenceScores.statisticalModels.differentiable.AbstractDifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.VariableLengthDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.mixture.AbstractMixtureDiffSM;
import de.jstacs.utils.Normalisation;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class IndependentProductDiffSM
extends IndependentProductDiffSS
implements DifferentiableStatisticalModel,
MutableMotifDiscoverer {
    private int[] motifs;
    private int[] componentsUntilNow;
    private int[] motifIndexArray;
    private int[] components;
    private int[] componentIndexArray;
    private double ess;
    private HashSet<Integer> hash;

    public IndependentProductDiffSM(double ess, boolean plugIn, DifferentiableStatisticalModel ... functions) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        this(ess, plugIn, functions, IndependentProductDiffSS.getLengthArray(functions));
    }

    public IndependentProductDiffSM(double ess, boolean plugIn, DifferentiableStatisticalModel[] functions, int[] length) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        this(ess, plugIn, functions, null, length, null);
    }

    public IndependentProductDiffSM(double ess, boolean plugIn, DifferentiableStatisticalModel[] functions, int[] index, int[] length, boolean[] reverse) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        super(plugIn, (DifferentiableSequenceScore[])functions, index, length, reverse);
        this.ess = ess;
        this.prepare();
    }

    private void prepare() {
        this.motifs = new int[this.score.length + 1];
        this.components = new int[this.score.length];
        int i = 0;
        while (i < this.score.length) {
            this.motifs[i + 1] = this.motifs[i];
            if (this.score[i] instanceof MotifDiscoverer) {
                int n = i + 1;
                this.motifs[n] = this.motifs[n] + ((MotifDiscoverer)((Object)this.score[i])).getNumberOfMotifs();
            }
            this.components[i] = this.score[i] instanceof AbstractMixtureDiffSM ? ((AbstractMixtureDiffSM)this.score[i]).getNumberOfComponents() : (this.score[i] instanceof MotifDiscoverer ? ((MotifDiscoverer)((Object)this.score[i])).getNumberOfComponents() : 1);
            ++i;
        }
        this.componentsUntilNow = new int[this.index.length + 1];
        this.componentsUntilNow[0] = 1;
        i = 0;
        while (i < this.index.length) {
            this.componentsUntilNow[i + 1] = this.componentsUntilNow[i] * this.components[this.index[i]];
            ++i;
        }
        this.motifIndexArray = new int[3];
        this.componentIndexArray = new int[this.index.length];
    }

    public IndependentProductDiffSM(StringBuffer source) throws NonParsableException {
        super(source);
    }

    @Override
    public IndependentProductDiffSM clone() throws CloneNotSupportedException {
        IndependentProductDiffSM clone = (IndependentProductDiffSM)super.clone();
        clone.motifs = (int[])this.motifs.clone();
        clone.motifIndexArray = (int[])this.motifIndexArray.clone();
        clone.components = (int[])this.components.clone();
        clone.componentsUntilNow = (int[])this.componentsUntilNow.clone();
        clone.componentIndexArray = (int[])this.componentIndexArray.clone();
        return clone;
    }

    private int getSFIndex(int index) {
        int i = 1;
        while (i < this.startIndexOfParams.length && index >= this.startIndexOfParams[i]) {
            ++i;
        }
        return i - 1;
    }

    @Override
    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        int i = this.getSFIndex(index);
        return ((DifferentiableStatisticalModel)this.score[i]).getSizeOfEventSpaceForRandomVariablesOfParameter(index - this.startIndexOfParams[i]);
    }

    @Override
    public double getLogNormalizationConstant() {
        double norm = 0.0;
        int i = 0;
        while (i < this.index.length) {
            norm = this.isVariable[this.index[i]] ? (norm += ((VariableLengthDiffSM)this.score[this.index[i]]).getLogNormalizationConstant(this.partialLength[i])) : (norm += ((DifferentiableStatisticalModel)this.score[this.index[i]]).getLogNormalizationConstant());
            ++i;
        }
        return norm;
    }

    @Override
    public double getLogPartialNormalizationConstant(int parameterIndex) throws Exception {
        int i = 0;
        int j = this.getSFIndex(parameterIndex);
        int k = parameterIndex - this.startIndexOfParams[j];
        double normOfOther = 0.0;
        double myNorm = 0.0;
        double myPartNorm = Double.NEGATIVE_INFINITY;
        while (i < this.index.length) {
            if (this.index[i] == j) {
                double n;
                double p;
                if (this.isVariable[this.index[i]]) {
                    p = ((VariableLengthDiffSM)this.score[j]).getLogPartialNormalizationConstant(k, this.partialLength[i]);
                    n = ((VariableLengthDiffSM)this.score[j]).getLogNormalizationConstant(this.partialLength[i]);
                } else {
                    p = ((DifferentiableStatisticalModel)this.score[j]).getLogPartialNormalizationConstant(k);
                    n = ((DifferentiableStatisticalModel)this.score[j]).getLogNormalizationConstant();
                }
                myPartNorm = Normalisation.getLogSum(myPartNorm + n, myNorm + p);
                myNorm += n;
            } else {
                normOfOther = this.isVariable[this.index[i]] ? (normOfOther += ((VariableLengthDiffSM)this.score[this.index[i]]).getLogNormalizationConstant(this.partialLength[i])) : (normOfOther += ((DifferentiableStatisticalModel)this.score[this.index[i]]).getLogNormalizationConstant());
            }
            ++i;
        }
        return normOfOther + myPartNorm;
    }

    @Override
    public double getESS() {
        return this.ess;
    }

    @Override
    protected void extractFurtherInformation(StringBuffer rep) throws NonParsableException {
        this.ess = XMLParser.extractObjectForTags(rep, "ess", Double.TYPE);
        this.prepare();
    }

    @Override
    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    @Override
    public int getNumberOfParameters() {
        if (this.startIndexOfParams == null) {
            return -1;
        }
        return this.startIndexOfParams[this.score.length];
    }

    @Override
    public int getNumberOfRecommendedStarts() {
        int max = this.score[0].getNumberOfRecommendedStarts();
        int i = 1;
        while (i < this.score.length) {
            max = Math.max(max, this.score[i].getNumberOfRecommendedStarts());
            ++i;
        }
        return max;
    }

    @Override
    public void setParameters(double[] params, int start) {
        int i = 0;
        while (i < this.score.length) {
            this.score[i].setParameters(params, start + this.startIndexOfParams[i]);
            ++i;
        }
    }

    @Override
    protected StringBuffer getFurtherInformation() {
        StringBuffer xml = new StringBuffer(100);
        XMLParser.appendObjectWithTags(xml, this.ess, "ess");
        return xml;
    }

    @Override
    public double getLogPriorTerm() {
        double val = 0.0;
        int i = 0;
        while (i < this.score.length) {
            val += ((DifferentiableStatisticalModel)this.score[i]).getLogPriorTerm();
            ++i;
        }
        return val;
    }

    @Override
    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        int i = 0;
        while (i < this.score.length) {
            ((DifferentiableStatisticalModel)this.score[i]).addGradientOfLogPriorTerm(grad, start + this.startIndexOfParams[i]);
            ++i;
        }
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos) throws Exception {
        return this.getLogScoreFor(sequence, startpos) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence) throws Exception {
        return this.getLogScoreFor(sequence) - this.getLogNormalizationConstant();
    }

    @Override
    public double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        if (endpos - startpos + 1 != this.length) {
            throw new IllegalArgumentException();
        }
        return this.getLogProbFor(sequence, startpos);
    }

    private void fillMotifIndexArray(int motifIndex) throws IndexOutOfBoundsException {
        this.motifIndexArray[0] = -1;
        int i = 1;
        while (i < this.motifs.length) {
            if (this.score[i - 1] instanceof MotifDiscoverer && motifIndex >= this.motifs[i - 1] && motifIndex < this.motifs[i]) {
                this.motifIndexArray[0] = i - 1;
                this.motifIndexArray[1] = motifIndex - this.motifs[this.motifIndexArray[0]];
                this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
                return;
            }
            ++i;
        }
        throw new IndexOutOfBoundsException("Try to get information about motif " + motifIndex + " (but # motifs = " + this.getNumberOfMotifs() + ").");
    }

    @Override
    public void initializeMotif(int motifIndex, DataSet data, double[] weights) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).initializeMotif(this.motifIndexArray[1], data, weights);
            this.setParamsStarts();
        } else {
            System.out.println("warning: not possible");
        }
    }

    @Override
    public void initializeMotifRandomly(int motif) throws Exception {
        this.fillMotifIndexArray(motif);
        if (this.motifIndexArray[2] >= 0) {
            ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).initializeMotifRandomly(this.motifIndexArray[1]);
            this.setParamsStarts();
        } else {
            System.out.println("warning: not possible");
        }
    }

    @Override
    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            boolean b = ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).modifyMotif(this.motifIndexArray[1], offsetLeft, offsetRight);
            this.setParamsStarts();
            return b;
        }
        return false;
    }

    private void fillComponentIndexArray(int componentIndex) throws IndexOutOfBoundsException {
        if (componentIndex < 0 || componentIndex > this.getNumberOfComponents()) {
            throw new IndexOutOfBoundsException();
        }
        int i = this.index.length - 1;
        while (i >= 0) {
            this.componentIndexArray[i] = componentIndex % this.components[i];
            componentIndex /= this.components[i];
            --i;
        }
    }

    private void fillMotifIndexArrayForComponent(int componentIndex, int motifIndex) throws IndexOutOfBoundsException {
        this.fillComponentIndexArray(componentIndex);
        int i = -1;
        int anz = 0;
        do {
            motifIndex -= anz;
            if (++i == this.score.length) {
                throw new IndexOutOfBoundsException();
            }
            this.fillHashWith(i);
        } while ((anz = this.hash.size()) != 0 && motifIndex < anz);
        this.motifIndexArray[0] = i;
        this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
        int[] specificMotifs = new int[anz];
        Iterator<Integer> it = this.hash.iterator();
        i = 0;
        while (i < anz) {
            specificMotifs[i] = it.next();
            ++i;
        }
        Arrays.sort(specificMotifs);
        this.motifIndexArray[1] = specificMotifs[motifIndex];
    }

    private void fillHashWith(int scoreIndex) {
        if (this.hash == null) {
            this.hash = new HashSet();
        }
        if (scoreIndex == this.score.length) {
            throw new IndexOutOfBoundsException();
        }
        this.hash.clear();
        if (this.score[scoreIndex] instanceof MotifDiscoverer) {
            MotifDiscoverer md = (MotifDiscoverer)((Object)this.score[scoreIndex]);
            int idx = 0;
            while (idx < this.index.length) {
                if (this.index[idx] == scoreIndex) {
                    int m = md.getNumberOfMotifsInComponent(this.components[idx]);
                    int l = 0;
                    while (l < m) {
                        int h = md.getGlobalIndexOfMotifInComponent(this.components[idx], l);
                        if (!this.hash.contains(h)) {
                            this.hash.add(h);
                        }
                        ++l;
                    }
                }
                ++idx;
            }
        }
    }

    @Override
    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        this.fillMotifIndexArrayForComponent(component, motif);
        return this.motifs[this.motifIndexArray[0]] + this.motifIndexArray[1];
    }

    @Override
    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        int c = 0;
        int i = 0;
        while (i < this.index.length) {
            int idx = this.score[this.index[i]] instanceof AbstractMixtureDiffSM ? (this.reverse[i] ? ((AbstractMixtureDiffSM)this.score[this.index[i]]).getIndexOfMaximalComponentFor(sequence.reverseComplement(), sequence.getLength() - this.start[i] - this.partialLength[i]) : ((AbstractMixtureDiffSM)this.score[this.index[i]]).getIndexOfMaximalComponentFor(sequence, this.start[i])) : (this.score[i] instanceof MotifDiscoverer ? (this.reverse[i] ? ((MotifDiscoverer)((Object)this.score[this.index[i]])).getIndexOfMaximalComponentFor(sequence.reverseComplement(sequence.getLength() - this.start[i] - this.partialLength[i], sequence.getLength() - this.start[i])) : ((MotifDiscoverer)((Object)this.score[this.index[i]])).getIndexOfMaximalComponentFor(sequence.getSubSequence(this.score[i].getAlphabetContainer(), this.start[i], this.partialLength[i]))) : 0);
            c += this.componentsUntilNow[i] * idx;
            ++i;
        }
        return c;
    }

    @Override
    public int getMotifLength(int motif) {
        this.fillMotifIndexArray(motif);
        return ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getMotifLength(this.motifIndexArray[1]);
    }

    @Override
    public int getNumberOfComponents() {
        return this.componentsUntilNow[this.index.length];
    }

    @Override
    public int getNumberOfMotifs() {
        return this.motifs[this.score.length];
    }

    @Override
    public int getNumberOfMotifsInComponent(int component) {
        this.fillComponentIndexArray(component);
        int i = 0;
        int anz = 0;
        while (i < this.score.length) {
            this.fillHashWith(i);
            anz += this.hash.size();
            ++i;
        }
        return anz;
    }

    @Override
    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile dist) throws Exception {
        this.fillMotifIndexArrayForComponent(component, motif);
        MotifDiscoverer md = (MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]]);
        int w = md.getMotifLength(this.motifIndexArray[1]);
        double[] erg = new double[this.length - w + 1];
        Arrays.fill(erg, Double.NEGATIVE_INFINITY);
        int i = 0;
        while (i < this.index.length) {
            if (this.index[i] == this.motifIndexArray[0]) {
                double[] part;
                int idx = 0;
                while (md.getGlobalIndexOfMotifInComponent(this.componentIndexArray[i], idx) != this.motifIndexArray[1]) {
                    ++idx;
                }
                if (this.reverse[i]) {
                    part = md.getProfileOfScoresFor(this.componentIndexArray[i], idx, sequence.reverseComplement(), sequence.getLength() - startpos - this.start[i] - this.partialLength[i], dist);
                    System.arraycopy(part, 0, erg, this.start[i], this.partialLength[i] - w + 1);
                } else {
                    part = md.getProfileOfScoresFor(this.componentIndexArray[i], idx, sequence, startpos + this.start[i], dist);
                    int k = this.start[i];
                    int j = part.length - 1;
                    while (j >= 0) {
                        erg[k] = part[j];
                        --j;
                        ++k;
                    }
                }
            }
            ++i;
        }
        return erg;
    }

    @Override
    public double[] getStrandProbabilitiesFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        return new double[]{0.5, 0.5};
    }

    @Override
    public boolean isNormalized() {
        return AbstractDifferentiableStatisticalModel.isNormalized(this.score);
    }

    @Override
    public void adjustHiddenParameters(int index, DataSet[] data, double[][] weights) throws Exception {
        DataSet[] part = new DataSet[data.length];
        int i = 0;
        while (i < this.score.length) {
            if (this.score[i] instanceof MutableMotifDiscoverer) {
                int a = this.extractSequenceParts(i, data, part);
                double[][] help = a == 1 ? weights : this.extractWeights(a, weights);
                ((MutableMotifDiscoverer)((Object)this.score[i])).adjustHiddenParameters(index, part, help);
            }
            ++i;
        }
        this.setParamsStarts();
    }

    @Override
    public DataSet emitDataSet(int numberOfSequences, int ... seqLength) throws NotTrainedException, Exception {
        throw new Exception("Standard implementation of emitDataSet used for " + this.getInstanceName() + ". You have to overwrite this method to use it in a proper way.");
    }

    @Override
    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        throw new UnsupportedOperationException("The maximal markov order for this model in undefined.");
    }
}

