/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures;

import de.jstacs.data.DataSet;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.structureLearning.measures.Measure;

public class FixedStructure
extends Measure {
    private int[][] structure;

    public FixedStructure(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    protected void fromXML(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.structure = (int[][])XMLParser.extractObjectForTags(xml, "structure");
    }

    public FixedStructure(int[][] structure) {
        this.structure = new int[structure.length][];
        int i = 0;
        while (i < structure.length) {
            this.structure[i] = new int[structure[i].length + 1];
            System.arraycopy(structure[i], 0, this.structure[i], 0, structure[i].length);
            this.structure[i][this.structure[i].length - 1] = i;
            ++i;
        }
    }

    @Override
    public String getXMLTag() {
        return "Fixed";
    }

    @Override
    public String getInstanceName() {
        return this.getXMLTag();
    }

    @Override
    public int[][] getParents(DataSet fg, DataSet bg, double[] weightsFg, double[] weightsBg, int length) throws Exception {
        return (int[][])ArrayHandler.clone((Cloneable[])this.structure);
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.structure, "structure");
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }
}

