/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.discrete;

import de.jstacs.algorithms.graphs.UnionFind;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.Constraint;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.CombinationIterator;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.InhCondProb;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEM;
import de.jstacs.sequenceScores.statisticalModels.trainable.discrete.inhomogeneous.MEMConstraint;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.StringTokenizer;

public class ConstraintManager {
    private ConstraintManager() {
    }

    public static void computeFreqs(double ess, Constraint ... constr) throws IllegalArgumentException {
        if (ess < 0.0) {
            throw new IllegalArgumentException("The ess has to be non-negative.");
        }
        int counter1 = 0;
        while (counter1 < constr.length) {
            constr[counter1].estimate(ess);
            ++counter1;
        }
    }

    public static double countInhomogeneous(AlphabetContainer alphabets, int length, DataSet data, double[] weights, boolean reset, Constraint ... constr) throws WrongAlphabetException, IllegalArgumentException {
        int counter1;
        int d = data.getNumberOfElements();
        double all = 0.0;
        if (weights != null && d != weights.length) {
            throw new IllegalArgumentException("The weights are not suitable for the data (wrong dimension).");
        }
        if (!alphabets.checkConsistency(data.getAlphabetContainer())) {
            throw new WrongAlphabetException("The alphabets of the model and the DataSet are not suitable.");
        }
        if (data.getElementLength() != length) {
            throw new IllegalArgumentException("The sequence length of the model and the DataSet are not suitable.");
        }
        if (reset) {
            counter1 = 0;
            while (counter1 < constr.length) {
                constr[counter1].reset();
                ++counter1;
            }
        }
        DataSet.ElementEnumerator ei = new DataSet.ElementEnumerator(data);
        if (weights == null) {
            all = d;
            counter1 = 0;
            while (counter1 < d) {
                Sequence seq = ei.nextElement();
                int counter2 = 0;
                while (counter2 < constr.length) {
                    constr[counter2].add(seq, 0, 1.0);
                    ++counter2;
                }
                ++counter1;
            }
        } else {
            counter1 = 0;
            while (counter1 < d) {
                Sequence seq = ei.nextElement();
                if (weights[counter1] > 0.0) {
                    all += weights[counter1];
                    int counter2 = 0;
                    while (counter2 < constr.length) {
                        constr[counter2].add(seq, 0, weights[counter1]);
                        ++counter2;
                    }
                } else if (weights[counter1] < 0.0) {
                    throw new IllegalArgumentException("All weights have to be non-negative. Violated in position " + counter1 + ".");
                }
                ++counter1;
            }
        }
        return all;
    }

    public static void drawFreqs(double ess, InhCondProb ... constr) throws IllegalArgumentException {
        if (ess < 0.0) {
            throw new IllegalArgumentException("The ess has to be non-negative.");
        }
        int counter1 = 0;
        while (counter1 < constr.length) {
            constr[counter1].drawParameters(ess);
            ++counter1;
        }
    }

    public static ArrayList<int[]> extract(int length, String encoded) throws IllegalArgumentException {
        StringTokenizer st = new StringTokenizer(encoded, ";");
        ArrayList<int[]> list = new ArrayList<int[]>();
        boolean[][] constrAbbrev = new boolean[length + 1][];
        constrAbbrev[0] = null;
        constrAbbrev[1] = new boolean[1];
        int i = 2;
        while (i < constrAbbrev.length) {
            constrAbbrev[i] = new boolean[length - i + 1];
            Arrays.fill(constrAbbrev[i], false);
            ++i;
        }
        while (st.hasMoreTokens()) {
            int m;
            String current = st.nextToken().trim();
            int mp = current.indexOf("m");
            int sp = current.indexOf("s");
            if (mp >= 0 && sp > 0) {
                m = Integer.parseInt(current.substring(mp + 1, sp));
                if (m > length) {
                    throw new IllegalArgumentException("The marginal order of " + m + " is not possible for length " + length);
                }
                String help = current.substring(sp + 1);
                if (help.equals("x")) {
                    i = 0;
                    while (i < constrAbbrev[m].length) {
                        constrAbbrev[m][i] = true;
                        ++i;
                    }
                    continue;
                }
                constrAbbrev[m][Integer.parseInt((String)current.substring((int)(sp + 1)))] = true;
                continue;
            }
            m = 0;
            StringTokenizer simple = new StringTokenizer(current, ",");
            int[] pos = new int[simple.countTokens()];
            mp = 0;
            while (simple.hasMoreTokens()) {
                i = Integer.parseInt(simple.nextToken());
                if (i >= 0 && i < length) {
                    pos[mp++] = i;
                    continue;
                }
                throw new IllegalArgumentException("Could not correctly parse \"" + current + "\".");
            }
            list.add(ConstraintManager.getSortedUnique(pos));
        }
        ConstraintManager.add(constrAbbrev, list);
        return list;
    }

    private static String unfold(String constraint, int startpos, int endpos) {
        ArrayList<int[]> list = ConstraintManager.extract(endpos - startpos, constraint);
        StringBuffer erg = new StringBuffer(list.size() * 10);
        int i = 0;
        while (i < list.size()) {
            int[] current = list.get(i);
            erg.append(current[0] + startpos);
            int j = 1;
            while (j < current.length) {
                erg.append("," + (current[j] + startpos));
                ++j;
            }
            erg.append(";");
            ++i;
        }
        return erg.toString();
    }

    public static double getEntropy(Constraint c) {
        double h = 0.0;
        int i = 0;
        double[] temps = new double[c.getNumberOfSpecificConstraints()];
        while (i < temps.length) {
            if (c.getFreq(i) > 0.0) {
                temps[i] = c.getFreq(i) * Math.log(c.getFreq(i));
            }
            ++i;
        }
        Arrays.sort(temps);
        i = 0;
        while (i < temps.length) {
            h -= temps[i];
            ++i;
        }
        return h;
    }

    public static double getLogGammaSum(Constraint c, double ess) {
        int i = 0;
        int l = c.getNumberOfSpecificConstraints();
        double pc = ess / (double)l;
        double sum = (double)l * Gamma.logOfGamma((double)pc);
        while (i < l) {
            sum -= Gamma.logOfGamma((double)(c.getCount(i++) + pc));
        }
        return sum;
    }

    public static void reduce(AbstractList<int[]> list) {
        int counter1 = 0;
        while (counter1 < list.size()) {
            int[] helpPos = list.get(counter1);
            int counter2 = counter1 + 1;
            while (counter2 < list.size()) {
                int[] current = list.get(counter2);
                if (helpPos.length < current.length) {
                    if (ConstraintManager.isSubset(helpPos, current)) {
                        list.remove(counter1);
                        --counter1;
                        break;
                    }
                    ++counter2;
                    continue;
                }
                if (ConstraintManager.isSubset(current, helpPos)) {
                    list.remove(counter2);
                    continue;
                }
                ++counter2;
            }
            ++counter1;
        }
    }

    private static void add(boolean[][] constrAbbrev, ArrayList<int[]> list) {
        int distance;
        int length = constrAbbrev.length - 1;
        int max = 0;
        int counter1 = 1;
        int counter2 = 1;
        while (counter2 <= length) {
            distance = 0;
            while (distance < constrAbbrev[counter2].length) {
                if (constrAbbrev[counter2][distance]) {
                    max = counter2;
                }
                ++distance;
            }
            ++counter2;
        }
        CombinationIterator c = new CombinationIterator(length, max);
        while (counter1 <= max) {
            counter2 = 0;
            while (counter2 < constrAbbrev[counter1].length && !constrAbbrev[counter1][counter2]) {
                ++counter2;
            }
            if (counter2 != constrAbbrev[counter1].length) {
                c.setCurrentLength(counter1);
                do {
                    int[] current = c.getCombination();
                    distance = 1 - counter1;
                    counter2 = 1;
                    while (counter2 < counter1) {
                        distance += current[counter2] - current[counter2++ - 1];
                    }
                    if (!constrAbbrev[counter1][distance]) continue;
                    list.add(current);
                } while (c.next());
            }
            ++counter1;
        }
    }

    /*
     * Unable to fully structure code
     */
    private static int[] getIntersection(int[] array1, int[] array2) {
        counter1 = 0;
        counter2 = 0;
        length = 0;
        zerg = new int[Math.min(array1.length, array2.length)];
        ** GOTO lbl16
        {
            ++counter1;
            do {
                if (counter1 < array1.length && array1[counter1] < array2[counter2]) continue block0;
                if (counter1 >= array1.length) continue;
                while (counter2 < array2.length && array1[counter1] > array2[counter2]) {
                    ++counter2;
                }
                if (counter2 >= array2.length || array1[counter1] != array2[counter2]) continue;
                zerg[length++] = array1[counter1++];
                ++counter2;
lbl16:
                // 4 sources

            } while (counter1 < array1.length && counter2 < array2.length);
        }
        erg = new int[length];
        System.arraycopy(zerg, 0, erg, 0, length);
        return erg;
    }

    private static int[] getSortedUnique(int[] pos) throws IllegalArgumentException {
        int[] sorted = new int[pos.length];
        System.arraycopy(pos, 0, sorted, 0, pos.length);
        Arrays.sort(sorted);
        int i = 1;
        while (i < pos.length && sorted[i - 1] < sorted[i]) {
            ++i;
        }
        if (i < sorted.length) {
            throw new IllegalArgumentException("The position array is not unique.");
        }
        return sorted;
    }

    /*
     * Unable to fully structure code
     */
    private static boolean isSubset(int[] candidateSubset, int[] set) {
        counter1 = 0;
        counter2 = 0;
        ** GOTO lbl11
        {
            ++counter1;
            do {
                if (counter1 < set.length && set[counter1] < candidateSubset[counter2]) continue block0;
                if (counter1 == set.length || set[counter1] > candidateSubset[counter2]) {
                    return false;
                }
                ++counter2;
                ++counter1;
lbl11:
                // 2 sources

            } while (counter2 < candidateSubset.length);
        }
        return true;
    }

    private static ArrayList[] split(AbstractList<int[]> list, int length, int[][] indices) {
        int counter1 = 0;
        ArrayList[] constr = new ArrayList[indices.length];
        int[] component = new int[length];
        while (counter1 < indices.length) {
            constr[counter1] = new ArrayList();
            int counter2 = 0;
            while (counter2 < indices[counter1].length) {
                component[indices[counter1][counter2]] = counter1;
                ++counter2;
            }
            ++counter1;
        }
        counter1 = 0;
        while (counter1 < list.size()) {
            int[] current = list.get(counter1);
            constr[component[current[0]]].add(current);
            ++counter1;
        }
        return constr;
    }

    private static int[][] unionFind(AbstractList<int[]> list, int[] alphabetLength, int leafOutIndex) {
        UnionFind uf = new UnionFind(alphabetLength.length);
        int counter1 = 0;
        while (counter1 < list.size()) {
            if (counter1 != leafOutIndex) {
                int[] current = list.get(counter1);
                int counter2 = 1;
                while (counter2 < current.length) {
                    uf.union(current[0], current[counter2]);
                    ++counter2;
                }
            }
            ++counter1;
        }
        return uf.getComponents();
    }

    public static MEMConstraint[] createConstraints(AbstractList<int[]> list, int[] alphabetLength, int[] indices) {
        if (alphabetLength.length == indices.length) {
            return ConstraintManager.createConstraints(list, alphabetLength);
        }
        int[] corrected = new int[alphabetLength.length];
        int i = 0;
        while (i < indices.length) {
            corrected[indices[i]] = i++;
        }
        MEMConstraint[] constr = new MEMConstraint[list.size()];
        i = 0;
        while (i < constr.length) {
            int[] pos = list.get(i);
            int[] corPos = new int[pos.length];
            int j = 0;
            while (j < pos.length) {
                corPos[j] = corrected[pos[j]];
                ++j;
            }
            constr[i] = new MEMConstraint(pos, alphabetLength, corPos);
            ++i;
        }
        return constr;
    }

    public static MEMConstraint[] createConstraints(AbstractList<int[]> list, int[] alphabetLength) {
        MEMConstraint[] constr = new MEMConstraint[list.size()];
        int i = 0;
        while (i < constr.length) {
            constr[i] = new MEMConstraint(list.get(i), alphabetLength);
            ++i;
        }
        return constr;
    }

    private static void addDivided(ArrayList<MEM> mems, ArrayList<int[]> constr, int[] indices, int[] alphabetLength) {
        if (constr.size() == 1) {
            mems.add(new MEM(constr.get(0), alphabetLength, null));
        } else {
            int counter1 = constr.size() - 1;
            while (counter1 >= 0) {
                int[][] parts = ConstraintManager.unionFind(constr, alphabetLength, counter1);
                if (parts.length > 1) {
                    int[] current = constr.remove(counter1);
                    ArrayList<int[]> cond = new ArrayList<int[]>();
                    ArrayList[] splittedConstr = ConstraintManager.split(constr, alphabetLength.length, parts);
                    int counter2 = 0;
                    while (counter2 < parts.length) {
                        if (splittedConstr[counter2].size() > 0) {
                            cond.add(ConstraintManager.getIntersection(current, parts[counter2]));
                        }
                        ++counter2;
                    }
                    mems.add(new MEM(current, alphabetLength, (int[][])cond.toArray((T[])new int[0][])));
                    counter2 = 0;
                    while (counter2 < parts.length) {
                        if (splittedConstr[counter2].size() > 0) {
                            ConstraintManager.addDivided(mems, splittedConstr[counter2], parts[counter2], alphabetLength);
                        }
                        ++counter2;
                    }
                    return;
                }
                --counter1;
            }
            mems.add(new MEM(constr, alphabetLength, indices));
        }
    }

    public static MEM[] disconnect(AbstractList<int[]> list, int[] alphabetLength, Decomposition decomposition) {
        if (decomposition == Decomposition.DECOMPOSE_NOTHING) {
            int[] ind = new int[alphabetLength.length];
            int counter1 = 0;
            while (counter1 < ind.length) {
                ind[counter1] = counter1;
                ++counter1;
            }
            return new MEM[]{new MEM(list, alphabetLength, ind)};
        }
        if (decomposition == Decomposition.DECOMPOSE_UNCONNECTED || decomposition == Decomposition.DECOMPOSE_LESS_CONNECTED) {
            int[][] indices = ConstraintManager.unionFind(list, alphabetLength, -1);
            ArrayList[] constr = ConstraintManager.split(list, alphabetLength.length, indices);
            if (decomposition == Decomposition.DECOMPOSE_UNCONNECTED) {
                MEM[] res = new MEM[indices.length];
                int counter1 = 0;
                while (counter1 < indices.length) {
                    res[counter1] = new MEM(constr[counter1], alphabetLength, indices[counter1]);
                    ++counter1;
                }
                return res;
            }
            ArrayList<MEM> mems = new ArrayList<MEM>(indices.length * 2);
            int counter1 = 0;
            while (counter1 < indices.length) {
                ConstraintManager.addDivided(mems, constr[counter1], indices[counter1], alphabetLength);
                ++counter1;
            }
            return mems.toArray(new MEM[0]);
        }
        throw new IllegalArgumentException("The choice of decomposition was illegal.");
    }

    public static enum Decomposition {
        DECOMPOSE_NOTHING,
        DECOMPOSE_UNCONNECTED,
        DECOMPOSE_LESS_CONNECTED;

    }
}

