/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models;

import de.jstacs.data.WrongAlphabetException;
import de.jstacs.io.NonParsableException;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.SamplingHigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.PhyloDiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.training.SamplingHMMTrainingParameterSet;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.SamplingTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import java.util.Random;

public class SamplingPhyloHMM
extends SamplingHigherOrderHMM {
    static Random r = new Random();

    public SamplingPhyloHMM(SamplingHMMTrainingParameterSet trainingParameterSet, String[] name, int[] emissionIdx, boolean[] forward, PhyloDiscreteEmission[] emission, TransitionElement ... te) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException, Exception {
        super(trainingParameterSet, name, emissionIdx, forward, emission, te);
    }

    public SamplingPhyloHMM(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    @Override
    public String getInstanceName() {
        return "PhyloHMM(" + this.transition.getMaximalMarkovOrder() + ")";
    }

    @Override
    protected void getNewParameters() throws Exception {
        boolean accepted = false;
        while (!accepted) {
            double acceptProb = 0.0;
            acceptProb = this.getLogProposalPosteriorFromStatistic() - this.getLogPosteriorFromStatistic();
            this.drawFromStatistics();
            acceptProb += this.getLogPosteriorFromStatistic() - this.getLogProposalPosteriorFromStatistic();
            acceptProb = Math.exp(acceptProb);
            if (!(acceptProb >= 1.0) && SamplingPhyloHMM.drawIndexFrom(new double[]{1.0 - acceptProb, acceptProb}) <= 0) continue;
            this.acceptParameters();
            accepted = true;
        }
    }

    private double getLogProposalPosteriorFromStatistic() {
        double logPosterior = ((SamplingTransition)this.transition).getLogPosteriorFromStatistic();
        int e = 0;
        while (e < this.emission.length) {
            logPosterior += ((PhyloDiscreteEmission)this.emission[e]).getLogProposalPosteriorFromStatistic();
            ++e;
        }
        return logPosterior;
    }

    private static int drawIndexFrom(double[] distribution) {
        int index = 0;
        double p = r.nextDouble();
        while (index < distribution.length && p > distribution[index]) {
            p -= distribution[index++];
        }
        if (index == distribution.length) {
            --index;
        }
        return index;
    }
}

