/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions;

import de.jstacs.Storable;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.NonParsableException;
import de.jstacs.io.XMLParser;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.TrainableTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.Transition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.utils.IntList;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedList;

public class BasicHigherOrderTransition
implements TrainableTransition {
    protected AbstractTransitionElement[] transitions;
    protected boolean[] isSilent;
    protected int maximalMarkovOrder;
    protected int maxInDegree;
    protected int[][][] lookup;
    private static final String XML_TAG = "BasicHigherOrderTransition";

    public BasicHigherOrderTransition(boolean[] isSilent, AbstractTransitionElement ... transitions) throws Exception {
        this.isSilent = (boolean[])isSilent.clone();
        this.transitions = (AbstractTransitionElement[])ArrayHandler.clone((Cloneable[])transitions);
        this.init();
    }

    public BasicHigherOrderTransition(StringBuffer xml) throws NonParsableException {
        xml = XMLParser.extractForTag(xml, this.getXMLTag());
        this.transitions = (AbstractTransitionElement[])XMLParser.extractObjectForTags(xml, "transitions");
        this.isSilent = (boolean[])XMLParser.extractObjectForTags(xml, "isSilent");
        this.extractFurtherInformation(xml);
        try {
            this.init();
        }
        catch (Exception e) {
            NonParsableException npe = new NonParsableException(e.getMessage());
            throw npe;
        }
    }

    @Override
    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer();
        XMLParser.appendObjectWithTags(xml, this.transitions, "transitions");
        XMLParser.appendObjectWithTags(xml, this.isSilent, "isSilent");
        this.appendFurtherInformation(xml);
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected String getXMLTag() {
        return XML_TAG;
    }

    protected void appendFurtherInformation(StringBuffer xml) {
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    @Override
    public BasicHigherOrderTransition clone() throws CloneNotSupportedException {
        BasicHigherOrderTransition clone = (BasicHigherOrderTransition)super.clone();
        clone.isSilent = this.isSilent == null ? null : (boolean[])this.isSilent.clone();
        clone.lookup = (int[][][])ArrayHandler.clone((Cloneable[])this.lookup);
        clone.transitions = (AbstractTransitionElement[])ArrayHandler.clone((Cloneable[])this.transitions);
        return clone;
    }

    private void addAndTopsortTransitionsWithSilentStates(IntList currentLayer, IntList nextLayer, IntList lookup, boolean[] canBeUsed, boolean[] used, int[] inDeg, boolean[] nextUsed) {
        int idx;
        int i = 0;
        Arrays.fill(canBeUsed, false);
        Arrays.fill(used, false);
        Arrays.fill(inDeg, 0);
        LinkedList<Integer> roots = new LinkedList<Integer>();
        int thresh = currentLayer.length();
        while (i < currentLayer.length()) {
            idx = currentLayer.get(i);
            int n = this.transitions[idx].getNumberOfChildren();
            int s = 0;
            while (s < n) {
                int d = this.transitions[idx].getDescendant(s);
                if (this.isSilent[this.transitions[idx].getChild(s)]) {
                    if (!canBeUsed[d]) {
                        currentLayer.add(d);
                        canBeUsed[d] = true;
                    }
                    if (i >= thresh) {
                        int n2 = d;
                        inDeg[n2] = inDeg[n2] + 1;
                    }
                } else if (!nextUsed[d]) {
                    nextLayer.add(d);
                }
                ++s;
            }
            ++i;
        }
        int t = 0;
        while (t < inDeg.length) {
            if (canBeUsed[t]) {
                if (inDeg[t] == 0) {
                    roots.add(t);
                }
            } else {
                used[t] = true;
            }
            ++t;
        }
        while (roots.size() > 0) {
            idx = (Integer)roots.removeFirst();
            used[idx] = true;
            lookup.add(idx);
            int num = this.transitions[idx].getNumberOfChildren();
            int j = 0;
            while (j < num) {
                int child = this.transitions[idx].getDescendant(j);
                if (canBeUsed[child]) {
                    int n = child;
                    inDeg[n] = inDeg[n] - 1;
                    if (inDeg[child] == 0) {
                        roots.addLast(child);
                    }
                }
                ++j;
            }
        }
        t = 0;
        while (t < inDeg.length) {
            if (canBeUsed[t] && !used[t]) {
                String s = Arrays.toString(this.transitions[t].states);
                throw new IllegalArgumentException("Check transition element " + t + ": " + Arrays.toString(this.transitions[t].context) + " -> {" + s.substring(1, s.length() - 1) + "}");
            }
            ++t;
        }
    }

    private void createLookup(int layer, IntList current) {
        this.lookup[0][layer] = current.toArray();
        this.lookup[1][layer] = new int[this.transitions.length];
        Arrays.fill(this.lookup[1][layer], -1);
        int i = 0;
        while (i < this.lookup[0][layer].length) {
            this.lookup[1][layer][this.lookup[0][layer][i]] = i;
            ++i;
        }
    }

    private void init() throws Exception {
        this.computeMaximalMarkovOrder();
        ArrayList<AbstractTransitionElement> elements = new ArrayList<AbstractTransitionElement>(this.transitions.length * 2);
        int t = 0;
        while (t < this.transitions.length) {
            elements.add(this.transitions[t]);
            ++t;
        }
        int t2 = 0;
        while (t2 < elements.size()) {
            AbstractTransitionElement te = (AbstractTransitionElement)elements.get(t2);
            int child = 0;
            while (child < te.getNumberOfChildren()) {
                int[] nextContext = te.getNextContext(child, this.maximalMarkovOrder);
                int s = 0;
                while (s < elements.size()) {
                    AbstractTransitionElement te2 = (AbstractTransitionElement)elements.get(s);
                    if (nextContext.length == te2.context.length) {
                        int c = 0;
                        while (c < nextContext.length && nextContext[c] == te2.context[c]) {
                            ++c;
                        }
                        if (c == nextContext.length) {
                            te.setIndexOfDescendantTransitionElement(child, s);
                        }
                    }
                    ++s;
                }
                if (te.getDescendant(child) == -1) {
                    if (this.maximalMarkovOrder == 0) {
                        te.setIndexOfDescendantTransitionElement(child, 0);
                    } else {
                        te.setIndexOfDescendantTransitionElement(child, elements.size());
                        elements.add(new TransitionElement(nextContext, null, null));
                    }
                }
                ++child;
            }
            ++t2;
        }
        if (elements.size() > this.transitions.length) {
            this.transitions = elements.toArray(new AbstractTransitionElement[0]);
        }
        int[] inDeg = new int[this.transitions.length];
        int t3 = 0;
        while (t3 < this.transitions.length) {
            int d = 0;
            while (d < this.transitions[t3].descendants.length) {
                int n = this.transitions[t3].descendants[d];
                inDeg[n] = inDeg[n] + 1;
                ++d;
            }
            int s = t3 + 1;
            while (s < this.transitions.length) {
                if (this.transitions[t3].hasSameContext(this.transitions[s])) {
                    throw new IllegalArgumentException("The context " + Arrays.toString(this.transitions[t3].context) + " is used by more than one TransitionElements.");
                }
                ++s;
            }
            ++t3;
        }
        this.maxInDegree = inDeg[0];
        int minInDegree = Integer.MAX_VALUE;
        int j = 0;
        int t4 = 1;
        while (t4 < this.transitions.length) {
            this.maxInDegree = Math.max(this.maxInDegree, inDeg[t4]);
            if ((minInDegree = Math.min(minInDegree, inDeg[t4])) > 0) {
                j = t4;
            }
            ++t4;
        }
        if (minInDegree <= 0) {
            throw new IllegalArgumentException("The in-degree of some TransitionElements is zero. " + this.transitions[j + 1]);
        }
        this.lookup = new int[2][this.maximalMarkovOrder + 1][];
        IntList currentLayer = new IntList();
        IntList nextLayer = new IntList();
        boolean[] canBeUsed = new boolean[this.transitions.length];
        boolean[] used = new boolean[this.transitions.length];
        boolean[] nextUsed = new boolean[this.transitions.length];
        Arrays.fill(nextUsed, false);
        IntList current = new IntList();
        if (this.maximalMarkovOrder == 0) {
            int i = 0;
            while (i < this.isSilent.length) {
                if (this.isSilent[i]) {
                    throw new IllegalArgumentException("A hidden Markov model of order zero is not alllowed to have any silent states.");
                }
                ++i;
            }
            current.add(0);
            this.createLookup(this.maximalMarkovOrder, current);
        } else {
            int t5 = 0;
            while (t5 < this.transitions.length) {
                if (this.transitions[t5].context.length == 0) {
                    currentLayer.add(t5);
                    current.add(t5);
                }
                ++t5;
            }
            this.addAndTopsortTransitionsWithSilentStates(currentLayer, nextLayer, current, canBeUsed, used, inDeg, nextUsed);
            this.createLookup(0, current);
            IntList help = nextLayer;
            nextLayer = currentLayer;
            currentLayer = help;
            int p = 1;
            while (p < this.maximalMarkovOrder) {
                current.clear();
                nextLayer.clear();
                Arrays.fill(nextUsed, false);
                int i = 0;
                while (i < currentLayer.length()) {
                    int idx = currentLayer.get(i);
                    current.add(idx);
                    int n = this.transitions[idx].getNumberOfChildren();
                    int s = 0;
                    while (s < n) {
                        int d = this.transitions[idx].descendants[s];
                        if (!this.isSilent[this.transitions[idx].getChild(s)] && !nextUsed[d]) {
                            nextLayer.add(d);
                            nextUsed[d] = true;
                        }
                        ++s;
                    }
                    ++i;
                }
                this.addAndTopsortTransitionsWithSilentStates(currentLayer, nextLayer, current, canBeUsed, used, inDeg, nextUsed);
                this.createLookup(p, current);
                help = nextLayer;
                nextLayer = currentLayer;
                currentLayer = help;
                ++p;
            }
            currentLayer.clear();
            nextLayer.clear();
            current.clear();
            Arrays.fill(used, false);
            t5 = 0;
            while (t5 < this.transitions.length) {
                if (this.transitions[t5].context.length == this.maximalMarkovOrder && !this.isSilent[this.transitions[t5].getLastContextState()]) {
                    currentLayer.add(t5);
                    current.add(t5);
                }
                ++t5;
            }
            this.addAndTopsortTransitionsWithSilentStates(currentLayer, nextLayer, current, canBeUsed, used, inDeg, nextUsed);
            this.createLookup(this.maximalMarkovOrder, current);
        }
    }

    @Override
    public void resetStatistic() {
        int t = 0;
        while (t < this.transitions.length) {
            this.transitions[t].resetStatistic();
            ++t;
        }
    }

    @Override
    public void joinStatistics(Transition ... transitions) {
        AbstractTransitionElement[] ats = new AbstractTransitionElement[transitions.length];
        int j = 0;
        while (j < this.transitions.length) {
            int i = 0;
            while (i < transitions.length) {
                ats[i] = ((BasicHigherOrderTransition)transitions[i]).transitions[j];
                ++i;
            }
            this.transitions[j].joinStatistics(ats);
            ++j;
        }
    }

    @Override
    public void addToStatistic(int layer, int index, int childIdx, double weight, Sequence sequence, int sequencePosition) {
        this.transitions[this.getTransitionElementIndex(layer, index)].addToStatistic(childIdx, weight, sequence, sequencePosition);
    }

    @Override
    public void estimateFromStatistic() {
        int t = 0;
        while (t < this.transitions.length) {
            this.transitions[t].estimateFromStatistic();
            ++t;
        }
    }

    public void drawParametersFromStatistic() throws Exception {
        int t = 0;
        while (t < this.transitions.length) {
            this.transitions[t].drawParametersFromStatistic();
            ++t;
        }
    }

    private void computeMaximalMarkovOrder() {
        this.maximalMarkovOrder = 0;
        int temp = 0;
        int t = 0;
        while (t < this.transitions.length) {
            temp = this.transitions[t].context.length;
            if (temp > this.maximalMarkovOrder) {
                this.maximalMarkovOrder = temp;
            }
            ++t;
        }
    }

    @Override
    public int getMaximalMarkovOrder() {
        return this.maximalMarkovOrder;
    }

    @Override
    public double getLogPriorTerm() {
        double pt = 0.0;
        int t = 0;
        while (t < this.transitions.length) {
            pt += this.transitions[t].getLogPriorTerm();
            ++t;
        }
        return pt;
    }

    @Override
    public int getNumberOfStates() {
        return this.isSilent.length;
    }

    @Override
    public void initializeRandomly() {
        int t = 0;
        while (t < this.transitions.length) {
            this.transitions[t].initializeRandomly();
            ++t;
        }
    }

    @Override
    public String getGraphizNetworkRepresentation(NumberFormat nf, String arrowOption, boolean graphical) {
        StringBuffer res = new StringBuffer();
        int t = 0;
        while (t < this.transitions.length) {
            this.transitions[t].appendGraphvizDescription(res, nf, arrowOption, graphical);
            ++t;
        }
        return res.toString();
    }

    @Override
    public void fillTransitionInformation(int layer, int index, int childIdx, int[] container) {
        int idx = this.getTransitionElementIndex(layer, index);
        container[0] = this.transitions[idx].states[childIdx];
        container[1] = this.transitions[idx].descendants[childIdx];
        container[2] = this.isSilent[container[0]] ? 0 : 1;
        container[1] = this.lookup[1][this.getLookupIndex(layer + container[2])][container[1]];
    }

    private int getLookupIndex(int layer) {
        return layer < this.maximalMarkovOrder ? layer : this.maximalMarkovOrder;
    }

    protected final int getTransitionElementIndex(int layer, int index) {
        return this.lookup[0][this.getLookupIndex(layer)][index];
    }

    @Override
    public int getNumberOfChildren(int layer, int index) {
        return this.transitions[this.getTransitionElementIndex(layer, index)].getNumberOfChildren();
    }

    @Override
    public double getLogScoreFor(int layer, int index, int childIdx, Sequence sequence, int sequencePosition) {
        return this.transitions[this.getTransitionElementIndex(layer, index)].getLogScoreFor(childIdx, sequence, sequencePosition);
    }

    @Override
    public int getNumberOfIndexes(int layer) {
        return this.lookup[0][this.getLookupIndex(layer)].length;
    }

    @Override
    public boolean hasAnySelfTransitions() {
        int t = 0;
        while (t < this.transitions.length) {
            if (this.transitions[t].context.length <= 0) continue;
            int lastState = this.transitions[t].getLastContextState();
            int c = 0;
            while (c < this.transitions[t].states.length) {
                if (this.transitions[t].states[c] == lastState) {
                    return true;
                }
                ++c;
            }
        }
        return false;
    }

    @Override
    public int getMaximalInDegree() {
        return this.maxInDegree;
    }

    @Override
    public int getMaximalNumberOfChildren() {
        int out = 0;
        int t = 0;
        while (t < this.transitions.length) {
            if (out < this.transitions[t].getNumberOfChildren()) {
                out = this.transitions[t].getNumberOfChildren();
            }
            ++t;
        }
        return out;
    }

    @Override
    public int getLastContextState(int layer, int index) {
        int idx = this.getTransitionElementIndex(layer, index);
        if (this.transitions[idx].context.length == 0) {
            return -1;
        }
        return this.transitions[idx].getLastContextState();
    }

    @Override
    public int getChildIdx(int layer, int index, int state) {
        int idx = this.getTransitionElementIndex(layer, index);
        int i = 0;
        while (i < this.transitions[idx].states.length && state != this.transitions[idx].states[i]) {
            ++i;
        }
        return i == this.transitions[idx].states.length ? -1 : i;
    }

    @Override
    public double getLogGammaScoreFromStatistic() {
        double res = 0.0;
        int t = 0;
        while (t < this.transitions.length) {
            res += this.transitions[t].getLogGammaScoreFromStatistic();
            ++t;
        }
        return res;
    }

    public String toString() {
        return this.toString(null, null);
    }

    @Override
    public String toString(String[] stateNames, NumberFormat nf) {
        StringBuffer sb = new StringBuffer();
        int t = 0;
        while (t < this.transitions.length) {
            sb.append(this.transitions[t].toString(stateNames, nf));
            ++t;
        }
        return sb.toString();
    }

    @Override
    public boolean[] isAbsoring() {
        boolean[] absorbing = new boolean[this.isSilent.length];
        Arrays.fill(absorbing, true);
        int t = 0;
        while (t < this.transitions.length) {
            if (this.transitions[t].context.length > 0 && this.transitions[t].states.length > 0) {
                absorbing[this.transitions[t].getLastContextState()] = false;
            }
            ++t;
        }
        return absorbing;
    }

    @Override
    public void setParameters(Transition t) throws IllegalArgumentException {
        if (!t.getClass().equals(this.getClass())) {
            throw new IllegalArgumentException("The transitions are not comparable.");
        }
        BasicHigherOrderTransition tt = (BasicHigherOrderTransition)t;
        int i = 0;
        while (i < this.transitions.length) {
            this.transitions[i].setParameters(tt.transitions[i]);
            ++i;
        }
    }

    public static abstract class AbstractTransitionElement
    implements Cloneable,
    Storable {
        protected int[] context;
        protected int[] states;
        protected double[] hyperParameters;
        protected double[] parameters;
        protected double[] statistic;
        protected double logNorm;
        protected int[] descendants;
        private double[] weight;
        private static final String XML_TAG = "TRANSITION_ELEMENT";

        public AbstractTransitionElement(int[] context, int[] states, double[] hyperParameters) {
            this(context, states, hyperParameters, null);
        }

        public AbstractTransitionElement(int[] context, int[] states, double[] hyperParameters, double[] weight) {
            int h;
            this.context = context == null ? new int[]{} : (int[])context.clone();
            int s = states == null ? 0 : states.length;
            int n = h = hyperParameters == null ? s : hyperParameters.length;
            if (s != h) {
                throw new IllegalArgumentException("You have to provide the same number of states and hyperparameters.");
            }
            if (states == null) {
                this.states = new int[0];
            } else {
                this.states = (int[])states.clone();
                Arrays.sort(this.states);
                int old = -1;
                int i = 0;
                while (i < this.states.length) {
                    if (this.states[i] == old) {
                        throw new IllegalArgumentException("It is not allowed to have several edges to the same child. Please check: " + Arrays.toString(context) + " -> " + this.states[i]);
                    }
                    old = this.states[i];
                    ++i;
                }
                System.arraycopy(states, 0, this.states, 0, s);
            }
            this.hyperParameters = new double[s];
            if (hyperParameters != null) {
                int i = 0;
                while (i < hyperParameters.length) {
                    if (hyperParameters[i] < 0.0) {
                        throw new IllegalArgumentException("Please check the hyper-parameter " + i + ".");
                    }
                    this.hyperParameters[i] = hyperParameters[i];
                    ++i;
                }
            }
            this.parameters = new double[s];
            this.init();
            this.weight = weight == null ? null : (double[])weight.clone();
        }

        public AbstractTransitionElement(StringBuffer xml) throws NonParsableException {
            xml = XMLParser.extractForTag(xml, this.getXMLTag());
            this.context = (int[])XMLParser.extractObjectForTags(xml, "context");
            this.states = (int[])XMLParser.extractObjectForTags(xml, "states");
            this.hyperParameters = (double[])XMLParser.extractObjectForTags(xml, "hyperparameters");
            this.parameters = (double[])XMLParser.extractObjectForTags(xml, "parameters");
            this.weight = (double[])(XMLParser.hasTag(xml, "weight", null, null) ? (double[])XMLParser.extractObjectForTags(xml, "weight") : null);
            this.extractFurtherInformation(xml);
            this.init();
        }

        protected abstract void appendFurtherInformation(StringBuffer var1);

        protected abstract void extractFurtherInformation(StringBuffer var1) throws NonParsableException;

        protected String getXMLTag() {
            return XML_TAG;
        }

        @Override
        public StringBuffer toXML() {
            StringBuffer xml = new StringBuffer();
            XMLParser.appendObjectWithTags(xml, this.context, "context");
            XMLParser.appendObjectWithTags(xml, this.states, "states");
            XMLParser.appendObjectWithTags(xml, this.hyperParameters, "hyperparameters");
            XMLParser.appendObjectWithTags(xml, this.parameters, "parameters");
            XMLParser.appendObjectWithTags(xml, this.weight, "weight");
            this.appendFurtherInformation(xml);
            XMLParser.addTags(xml, this.getXMLTag());
            return xml;
        }

        protected void init() {
            this.statistic = new double[this.states.length];
            this.descendants = new int[this.states.length];
            Arrays.fill(this.descendants, -1);
            this.precompute();
        }

        public AbstractTransitionElement clone() throws CloneNotSupportedException {
            AbstractTransitionElement clone = (AbstractTransitionElement)super.clone();
            clone.context = (int[])this.context.clone();
            clone.states = (int[])this.states.clone();
            clone.hyperParameters = (double[])this.hyperParameters.clone();
            clone.parameters = (double[])this.parameters.clone();
            clone.statistic = (double[])this.statistic.clone();
            clone.descendants = (int[])this.descendants.clone();
            clone.weight = this.weight == null ? null : (double[])this.weight.clone();
            return clone;
        }

        public int getLastContextState() {
            return this.context[this.context.length - 1];
        }

        protected void precompute() {
            this.logNorm = Normalisation.getLogSum(this.parameters);
        }

        public void appendGraphvizDescription(StringBuffer representation, NumberFormat nf, String arrowOption, boolean graphical) {
            if (this.states.length > 0) {
                String contextNode;
                switch (this.context.length) {
                    case 0: {
                        contextNode = "START";
                        break;
                    }
                    case 1: {
                        contextNode = "" + this.context[0];
                        break;
                    }
                    default: {
                        contextNode = "" + this.context[0];
                        int c = 1;
                        while (c < this.context.length) {
                            contextNode = String.valueOf(contextNode) + "_" + this.context[c];
                            ++c;
                        }
                        representation.append("\tp" + contextNode + "[label=\"\",fixedsize=true,width=0,height=0]\n");
                        representation.append("\t{" + contextNode.replace('_', ' ') + "} -> p" + contextNode + "[arrowhead=none,style=dashed]\n");
                        contextNode = "p" + contextNode;
                    }
                }
                this.appendTransitions(representation, contextNode, nf, arrowOption, graphical);
            }
        }

        protected void appendTransitions(StringBuffer representation, String contextNodeRepresentation, NumberFormat nf, String arrowOption, boolean graphical) {
            int s = 0;
            while (s < this.states.length) {
                representation.append("\t" + contextNodeRepresentation + "->" + this.states[s] + AbstractTransitionElement.getArrowOption(nf, Math.exp(this.parameters[s] - this.logNorm), this.getGraphvizEdgeWeight(s), arrowOption, graphical) + "\n");
                ++s;
            }
        }

        protected final double getGraphvizEdgeWeight(int s) {
            return this.weight == null ? 1.0 : this.weight[s];
        }

        protected static String getArrowOption(NumberFormat nf, double prob, double weight, String arrowOption, boolean graphical) {
            if (graphical) {
                double penwidth = 1.0 + prob * 20.0;
                return "[penwidth=\"" + penwidth + "\", weight=\"" + weight + "\"]";
            }
            if (nf == null && arrowOption == null) {
                return "[weight=\"" + weight + "\"]";
            }
            if (nf == null) {
                return "[" + arrowOption + ", weight=\"" + weight + "\"]";
            }
            return "[label=" + nf.format(prob) + (arrowOption == null ? "" : ", " + arrowOption) + ", weight=\"" + weight + "\"]";
        }

        public int getChild(int index) {
            return this.states[index];
        }

        public int getDescendant(int index) {
            return this.descendants[index];
        }

        public void setIndexOfDescendantTransitionElement(int index, int descendant) {
            this.descendants[index] = descendant;
        }

        public int[] getNextContext(int index, int maximalMarkovOrder) {
            int myOrd = this.context.length < maximalMarkovOrder ? this.context.length + 1 : maximalMarkovOrder;
            int[] newContext = new int[myOrd];
            if (myOrd > 0) {
                System.arraycopy(this.context, this.context.length < maximalMarkovOrder ? 0 : 1, newContext, 0, myOrd - 1);
                newContext[myOrd - 1] = this.states[index];
            }
            return newContext;
        }

        public double getLogScoreFor(int index, Sequence sequence, int sequencePosition) {
            return this.parameters[index] - this.logNorm;
        }

        public double getLogPriorTerm() {
            if (this.hyperParameters.length > 0) {
                double res = 0.0;
                double sumHyper = 0.0;
                int d = 0;
                while (d < this.hyperParameters.length) {
                    sumHyper += this.hyperParameters[d];
                    res += this.hyperParameters[d] * this.parameters[d];
                    ++d;
                }
                if (sumHyper == 0.0) {
                    return 0.0;
                }
                return res - sumHyper * this.logNorm;
            }
            return 0.0;
        }

        public final int getNumberOfChildren() {
            return this.states.length;
        }

        public void addToStatistic(int childIdx, double weight, Sequence sequence, int sequencePosition) {
            int n = childIdx;
            this.statistic[n] = this.statistic[n] + weight;
        }

        public void joinStatistics(AbstractTransitionElement ... te) {
            int j = 0;
            while (j < te.length) {
                if (te[j] != this) {
                    int i = 0;
                    while (i < this.statistic.length) {
                        int n = i;
                        this.statistic[n] = this.statistic[n] + te[j].statistic[i];
                        ++i;
                    }
                }
                ++j;
            }
            j = 0;
            while (j < te.length) {
                if (te[j] != this) {
                    System.arraycopy(this.statistic, 0, te[j].statistic, 0, this.statistic.length);
                }
                ++j;
            }
        }

        public int getNumberOfParameters() {
            return this.parameters.length;
        }

        public void drawParametersFromStatistic() {
            if (this.states.length > 1) {
                double sum = 0.0;
                int i = 0;
                while (i < this.statistic.length) {
                    this.parameters[i] = this.statistic[i] + this.hyperParameters[i];
                    sum += this.parameters[i];
                    ++i;
                }
                DirichletMRGParams par = sum == 0.0 ? new DirichletMRGParams(1.0, this.states.length) : new DirichletMRGParams(this.parameters);
                DirichletMRG.DEFAULT_INSTANCE.generateLog(this.parameters, 0, this.parameters.length, par);
            } else {
                Arrays.fill(this.parameters, 0.0);
            }
            this.precompute();
        }

        public void estimateFromStatistic() {
            if (this.states.length > 0) {
                this.logNorm = 0.0;
                int i = 0;
                while (i < this.statistic.length) {
                    int n = i;
                    this.statistic[n] = this.statistic[n] + this.hyperParameters[i];
                    this.logNorm += this.statistic[i];
                    this.parameters[i] = Math.log(this.statistic[i]);
                    ++i;
                }
                if (this.logNorm == 0.0) {
                    Arrays.fill(this.parameters, 0.0);
                    this.logNorm = Math.log(this.parameters.length);
                } else {
                    this.logNorm = Math.log(this.logNorm);
                }
            }
        }

        public void resetStatistic() {
            Arrays.fill(this.statistic, 0.0);
        }

        public void initializeRandomly() {
            this.resetStatistic();
            this.drawParametersFromStatistic();
            this.resetStatistic();
        }

        public double getLogGammaScoreFromStatistic() {
            double sum = 0.0;
            double all = 0.0;
            double res = 0.0;
            int state = 0;
            while (state < this.hyperParameters.length) {
                sum += this.hyperParameters[state];
                all += this.statistic[state];
                res += Gamma.logOfGamma((double)this.statistic[state]) - Gamma.logOfGamma((double)this.hyperParameters[state]);
                ++state;
            }
            return res += Gamma.logOfGamma((double)sum) - Gamma.logOfGamma((double)all);
        }

        public final String toString() {
            return this.toString(null, null);
        }

        public String toString(String[] stateNames, NumberFormat nf) {
            if (this.parameters.length > 0) {
                StringBuffer sb = new StringBuffer();
                String context = this.getContext(stateNames);
                int i = 0;
                while (i < this.parameters.length) {
                    double v = Math.exp(this.parameters[i] - this.logNorm);
                    sb.append("P(" + this.getLabel(stateNames, this.states[i]) + context + ") \t= " + (nf == null ? Double.valueOf(v) : nf.format(v)));
                    sb.append("\t");
                    ++i;
                }
                sb.append("\n");
                return sb.toString();
            }
            return "";
        }

        protected String getContext(String[] stateNames) {
            if (this.context.length == 0) {
                return "";
            }
            String c = "|" + this.getLabel(stateNames, this.context[0]);
            int i = 1;
            while (i < this.context.length) {
                c = String.valueOf(c) + ", " + this.getLabel(stateNames, this.context[i]);
                ++i;
            }
            return c;
        }

        protected final String getLabel(String[] stateNames, int stateIdx) {
            return stateNames == null ? "" + stateIdx : stateNames[stateIdx];
        }

        private boolean hasSameContext(AbstractTransitionElement te) {
            if (te.context.length == this.context.length) {
                int i = 0;
                while (i < this.context.length && this.context[i] == te.context[i]) {
                    ++i;
                }
                return i == this.context.length;
            }
            return false;
        }

        public void setParameters(AbstractTransitionElement t) throws IllegalArgumentException {
            if (!t.getClass().equals(this.getClass()) || t.parameters.length != this.parameters.length) {
                throw new IllegalArgumentException("The transition elements are not comparable.");
            }
            System.arraycopy(t.parameters, 0, this.parameters, 0, t.parameters.length);
            this.precompute();
        }
    }
}

