/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.utils;

import Jama.EigenvalueDecomposition;
import Jama.Matrix;

public class StationaryDistribution {
    public static double[] getStationaryDistribution(double[] condProbs, int alphabetSize) {
        if (condProbs.length % alphabetSize != 0) {
            throw new IllegalArgumentException("wrong dimension");
        }
        int dim = condProbs.length / alphabetSize;
        double[][] matrix = new double[dim][dim];
        int help = dim / alphabetSize;
        int i = 0;
        while (i < dim) {
            int offset1 = i / alphabetSize;
            int offset2 = i % alphabetSize;
            int j = 0;
            while (j < alphabetSize) {
                int h = offset1 + j * help;
                matrix[i][h] = condProbs[h * alphabetSize + offset2];
                ++j;
            }
            ++i;
        }
        Matrix m = new Matrix(matrix, dim, dim);
        EigenvalueDecomposition eigen = new EigenvalueDecomposition(m);
        int ind = StationaryDistribution.getIndex(eigen.getRealEigenvalues(), 1.0);
        Matrix m2 = eigen.getV().getMatrix(0, dim - 1, ind, ind).transpose();
        double[] res = m2.getArray()[0];
        double sum = 0.0;
        int i2 = 0;
        while (i2 < dim) {
            sum += res[i2];
            ++i2;
        }
        i2 = 0;
        while (i2 < dim) {
            int n = i2++;
            res[n] = res[n] / sum;
        }
        return res;
    }

    private static int getIndex(double[] eigenValues, double wanted) {
        int i = 1;
        int best = 0;
        double diff = Math.abs(1.0 - eigenValues[best]);
        while (i < eigenValues.length) {
            double current = Math.abs(1.0 - eigenValues[i]);
            if (current < diff) {
                best = i;
                diff = current;
            }
            ++i;
        }
        return best;
    }

    public static double[][][] getAllConditionalStationaryDistributions(double[] probs, int alphabetSize) {
        double[] help = (double[])probs.clone();
        int dim = (int)(Math.log(probs.length) / Math.log(alphabetSize));
        double[][][] res = new double[dim][][];
        int i = dim - 1;
        while (i > 0) {
            StationaryDistribution.makeCondProb(help, alphabetSize);
            res[i] = StationaryDistribution.fold(help, alphabetSize);
            help = StationaryDistribution.getStationaryDistribution(help, alphabetSize);
            --i;
        }
        res[0] = new double[][]{help};
        return res;
    }

    private static void makeCondProb(double[] jointProb, int alphabetSize) {
        int i = 0;
        while (i < jointProb.length) {
            double sum = 0.0;
            int j = 0;
            while (j < alphabetSize) {
                sum += jointProb[i + j];
                ++j;
            }
            j = 0;
            while (j < alphabetSize) {
                int n = i++;
                jointProb[n] = jointProb[n] / sum;
                ++j;
            }
        }
    }

    private static double[][] fold(double[] prob, int alphabetSize) {
        int l = prob.length / alphabetSize;
        double[][] res = new double[l][alphabetSize];
        int i = 0;
        while (i < l) {
            System.arraycopy(prob, i * alphabetSize, res[i], 0, alphabetSize);
            ++i;
        }
        return res;
    }

    private static void show(double[] condProb, int alphabetSize) {
        int i = 0;
        while (i < condProb.length) {
            int j = 0;
            while (j < alphabetSize) {
                System.out.print(String.valueOf(condProb[i]) + "\t");
                ++j;
                ++i;
            }
            System.out.println();
        }
    }

    private static void show(double[][] matrix) {
        int i = 0;
        while (i < matrix.length) {
            int j = 0;
            while (j < matrix[i].length) {
                System.out.print(String.valueOf(matrix[i][j]) + "\t");
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

