/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import projects.gemoma.Extractor;
import projects.gemoma.GeMoMa;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class AnnotationEvidence
extends GeMoMaModule {
    private static final String[] EMPTY = new String[0];
    private static final String defResult = "evidence";

    /*
     * Unable to fully structure code
     */
    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws Exception {
        if (GeMoMa.seqs == null) {
            GeMoMa.fill(protocol, false, -1, parameters.getParameterForName("genome").getValue().toString(), null, (Integer)parameters.getParameterForName("reads").getValue(), (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterAt(3)).getValue(), (ExpandableParameterSet)((ParameterSetContainer)parameters.getParameterAt(5)).getValue());
        }
        tag = parameters.getParameterForName("tag").getValue().toString();
        code = Tools.getCode(Tools.getInputStream(parameters.getParameterForName("genetic code"), "projects/gemoma/test_data/genetic_code.txt"));
        code.put("NNN", Character.valueOf('X'));
        annotation = Extractor.read(false, parameters.getParameterForName("annotation").getValue().toString(), null, protocol);
        chr = GeMoMa.seqs.keySet().toArray(new String[GeMoMa.seqs.size()]);
        Arrays.sort(chr);
        file = Tools.createTempFile("AnnotationEvidence", temp);
        w = new BufferedWriter(new FileWriter(file));
        w.append("#gene id\tchr\tstart\tend\tstrand\ttranscript id\t#exons\ttie\ttpc\tminCov\tavgCov\tminSplitReads\tnps");
        w.newLine();
        aFile = Tools.createTempFile("AnnotationEvidence", temp);
        annot = new BufferedWriter(new FileWriter(aFile));
        annot.append("##gff-version 3");
        annot.newLine();
        annot.append("#SOFTWARE INFO: " + this.getShortName() + " " + this.getToolVersion() + "; ");
        info = JstacsTool.getSimpleParameterInfo(parameters);
        if (info != null) {
            annot.append("SIMPLE PARAMETERS: " + info);
        }
        annot.newLine();
        nuc = new StringBuffer();
        coverage = GeMoMa.coverage != null;
        introns = GeMoMa.donorSites != null;
        attr = new HashMap<String, String>();
        old = new StringBuffer();
        perfect = 0;
        var24_21 = chr;
        var23_22 = chr.length;
        var22_23 = 0;
        while (var22_23 < var23_22) {
            block44: {
                c = var24_21[var22_23];
                seq = GeMoMa.seqs.get(c);
                current = annotation.get(c);
                v0 = sites = introns != false ? GeMoMa.donorSites.get(c) : null;
                if (current == null || current.size() <= 0) break block44;
                array = current.values().toArray(new Extractor.Gene[0]);
                if (array.length == 1) {
                    array[0].precompute();
                } else {
                    Arrays.sort(array);
                }
                a = 0;
                while (a < array.length) {
                    block45: {
                        g = array[a];
                        hasTranscript = false;
                        ti = g.transcript.values().iterator();
                        while (ti.hasNext()) {
                            if (ti.next().b.length() <= 0) continue;
                            hasTranscript = true;
                            break;
                        }
                        if (!hasTranscript) break block45;
                        g.sortExons();
                        cov = coverage != false && GeMoMa.coverage[g.strand == 1 ? 0 : 1] != null ? GeMoMa.coverage[g.strand == 1 ? 0 : 1].get(c) : null;
                        cds = g.transcript.entrySet().iterator();
                        annot.append(String.valueOf(c) + "\t" + g.evidence + "\tgene\t" + g.start + "\t" + g.end + "\t.\t" + (g.strand == 1 ? "+" : "-") + "\t.\tID=" + g.id);
                        annot.newLine();
                        while (cds.hasNext()) {
                            e = cds.next();
                            t = e.getValue();
                            parts = t.b;
                            if (parts.length() <= 0) continue;
                            tStart = g.strand > 0 ? g.exon.get(parts.get(0))[1] : g.exon.get(parts.get(parts.length() - 1))[1];
                            v1 = tEnd = g.strand > 0 ? g.exon.get(parts.get(parts.length() - 1))[2] : g.exon.get(parts.get(0))[2];
                            if (t.add != null) {
                                j = 0;
                                while (j < t.add.size()) {
                                    s = t.add.get(j);
                                    tStart = Math.min(tStart, Integer.parseInt(s[3]));
                                    tEnd = Math.max(tEnd, Integer.parseInt(s[4]));
                                    ++j;
                                }
                            }
                            w.append(String.valueOf(g.id) + "\t" + (String)c + "\t" + tStart + "\t" + tEnd + "\t" + g.strand + "\t" + e.getKey() + "\t" + parts.length() + "\t");
                            tie = 0.0;
                            minSplitReads = 0x7FFFFFFF;
                            last = -10;
                            covered = 0;
                            l = 0;
                            donSites = sites == null ? null : sites[g.strand == 1 ? 0 : 1];
                            nuc.delete(0, nuc.length());
                            sum = 0.0;
                            min = 0x7FFFFFFF;
                            j = 0;
                            while (j < parts.length()) {
                                block46: {
                                    part = g.exon.get(parts.get(j));
                                    if (g.strand > 0) {
                                        nuc.append(seq.substring(part[1] - 1, part[2]));
                                    } else {
                                        nuc.insert(0, seq.substring(part[1] - 1, part[2]));
                                    }
                                    if (j > 0) {
                                        currentSplitReads = 0;
                                        if (donSites != null) {
                                            v = g.strand == 1 ? part[1] : part[2] + 1;
                                            idx = Arrays.binarySearch(donSites[0], last);
                                            if (idx > 0) {
                                                while (idx > 0 && donSites[0][idx - 1] == last) {
                                                    --idx;
                                                }
                                            }
                                            if (idx >= 0) {
                                                while (idx < donSites[0].length && donSites[0][idx] == last && donSites[1][idx] != v) {
                                                    ++idx;
                                                }
                                                if (idx < donSites[0].length && donSites[0][idx] == last && donSites[1][idx] == v) {
                                                    tie += 1.0;
                                                    currentSplitReads = donSites[2][idx];
                                                }
                                            }
                                        }
                                        minSplitReads = Math.min(minSplitReads, currentSplitReads);
                                    }
                                    start = part[1];
                                    end = part[2];
                                    l += end - start + 1;
                                    if (cov == null) break block46;
                                    idx = Arrays.binarySearch(cov, new int[]{start}, GeMoMa.IntArrayComparator.comparator[2]);
                                    if (idx < 0) {
                                        idx = -(idx + 1);
                                        idx = Math.max(0, idx - 1);
                                    }
                                    inter = cov[idx];
                                    p = start;
                                    ** GOTO lbl143
                                    {
                                        if (++idx >= cov.length) {
                                            min = 0;
                                            break;
                                        }
                                        inter = cov[idx];
                                        do {
                                            if (p > inter[1]) continue block8;
                                            if (inter[0] <= p && p <= inter[1]) {
                                                h = Math.min(inter[1], end) + 1;
                                                z = h - p;
                                                covered += z;
                                                sum += (double)(inter[2] * z);
                                                min = Math.min(min, inter[2]);
                                                p = h;
                                                continue;
                                            }
                                            min = 0;
                                            p = Math.min(inter[0], end + 1);
lbl143:
                                            // 3 sources

                                        } while (p <= end);
                                    }
                                }
                                last = g.strand == 1 ? part[2] + 1 : part[1];
                                ++j;
                            }
                            cod = g.strand < 0 ? Tools.rc(nuc.toString()) : nuc.toString();
                            aa = Tools.translate(0, cod, code, false, Tools.Ambiguity.AMBIGUOUS);
                            preMatureStops = 0;
                            j = 0;
                            while (j < aa.length() - 1) {
                                if (aa.charAt(j) == '*') {
                                    ++preMatureStops;
                                }
                                ++j;
                            }
                            tieString = parts.length() == 1 ? "NA" : GeMoMa.decFormat.format(tie / ((double)parts.length() - 1.0));
                            tpcString = GeMoMa.coverage == null ? "NA" : GeMoMa.decFormat.format((double)covered / (double)l);
                            avgCovString = GeMoMa.coverage == null ? "NA" : GeMoMa.decFormat.format(sum / (double)l);
                            minCovString = GeMoMa.coverage == null ? "NA" : "" + min;
                            v2 = minSplitReadsString = parts.length() == 1 ? "NA" : "" + minSplitReads;
                            if (tie == (double)(parts.length() - 1) && covered == l) {
                                ++perfect;
                            }
                            w.append(String.valueOf(tieString) + "\t" + tpcString + "\t" + minCovString + "\t" + avgCovString + "\t" + minSplitReadsString + "\t" + preMatureStops);
                            w.newLine();
                            annot.append(String.valueOf(c) + "\t" + g.evidence + "+AnnotationEvidence\t" + tag + "\t" + tStart + "\t" + tEnd + "\t.\t" + (g.strand == 1 ? "+" : "-") + "\t.\t");
                            att = t.attributes == null ? AnnotationEvidence.EMPTY : t.attributes.split(";");
                            j = 0;
                            while (j < att.length) {
                                att[j] = att[j].trim();
                                ++j;
                            }
                            v3 = gtf = att.length >= 2 && (att[0].startsWith("gene_id") != false || att[1].startsWith("transcript_id") != false);
                            if (gtf) {
                                j = 0;
                                while (j < att.length) {
                                    att[j] = att[j].replace(" \"", "=\"");
                                    ++j;
                                }
                                if (att[0].startsWith("gene_id")) {
                                    att[0] = att[0].replace("gene_id", "Parent");
                                    att[1] = att[1].replace("transcript_id", "ID");
                                } else {
                                    att[1] = att[1].replace("gene_id", "Parent");
                                    att[0] = att[0].replace("transcript_id", "ID");
                                }
                            }
                            attr.clear();
                            j = 0;
                            while (j < att.length) {
                                pos = att[j].indexOf(61);
                                attr.put(att[j].substring(0, pos), att[j].substring(pos + 1));
                                ++j;
                            }
                            old.delete(0, old.length());
                            AnnotationEvidence.add(old, attr, "ID", e.getKey());
                            AnnotationEvidence.add(old, attr, "Parent", g.id);
                            AnnotationEvidence.add(old, attr, "aa", "" + l / 3);
                            if (introns) {
                                AnnotationEvidence.add(old, attr, "tie", tieString);
                                AnnotationEvidence.add(old, attr, "minSplitReads", minSplitReadsString);
                            }
                            if (coverage) {
                                AnnotationEvidence.add(old, attr, "tpc", tpcString);
                                AnnotationEvidence.add(old, attr, "minCov", "" + min);
                                AnnotationEvidence.add(old, attr, "avgCov", avgCovString);
                            }
                            AnnotationEvidence.add(old, attr, "nps", "" + preMatureStops);
                            AnnotationEvidence.add(old, attr, "start", "" + aa.charAt(0));
                            AnnotationEvidence.add(old, attr, "stop", "" + aa.charAt(aa.length() - 1));
                            AnnotationEvidence.add(old, attr, "ce", "" + parts.length());
                            j = 0;
                            while (j < att.length) {
                                pos = att[j].indexOf(61);
                                key = att[j].substring(0, pos);
                                annot.append(String.valueOf(key) + "=" + attr.remove(key) + ";");
                                ++j;
                            }
                            k = attr.keySet().toArray(AnnotationEvidence.EMPTY);
                            Arrays.sort(k);
                            var65_77 = k;
                            var64_76 = k.length;
                            key = 0;
                            while (key < var64_76) {
                                key = var65_77[key];
                                annot.append(String.valueOf(key) + "=" + attr.remove(key) + ";");
                                ++key;
                            }
                            if (old.length() > 0) {
                                annot.append("#old: " + old);
                            }
                            annot.newLine();
                            if (t.add != null) {
                                j = 0;
                                while (j < t.add.size()) {
                                    split = t.add.get(j);
                                    m = 0;
                                    while (m < split.length) {
                                        annot.append(String.valueOf(m == 0 ? "" : "\t") + split[m]);
                                        ++m;
                                    }
                                    annot.newLine();
                                    ++j;
                                }
                            }
                            j = 0;
                            while (j < parts.length()) {
                                part = g.exon.get(parts.get(j));
                                annot.append(String.valueOf(c) + "\t" + g.evidence + "\tCDS\t" + part[1] + "\t" + part[2] + "\t.\t" + (g.strand == 1 ? "+" : "-") + "\t" + (part[3] == -100000 ? "." : Integer.valueOf(part[3])) + "\tParent=" + e.getKey());
                                annot.newLine();
                                ++j;
                            }
                        }
                    }
                    ++a;
                }
            }
            ++var22_23;
        }
        w.close();
        annot.close();
        protocol.append("number of detected transcripts with very good RNA-seq evidence (tpc==1 && (tie==1 || tie==NA)): " + perfect + "\n");
        res = new ArrayList<TextResult>();
        res.add(new TextResult("evidence", "Result", new FileParameter.FileRepresentation(file.getAbsolutePath()), "tabular", this.getToolName(), null, true));
        if (((Boolean)parameters.getParameterForName("annotation output").getValue()).booleanValue()) {
            res.add(new TextResult("annotation with attributes", "Result", new FileParameter.FileRepresentation(aFile.getAbsolutePath()), "gff", this.getToolName(), null, true));
        }
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    private static void add(StringBuffer old, HashMap<String, String> attr, String key, String newValue) {
        String oldValue = attr.get(key);
        if (oldValue != null) {
            if (oldValue.equals(newValue)) {
                return;
            }
            old.append(String.valueOf(key) + "=" + oldValue + ";");
        }
        attr.put(key, newValue);
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new FileParameter("annotation", "The genome annotation file (GFF,GTF)", "gff,gff3,gtf,gff.gz,gff3.gz,gtf.gz", true, new FileExistsValidator(), true), new SimpleParameter(DataType.STRING, "tag", "A user-specified tag for transcript predictions in the third column of the returned gff. It might be beneficial to set this to a specific value for some genome browsers.", true, "mRNA"), new FileParameter("genome", "The target genome file (FASTA). Should be in IUPAC code", "fasta,fas,fa,fna,fasta.gz,fas.gz,fa.gz,fna.gz", true, new FileExistsValidator(), true), new ParameterSetContainer("introns", "", new ExpandableParameterSet(new SimpleParameterSet(new FileParameter("introns file", "Introns (GFF), which might be obtained from RNA-seq", "gff,gff3", false, new FileExistsValidator(), true)), "introns", "", 1)), new SimpleParameter(DataType.INT, "reads", "if introns are given by a GFF, only use those which have at least this number of supporting split reads", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), 1), new ParameterSetContainer("coverage", "", new ExpandableParameterSet(new SimpleParameterSet(new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "UNSTRANDED", "STRANDED"}, new Object[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new FileParameter("coverage_unstranded", "The coverage file contains the unstranded coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator())), new SimpleParameterSet(new FileParameter("coverage_forward", "The coverage file contains the forward coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()), new FileParameter("coverage_reverse", "The coverage file contains the reverse coverage of the genome per interval. Intervals with coverage 0 (zero) can be left out.", "bedgraph", true, new FileExistsValidator()))}, "coverage file", "experimental coverage (RNA-seq)", true)), "coverage", "", 1)), new SimpleParameter(DataType.BOOLEAN, "annotation output", "if the annotation should be returned with attributes tie, tpc, and aa", true, true), new FileParameter("genetic code", "optional user-specified genetic code", "tabular", false));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "Annotation evidence";
    }

    @Override
    public String getShortName() {
        return "AnnotationEvidence";
    }

    @Override
    public String getDescription() {
        return "computes the evidence for annotated coding sequences";
    }

    @Override
    public String getHelpText() {
        return "This tool adds attributes to the annotation, e.g., tie, tpc, aa, start, stop. These attributes can be used, for instance, if the annotation is used in **GAF**. All predictions of the annotation are used. The predictions are not filtered for internal stop codons, missing start or stop codons, frame-shifts, ... . Please use **ERE** to preprocess the mapped reads." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "tabular", defResult)};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

