/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.algorithms.graphs.GenericUnionFind;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class GAFComparison
extends GeMoMaModule {
    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String temp) throws IOException {
        Object[] s;
        int j;
        String tag = parameters.getParameterForName("tag").getValue().toString();
        boolean splitPrefix = (Boolean)parameters.getParameterForName("split prefix").getValue();
        boolean differences = (Boolean)parameters.getParameterForName("differences").getValue();
        HashMap<String, HashMap<String, int[]>[]> hash = new HashMap<String, HashMap<String, int[]>[]>();
        ExpandableParameterSet eps = (ExpandableParameterSet)parameters.getParameterForName("predicted annotation").getValue();
        GenericUnionFind<Object> guf = new GenericUnionFind<Object>();
        int MAX = eps.getNumberOfParameters();
        String[] name = new String[MAX];
        int k = 0;
        while (k < MAX) {
            String line;
            SimpleParameterSet sps = (SimpleParameterSet)eps.getParameterAt(k).getValue();
            name[k] = (String)sps.getParameterForName("name").getValue();
            protocol.append("reading gene annotation: " + name[k] + "\n");
            BufferedReader r = Tools.openGzOrPlain((String)sps.getParameterForName("gene annotation file").getValue());
            while ((line = r.readLine()) != null) {
                String[] split;
                if (line.length() == 0 || line.charAt(0) == '#' || !(split = line.split("\t"))[2].equals(tag)) continue;
                split = split[8].split(";");
                String pa = null;
                int j2 = 0;
                while (j2 < split.length) {
                    if (split[j2].startsWith("Parent=")) {
                        pa = split[j2].substring(7);
                    }
                    ++j2;
                }
                String rg = null;
                j = 0;
                while (j < split.length) {
                    if (split[j].startsWith("ref-gene=")) {
                        rg = this.reformat(split[j].substring(9));
                        GAFComparison.add(hash, pa, rg, name.length, k);
                        guf.find(rg);
                    } else if (split[j].startsWith("alternative=\"")) {
                        s = split[j].substring(13, split[j].length() - 1).split(",");
                        int h = 0;
                        while (h < s.length) {
                            s[h] = this.reformat((String)s[h]);
                            GAFComparison.add(hash, pa, (String)s[h], name.length, k);
                            guf.union(rg, s[h]);
                            ++h;
                        }
                    }
                    ++j;
                }
            }
            r.close();
            ++k;
        }
        Object[] genes = hash.keySet().toArray(new String[0]);
        Arrays.sort(genes);
        File out = Tools.createTempFile("GAFComparison", temp);
        HashMap comp = guf.getComponents();
        BufferedWriter w = new BufferedWriter(new FileWriter(out));
        w.append(String.valueOf(splitPrefix ? "\t" : "") + "\t\t\t\t");
        int i = 0;
        while (i < name.length) {
            w.append("\t" + name[i] + "\t");
            ++i;
        }
        w.newLine();
        if (splitPrefix) {
            w.append("prefix\t");
        }
        w.append("gene-ID\tcomponent\tcomponents size\tmin #genes\tmax #genes");
        i = 0;
        while (i < name.length) {
            w.append("\t#genes\t#transcripts");
            ++i;
        }
        w.newLine();
        s = genes;
        j = genes.length;
        int rg = 0;
        while (rg < j) {
            Object g = s[rg];
            HashMap[] val = (HashMap[])hash.get(g);
            int[] v = GAFComparison.summary(val, name.length);
            int max = 0;
            int min = Integer.MAX_VALUE;
            int i2 = 0;
            while (i2 < name.length) {
                if (v[2 * i2] > max) {
                    max = v[2 * i2];
                }
                if (v[2 * i2] < min) {
                    min = v[2 * i2];
                }
                ++i2;
            }
            if (!differences || min < max) {
                int idx = ((String)g).indexOf(95);
                if (idx >= 0 && splitPrefix) {
                    w.append(String.valueOf(((String)g).substring(0, idx)) + "\t" + ((String)g).substring(idx + 1));
                } else {
                    w.append((CharSequence)g);
                }
                int compIdx = guf.find(g);
                w.append("\t" + compIdx + "\t" + comp.get(compIdx).size());
                w.append("\t" + min);
                w.append("\t" + max);
                int i3 = 0;
                while (i3 < v.length) {
                    w.append("\t" + v[i3]);
                    ++i3;
                }
                w.newLine();
            }
            ++rg;
        }
        w.close();
        Iterator<Integer> it = comp.keySet().iterator();
        HashSet<String> prefix = new HashSet<String>();
        protocol.append("component\t#elements\t#prefixes\tmembers\n");
        while (it.hasNext()) {
            int k2 = it.next();
            ArrayList list = comp.get(k2);
            if (splitPrefix) {
                prefix.clear();
                int i4 = 0;
                while (i4 < list.size()) {
                    String g = (String)list.get(i4);
                    int idx = g.indexOf(95);
                    g = idx >= 0 && splitPrefix ? g.substring(0, idx) : "";
                    prefix.add(g);
                    ++i4;
                }
            }
            protocol.append(String.valueOf(k2) + "\t" + list.size() + "\t" + prefix.size() + "\t" + list + "\n");
        }
        return new ToolResult("", "", null, new ResultSet(new TextResult("GAF comparison", "Result", new FileParameter.FileRepresentation(out.getAbsolutePath()), "tabular", this.getToolName(), null, true)), parameters, this.getToolName(), new Date());
    }

    private String reformat(String string) {
        return string.toUpperCase();
    }

    static void add(HashMap<String, HashMap<String, int[]>[]> hash, String parent, String rGene, int max, int current) {
        int[] v;
        HashMap<String, int[]>[] val = hash.get(rGene);
        if (val == null) {
            val = new HashMap[max];
            int i = 0;
            while (i < max) {
                val[i] = new HashMap();
                ++i;
            }
            hash.put(rGene, val);
        }
        if ((v = val[current].get(parent)) == null) {
            v = new int[1];
            val[current].put(parent, v);
        }
        v[0] = v[0] + 1;
    }

    static int[] summary(HashMap<String, int[]>[] val, int max) {
        int[] res = new int[2 * max];
        int i = 0;
        while (i < max) {
            for (Map.Entry<String, int[]> e : val[i].entrySet()) {
                int n = 2 * i;
                res[n] = res[n] + 1;
                int n2 = 2 * i + 1;
                res[n2] = res[n2] + e.getValue()[0];
            }
            ++i;
        }
        return res;
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            return new ToolParameterSet(this.getShortName(), new SimpleParameter(DataType.STRING, "tag", "the tag used to read the GAF annotations", true, "mRNA"), new ParameterSetContainer("predicted annotation", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "name", "a simple name for the organism", true, new RegExpValidator(".+")), new FileParameter("gene annotation file", "GFF file containing the gene annotations (predicted by GAF)", "gff,gff3,gff.gz.gff3.gz", true, new FileExistsValidator(), true)), "gene annotations", "", 1)), new SimpleParameter(DataType.BOOLEAN, "split prefix", "a switch to decide whether the prefix should be split and writen in a separat column", true, false), new SimpleParameter(DataType.BOOLEAN, "differences", "a switch to decide whether only genes with difference should be returned", true, true));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return this.getShortName();
    }

    @Override
    public String getShortName() {
        return "GAFComparison";
    }

    @Override
    public String getDescription() {
        return "creates stats for the GFF attributes ref-gene and alternative";
    }

    @Override
    public String getHelpText() {
        return "This tool allows to compare results from GAF based on the attributed ref-gene and alternative.\nHence, you can compare the annotation of different genomes or the effect of different parameters on the annotation of one genome." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "tabular", "GAF comparison")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        return null;
    }
}

