/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.DataType;
import de.jstacs.clustering.kmeans.Kmeans;
import de.jstacs.io.FileManager;
import de.jstacs.parameters.ExpandableParameterSet;
import de.jstacs.parameters.FileParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.ParameterSet;
import de.jstacs.parameters.ParameterSetContainer;
import de.jstacs.parameters.SelectionParameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.SimpleParameterSet;
import de.jstacs.parameters.validation.FileExistsValidator;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.parameters.validation.RegExpValidator;
import de.jstacs.results.ResultSet;
import de.jstacs.results.TextResult;
import de.jstacs.tools.JstacsTool;
import de.jstacs.tools.ProgressUpdater;
import de.jstacs.tools.Protocol;
import de.jstacs.tools.ToolParameterSet;
import de.jstacs.tools.ToolResult;
import de.jstacs.utils.SafeOutputStream;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import javax.script.ScriptEngine;
import javax.script.ScriptEngineManager;
import javax.script.ScriptException;
import projects.gemoma.GeMoMaModule;
import projects.gemoma.Tools;

public class GeMoMaAnnotationFilter
extends GeMoMaModule {
    private static int MAX;
    private static HashMap<String, int[]> del;
    int h;
    int transcripts = 0;
    int[] clustered = new int[1];
    static int[][] stats;
    int gene;
    static int maxEvidence;
    static int complete;
    static boolean[] combinedEvidence;
    static double maxTie;
    static int[][] evidenceStat;

    static {
        del = new HashMap();
        del.put("Parent", new int[1]);
        del.put("alternative", new int[1]);
        del.put("evidence", new int[1]);
        del.put("sumWeight", new int[1]);
    }

    private static String replace(String cds, String oldString, String newString, int idx) {
        if ((idx = cds.indexOf(oldString, idx)) > 0) {
            char c = cds.charAt(idx - 1);
            cds = c == '\t' || c == ';' ? String.valueOf(cds.substring(0, idx)) + newString + cds.substring(idx + oldString.length()) : GeMoMaAnnotationFilter.replace(cds, oldString, newString, idx + 1);
        }
        return cds;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public ToolResult run(ToolParameterSet parameters, Protocol protocol, ProgressUpdater progress, int threads, String tempD) throws Exception {
        this.h = 0;
        this.gene = 0;
        tag = parameters.getParameterForName("tag").getValue().toString();
        maxTranscripts = (Integer)parameters.getParameterForName("maximal number of transcripts per gene").getValue();
        cbTh = (Double)parameters.getParameterForName("common border filter").getValue();
        defAttributes = parameters.getParameterForName("default attributes").getValue().toString().split(",");
        i = 0;
        while (i < defAttributes.length) {
            defAttributes[i] = defAttributes[i].trim();
            if (defAttributes[i].length() == 0) {
                defAttributes[i] = null;
            }
            ++i;
        }
        mgr = new ScriptEngineManager();
        engine = mgr.getEngineByName("nashorn");
        filter = Tools.prepareFilter((String)parameters.getParameterForName("filter").getValue());
        comp = new UserSpecifiedComparator((String)parameters.getParameterForName("sorting").getValue(), engine, protocol);
        d = null;
        pa = parameters.getParameterForName("length difference");
        if (pa != null) {
            d = (Double)pa.getValue();
        }
        lenPerc = d == null ? Infinity : d;
        altFilter = Tools.prepareFilter((String)parameters.getParameterForName("alternative transcript filter").getValue());
        addAltTransIDs = (Boolean)this.getParameter(parameters, "add alternative transcripts").getValue();
        addAdd = (Boolean)this.getParameter(parameters, "transfer features").getValue();
        pa = this.getParameter(parameters, "kmeans");
        minNum = 0;
        cluster = 0;
        good = 0;
        ex = null;
        margin = -1;
        quantile = -1.0;
        ps = (ParameterSet)pa.getValue();
        if (ps.getNumberOfParameters() > 0) {
            minNum = (Integer)ps.getParameterForName("minimal number of predictions").getValue();
            pa = ps.getParameterForName("cluster");
            if (pa != null) {
                cluster = (Integer)pa.getValue();
            }
            if ((pa = ps.getParameterForName("good cluster")) != null) {
                good = (Integer)pa.getValue();
            }
            if (good >= cluster) {
                throw new IllegalArgumentException("The number of good clusters must be smaller than the total number of clusters");
            }
            ex = new String[]{"Math.max(0,1 - Math.max(0,score)/maxScore)"};
            if ((ps = (ParameterSet)ps.getParameterForName("trend").getValue()).getNumberOfParameters() > 0) {
                margin = (Integer)ps.getParameterForName("margin").getValue();
                quantile = (Double)ps.getParameterForName("quantile").getValue();
            }
        }
        kmeans = cluster > 0;
        eps = (ExpandableParameterSet)parameters.getParameterForName("predicted annotation").getValue();
        pHash = new HashMap<String, ArrayList>();
        current = null;
        GeMoMaAnnotationFilter.MAX = eps.getNumberOfParameters();
        GeMoMaAnnotationFilter.stats = new int[GeMoMaAnnotationFilter.MAX][5];
        GeMoMaAnnotationFilter.evidenceStat = new int[GeMoMaAnnotationFilter.MAX][3];
        GeMoMaAnnotationFilter.combinedEvidence = new boolean[GeMoMaAnnotationFilter.MAX];
        prefix = new String[GeMoMaAnnotationFilter.MAX];
        weight = new double[GeMoMaAnnotationFilter.MAX];
        allInfos = new ArrayList<String>();
        hash = new HashSet<String>();
        ids = new HashSet<String>();
        annotInfo = new HashMap<String, String[]>();
        rnaSeq = false;
        sb = new StringBuffer();
        att = GeMoMaAnnotationFilter.del.keySet().toArray(new String[0]);
        k = 0;
        while (k < GeMoMaAnnotationFilter.MAX) {
            block78: {
                block79: {
                    block80: {
                        block76: {
                            sps = (SimpleParameterSet)eps.getParameterAt(k).getValue();
                            h = (String)sps.getParameterAt(0).getValue();
                            prefix[k] = h == null ? "" : h;
                            sampleInfo = String.valueOf(k) + (prefix[k] == null || prefix[k].length() == 0 ? "" : " (" + prefix[k] + ")");
                            weight[k] = (Double)sps.getParameterAt(1).getValue();
                            protocol.append("species " + (String)sampleInfo + "\n");
                            annotInfo.clear();
                            transcript = -1;
                            go = -1;
                            defline = -1;
                            if (!sps.getParameterAt(3).isSet()) break block76;
                            r = new BufferedReader(new FileReader(sps.getParameterAt(3).getValue().toString()));
                            header = r.readLine().split("\t");
                            i = 0;
                            while (i < header.length) {
                                var57_71 = header[i];
                                tmp = -1;
                                switch (var57_71.hashCode()) {
                                    case 2280: {
                                        if (var57_71.equals("GO")) {
                                            tmp = 1;
                                        }
                                        break;
                                    }
                                    case 1094458209: {
                                        if (var57_71.equals("transcriptName")) {
                                            tmp = 2;
                                        }
                                        break;
                                    }
                                }
                                switch (tmp) {
                                    case 2: {
                                        transcript = i;
                                        break;
                                    }
                                    case 1: {
                                        go = i;
                                        break;
                                    }
                                    default: {
                                        if (!header[i].endsWith("-defline")) break;
                                        defline = i;
                                    }
                                }
                                ++i;
                            }
                            if (transcript >= 0 && go >= 0 && defline >= 0) ** GOTO lbl114
                            r.close();
                            throw new IllegalArgumentException("annotation info " + (String)sampleInfo + " must be a tab-delimited file with at least the following columns: transcriptName, GO, and .*defline");
lbl-1000:
                            // 1 sources

                            {
                                split = line.split("\t");
                                annotInfo.put(split[transcript].toUpperCase(), split);
lbl114:
                                // 2 sources

                                ** while ((line = r.readLine()) != null)
                            }
lbl115:
                            // 1 sources

                            r.close();
                        }
                        fName = sps.getParameterAt(2).getValue().toString();
                        hash.clear();
                        list = new ArrayList<Prediction>();
                        r = new BufferedReader(new FileReader(fName));
                        while ((line = r.readLine()) != null) {
                            if (line.length() == 0) continue;
                            if (line.charAt(0) == '#') {
                                if (!line.startsWith("#SOFTWARE INFO: ")) continue;
                                hash.add(line);
                                continue;
                            }
                            split = line.split("\t");
                            t = split[2];
                            if (t.equals("gene")) continue;
                            if (t.equals(tag)) {
                                current = new Prediction(split, GeMoMaAnnotationFilter.MAX, k, prefix[k], GeMoMaAnnotationFilter.del, annotInfo, go, defline, defAttributes);
                                if (ids.contains(current.id)) {
                                    r.close();
                                    throw new IllegalArgumentException("The id (" + current.id + ") has been used before. You can try to use a prefix (cf. parameters).");
                                }
                                ids.add(current.id);
                                list.add(current);
                                rnaSeq |= split[8].indexOf(";tie=") > 0;
                                continue;
                            }
                            if (current == null) {
                                r.close();
                                throw new NullPointerException("There is no gene model. Please check parameter \"tag\" and the order within your annotation file " + (String)sampleInfo + ": " + fName);
                            }
                            if (split[8].contains("Parent=" + current.oldId)) {
                                if (t.equals("CDS")) {
                                    current.addCDS(line);
                                    continue;
                                }
                                if (!addAdd) continue;
                                current.addAdd(line);
                                continue;
                            }
                            r.close();
                            throw new IllegalArgumentException("The GFF has to be clustered, i.e., all features of a transcript must be adjacent lines:\n" + line);
                        }
                        r.close();
                        if (hash.size() != 1) {
                            if (hash.size() == 0) {
                                protocol.appendWarning("Evidence file " + (String)sampleInfo + " contains no parameter description\n");
                            } else {
                                protocol.appendWarning("Evidence file " + (String)sampleInfo + " contains a different parameter description\n");
                            }
                        }
                        sb.delete(0, sb.length());
                        i = 0;
                        while (i < att.length) {
                            v = GeMoMaAnnotationFilter.del.get(att[i]);
                            if (v[0] > 0) {
                                sb.append(String.valueOf(sb.length() == 0 ? "" : ", ") + v[0] + " \"" + att[i] + "\"");
                                v[0] = 0;
                            }
                            ++i;
                        }
                        if (sb.length() > 0) {
                            protocol.appendWarning("Delete attributes in evidence file " + (String)sampleInfo + ": " + sb + "\n");
                        }
                        it = hash.iterator();
                        while (it.hasNext()) {
                            allInfos.add((String)it.next());
                        }
                        if (!kmeans || list.size() < minNum) break block78;
                        Collections.sort(list);
                        matrix = new double[list.size()][ex.length];
                        anyNAN = false;
                        i = 0;
                        while (i < list.size()) {
                            cur = (Prediction)list.get(i);
                            j = 0;
                            while (j < ex.length) {
                                matrix[i][j] = Double.parseDouble(Tools.eval(engine, ex[j], cur.hash));
                                anyNAN |= Double.isNaN(matrix[i][j]);
                                ++j;
                            }
                            ++i;
                        }
                        if (matrix.length <= 1 || anyNAN) break block79;
                        if (margin <= 0) break block80;
                        quant = new double[list.size()];
                        first = 0;
                        last = 0;
                        old = -1;
                        oldChr = "";
                        i = 0;
                        while (i < list.size()) {
                            block81: {
                                cur = (Prediction)list.get(i);
                                changed = false;
                                if (cur.split[0].equals(oldChr) && old == cur.start) break block81;
                                if (true) ** GOTO lbl209
                                do {
                                    ++first;
                                    changed = true;
lbl209:
                                    // 2 sources

                                    help = (Prediction)list.get(first);
                                } while (!help.split[0].equals(cur.split[0]) || help.start + margin < cur.start);
                                if (true) ** GOTO lbl215
                                do {
                                    ++last;
                                    changed = true;
lbl215:
                                    // 2 sources

                                    if (last >= list.size()) break;
                                    help = (Prediction)list.get(last);
                                } while (help.split[0].equals(cur.split[0]) && help.start < cur.start + margin);
                            }
                            if (!changed) {
                                quant[i] = quant[i - 1];
                            } else if (last - first == 1) {
                                quant[i] = 0.0;
                            } else {
                                forSorting = new double[last - first];
                                j = first;
                                while (j < last) {
                                    forSorting[j - first] = matrix[j][0];
                                    ++j;
                                }
                                Arrays.sort(forSorting);
                                quant[i] = forSorting[(int)Math.ceil((double)(forSorting.length - 1) * quantile)];
                            }
                            oldChr = cur.split[0];
                            old = cur.start;
                            ++i;
                        }
                        i = 0;
                        while (i < list.size()) {
                            v0 = matrix[i];
                            v0[0] = v0[0] - quant[i];
                            ++i;
                        }
                    }
                    data = ex.length > 1 ? Kmeans.rescale(matrix) : matrix;
                    assignment = new Kmeans().cluster(data, cluster, 10);
                    mean = new double[cluster][ex.length];
                    stat = new int[cluster];
                    i = 0;
                    while (i < matrix.length) {
                        j = 0;
                        while (j < ex.length) {
                            v1 = mean[assignment[i]];
                            v2 = j;
                            v1[v2] = v1[v2] + matrix[i][j];
                            ++j;
                        }
                        v3 = assignment[i];
                        stat[v3] = stat[v3] + 1;
                        ++i;
                    }
                    protocol.append("cluster assignment: " + Arrays.toString(stat) + "\n");
                    dist = new double[mean.length];
                    i = 0;
                    while (i < mean.length) {
                        v4 = mean[i];
                        v4[0] = v4[0] / (double)stat[i];
                        dist[i] = mean[i][0];
                        ++i;
                    }
                    clone = (double[])dist.clone();
                    Arrays.sort(clone);
                    threshold = clone[good];
                    use = new boolean[dist.length];
                    i = 0;
                    while (i < dist.length) {
                        use[i] = dist[i] < threshold;
                        protocol.append(String.valueOf(i) + "\t" + dist[i] + "\t" + use[i] + "\t" + stat[i] + "\n");
                        ++i;
                    }
                    mlFiltered = new ArrayList<Prediction>();
                    i = 0;
                    while (i < list.size()) {
                        cur = (Prediction)list.get(i);
                        if (use[assignment[i]]) {
                            mlFiltered.add(cur);
                        }
                        ++i;
                    }
                    protocol.append("ml-filtered: " + mlFiltered.size() + "/" + list.size() + "\n");
                    list.clear();
                    list = mlFiltered;
                    break block78;
                }
                protocol.append("ml-filter not possible\n");
            }
            for (Prediction p : list) {
                pred = (ArrayList)pHash.get(p.contigStrand);
                if (pred == null) {
                    pred = new ArrayList();
                    pHash.put(p.contigStrand, pred);
                }
                pred.add(p);
            }
            ++k;
        }
        s = pHash.keySet();
        anz = 0;
        for (String chrSt : s) {
            anz += ((ArrayList)pHash.get(chrSt)).size();
        }
        protocol.append("all: " + anz + "\n");
        filtered = 0;
        if (anz > 0) {
            for (String chrSt : s) {
                pred = (ArrayList)pHash.get(chrSt);
                Collections.sort(pred);
                last = (Prediction)pred.get(pred.size() - 1);
                i = pred.size() - 2;
                while (i >= 0) {
                    cur = (Prediction)pred.get(i);
                    if (cur.compareTo(last) == 0) {
                        if (cur.score > last.score || cur.score == last.score && cur.id.compareTo(last.id) < 0) {
                            cur.combine(last, addAltTransIDs);
                            pred.remove(i + 1);
                            last = cur;
                        } else {
                            last.combine(cur, addAltTransIDs);
                            pred.remove(i);
                        }
                    } else {
                        last = cur;
                    }
                    --i;
                }
                i = pred.size() - 1;
                while (i >= 0) {
                    p = (Prediction)pred.get(i);
                    p.setEvidenceAndWeight(weight);
                    if (!Tools.filter(engine, filter, p.hash)) {
                        pred.remove(i);
                    } else {
                        GeMoMaAnnotationFilter.fillEvidence(p.evidence, 0);
                    }
                    --i;
                }
                filtered += pred.size();
            }
        }
        protocol.append("filtered: " + filtered + "\n");
        out = Tools.createTempFile("GAF-filtered", tempD);
        pa = parameters.getParameterForName("intermediate result");
        v5 = out2 = pa == null || (Boolean)pa.getValue() == false ? null : Tools.createTempFile("GAF-combined", tempD);
        if (filtered >= 0) {
            w = new BufferedWriter(new FileWriter(out));
            sos = SafeOutputStream.getSafeOutputStream(out2 == null ? null : new FileOutputStream(out2));
            w.append("##gff-version 3");
            w.newLine();
            sos.writeln("##gff-version 3");
            i = 0;
            while (i < allInfos.size()) {
                st = (String)allInfos.get(i);
                w.append(st);
                w.newLine();
                sos.writeln(st);
                ++i;
            }
            w.append("#SOFTWARE INFO: " + this.getShortName() + " " + this.getToolVersion() + "; ");
            info = JstacsTool.getSimpleParameterInfo(parameters);
            if (info != null) {
                w.append("SIMPLE PARAMETERS: " + info);
            }
            w.newLine();
            sos.writeln("#SOFTWARE INFO: " + this.getShortName() + " " + this.getToolVersion() + "; " + (info != null ? "SIMPLE PARAMETERS: " + info : ""));
            anno = new StringBuffer();
            for (String chrSt : s) {
                pred = (ArrayList)pHash.get(chrSt);
                if (pred.size() <= 0) continue;
                if (!sos.doesNothing()) {
                    for (Prediction p : pred) {
                        anno.delete(0, anno.length());
                        p.write(anno, null, this.gene);
                        sos.write(anno);
                    }
                }
                this.split(addAdd, this.clustered, pred, comp, engine, lenPerc, altFilter, rnaSeq, maxTranscripts, w, cbTh, protocol);
            }
            w.close();
            sos.close();
        }
        protocol.append("clustered: " + this.clustered[0] + "\n\n");
        protocol.append("genes: " + this.gene + "\n");
        protocol.append("transcripts: " + this.transcripts + "\n\n");
        protocol.append("\tgenes\tgenes with maxTie=1\ttranscripts\ttranscripts with tie=1\ttranscripts with tie=NA, tpc=1\n");
        i = 0;
        while (i < GeMoMaAnnotationFilter.stats.length) {
            protocol.append("(max)evidence=" + (i + 1));
            j = 0;
            while (j < GeMoMaAnnotationFilter.stats[i].length) {
                protocol.append("\t" + GeMoMaAnnotationFilter.stats[i][j]);
                ++j;
            }
            protocol.append("\n");
            ++i;
        }
        if (GeMoMaAnnotationFilter.MAX > 1) {
            protocol.append("\ninput\tfiltered transcripts\tfinal transcripts supported\tfinal genes supported\n");
            i = 0;
            while (i < GeMoMaAnnotationFilter.MAX) {
                protocol.append("input " + i + (prefix[i].length() > 0 ? " (" + prefix[i] + ")" : "") + "\t" + GeMoMaAnnotationFilter.evidenceStat[i][0] + "\t" + GeMoMaAnnotationFilter.evidenceStat[i][1] + "\t" + GeMoMaAnnotationFilter.evidenceStat[i][2] + "\n");
                ++i;
            }
        }
        res = new ArrayList<TextResult>();
        res.add(new TextResult("filtered predictions", "Result", new FileParameter.FileRepresentation(out.getAbsolutePath()), "gff", this.getToolName(), null, true));
        if (out2 != null) {
            res.add(new TextResult("intermediate predictions", "Result", new FileParameter.FileRepresentation(out2.getAbsolutePath()), "gff", this.getToolName(), null, true));
        }
        return new ToolResult("", "", null, new ResultSet(res), parameters, this.getToolName(), new Date());
    }

    /*
     * Unable to fully structure code
     */
    void split(boolean addAdd, int[] clustered, ArrayList<Prediction> pred, UserSpecifiedComparator comp, ScriptEngine engine, double lenPerc, String altFilter, boolean rnaSeq, int maxTranscripts, BufferedWriter w, double cbTh, Protocol protocol) throws Exception {
        i = 0;
        next = pred.get(i);
        currentCluster = new ArrayList<Prediction>();
        while (i < pred.size()) {
            currentCluster.clear();
            current = next;
            currentCluster.add(current);
            end = current.end;
            ++i;
            if (true) ** GOTO lbl17
            do {
                end = Math.max(end, next.end);
                currentCluster.add(next);
                ++i;
lbl17:
                // 2 sources

                if (i >= pred.size()) break;
                next = pred.get(i);
            } while (end > next.start);
            if (clustered != null) {
                clustered[0] = clustered[0] + 1;
            }
            for (Prediction p : currentCluster) {
                comp.prepare(p);
                p.altCand = Tools.filter(engine, altFilter, p.hash);
            }
            Collections.sort(currentCluster, comp);
            for (Prediction p : currentCluster) {
                p.comp = null;
            }
            this.create(addAdd, rnaSeq, maxTranscripts, currentCluster, w, lenPerc, cbTh, protocol);
        }
    }

    void create(boolean addAdd, boolean rnaSeq, int maxTranscripts, ArrayList<Prediction> list, BufferedWriter w, double lenPerc, double cbTh, Protocol protocol) throws Exception {
        ArrayList sel = new ArrayList();
        ArrayList<BitSet> usedBp = new ArrayList<BitSet>();
        int clusterStart = Integer.MAX_VALUE;
        int clusterEnd = 0;
        int i = 0;
        while (i < list.size()) {
            Prediction p = list.get(i);
            if (p.start < clusterStart) {
                clusterStart = p.start;
            }
            if (p.end > clusterEnd) {
                clusterEnd = p.end;
            }
            ++i;
        }
        int minOverlapThreshold = 0;
        int i2 = 0;
        while (i2 < list.size()) {
            Prediction n = list.get(i2);
            int overlapIdx = -1;
            int enoughOverlap = 0;
            int maxOverlap = 0;
            int j = 0;
            while (j < sel.size()) {
                int o = n.overlap((BitSet)usedBp.get(j), clusterStart, clusterEnd);
                if (o > minOverlapThreshold) {
                    ++enoughOverlap;
                    if (o > maxOverlap) {
                        maxOverlap = o;
                        overlapIdx = j;
                    }
                }
                ++j;
            }
            if (enoughOverlap == 0) {
                ArrayList<Prediction> selection = new ArrayList<Prediction>();
                selection.add(n);
                n.used = true;
                sel.add(selection);
                BitSet usedCov = new BitSet(clusterEnd - clusterStart + 1);
                n.fillNuc(usedCov, clusterStart, clusterEnd);
                usedBp.add(usedCov);
            } else if (n.altCand && enoughOverlap == 1) {
                ArrayList selection = (ArrayList)sel.get(overlapIdx);
                int k = 0;
                Prediction x = (Prediction)selection.get(k);
                double diff = (double)Math.abs(x.length - n.length) / (double)x.length * 100.0;
                if (diff <= lenPerc) {
                    double min = 2.0 * (double)Math.min(x.cds.size(), n.cds.size());
                    double overlap = x.commonBorders(n) / min;
                    if (overlap >= cbTh) {
                        selection.add(n);
                        n.used = true;
                        n.fillNuc((BitSet)usedBp.get(overlapIdx), clusterStart, clusterEnd);
                    }
                }
            }
            ++i2;
        }
        Prediction n = null;
        StringBuffer anno = new StringBuffer();
        int j = 0;
        while (j < sel.size()) {
            ArrayList selection = (ArrayList)sel.get(j);
            int start = Integer.MAX_VALUE;
            int end = Integer.MIN_VALUE;
            maxEvidence = 0;
            Arrays.fill(combinedEvidence, false);
            maxTie = -1.0;
            complete = 0;
            int i3 = 0;
            anno.delete(0, anno.length());
            while (i3 < selection.size() && i3 < maxTranscripts) {
                n = (Prediction)selection.get(i3);
                n.write(anno, protocol, this.gene);
                start = Math.min(start, addAdd ? Integer.parseInt(n.split[3]) : n.start);
                end = Math.max(end, addAdd ? Integer.parseInt(n.split[4]) : n.end);
                ++i3;
            }
            this.transcripts += i3;
            if (i3 > 0) {
                GeMoMaAnnotationFilter.fillEvidence(combinedEvidence, 2);
                w.append(String.valueOf(n.split[0]) + "\tGAF\tgene\t" + start + "\t" + end + "\t.\t" + n.split[6] + "\t.\tID=gene_" + this.gene + ";transcripts=" + i3 + ";complete=" + complete + (rnaSeq ? ";maxTie=" + (maxTie < 0.0 ? "NA" : Double.valueOf(maxTie)) : "") + (MAX > 1 ? ";maxEvidence=" + maxEvidence + ";combinedEvidence=" + GeMoMaAnnotationFilter.count(combinedEvidence) : ""));
                w.newLine();
                w.append(anno);
                int[] nArray = stats[maxEvidence - 1];
                nArray[0] = nArray[0] + 1;
                if (maxTie == 1.0) {
                    int[] nArray2 = stats[maxEvidence - 1];
                    nArray2[1] = nArray2[1] + 1;
                }
                ++this.gene;
            }
            ++j;
        }
    }

    static int count(boolean[] evidence) {
        int count = 0;
        if (evidence != null) {
            int i = 0;
            while (i < evidence.length) {
                if (evidence[i]) {
                    ++count;
                }
                ++i;
            }
        } else {
            count = 1;
        }
        return count;
    }

    static double sum(boolean[] evidence, double[] weight) {
        double w = 0.0;
        int i = 0;
        while (i < evidence.length) {
            if (evidence[i]) {
                w += weight[i];
            }
            ++i;
        }
        return w;
    }

    static void fillEvidence(boolean[] evidence, int idx) {
        int i = 0;
        while (i < MAX) {
            if (evidence[i]) {
                int[] nArray = evidenceStat[i];
                int n = idx;
                nArray[n] = nArray[n] + 1;
            }
            ++i;
        }
    }

    @Override
    public ToolParameterSet getToolParameters() {
        try {
            ExpandableParameterSet attribute = new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "attribute", "An attribute used for the kmeans clustering", true, new RegExpValidator("[a-zA-Z 0-9\\.,()><=!'\\-\\+\\*\\/]*"))), "attribute", "", 1);
            ((SimpleParameterSet)attribute.getParameterAt(0).getValue()).getParameterAt(0).setValue("Math.abs(maxScore-Math.max(0,score))/maxScore");
            return new ToolParameterSet(this.getShortName(), new SimpleParameter(DataType.STRING, "tag", "the tag used to read the GeMoMa annotations", true, "mRNA"), new ParameterSetContainer("predicted annotation", "", new ExpandableParameterSet(new SimpleParameterSet(new SimpleParameter(DataType.STRING, "prefix", "the prefix can be used to distinguish predictions from different input files", false, new RegExpValidator("\\w*")), new SimpleParameter(DataType.DOUBLE, "weight", "the weight can be used to prioritize predictions from different input files; each prediction will get an additional attribute sumWeight that can be used in the filter", false, new NumberValidator<Double>(0.0, 1000.0), 1.0), new FileParameter("gene annotation file", "GFF file containing the gene annotations (predicted by GeMoMa)", "gff,gff3", true, new FileExistsValidator(), true), new FileParameter("annotation info", "annotation information of the reference, tab-delimited file containing at least the columns transcriptName, GO and .*defline", "tabular", false, new FileExistsValidator())), "gene annotations", "", 1)), new SimpleParameter(DataType.STRING, "default attributes", "Comma-separated list of attributes that is set to NaN if they are not given in the annotation file. This allows to use these attributes for sorting or filter criteria. It is especially meaningful if the gene annotation files were received fom different software packages (e.g., GeMoMa, Braker, ...) having different attributes.", true, "tie,tde,tae,iAA,pAA,score,lpm,maxGap,bestScore,maxScore,raa,rce"), new SelectionParameter(DataType.PARAMETERSET, new String[]{"NO", "YES"}, new ParameterSet[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new SimpleParameter(DataType.INT, "minimal number of predictions", "only gene sets with at least this number of predictions will be used for clustering", true, new NumberValidator<Integer>(0, 100000000), 1000), new SimpleParameter(DataType.INT, "cluster", "the number of clusters to be used for kmeans", true, new NumberValidator<Integer>(2, 100), 2), new SimpleParameter(DataType.INT, "good cluster", "the number of good clusters, good clusters are those with small mean, all members of a good cluster are further used", true, new NumberValidator<Integer>(1, 99), 1), new SelectionParameter(DataType.PARAMETERSET, new String[]{"GLOBAL", "LOCAL"}, new ParameterSet[]{new SimpleParameterSet(new Parameter[0]), new SimpleParameterSet(new SimpleParameter(DataType.INT, "margin", "the number of bp upstream and downstream of a predictions used to identify neighboring predictions for the statistics", true, new NumberValidator<Integer>(0, 100000000), 1000000), new SimpleParameter(DataType.DOUBLE, "quantile", "the quantile used for the local trend", true, new NumberValidator<Double>(0.0, 1.0), 0.2))}, "trend", "whether a local component should be used for the cluster attribute (might be helpful for regions with different conservation (e.g. introgressions in chromosomes))", true))}, "kmeans", "whether kmeans should be performed for each input file and clusters with large mean distance to the origin will be discarded", true), new SimpleParameter(DataType.STRING, "filter", "A filter can be applied to transcript predictions to receive only reasonable predictions. The filter is applied to the GFF attributes. The default filter decides based on the completeness of the prediction (start=='M' and stop=='*') and the relative score (score/aa>=0.75) whether a prediction is used or not. In addition, predictions without score (isNaN(score)) will be used as external annotations do not have the attribute score. Different criteria can be combined using 'and' and 'or'. A more sophisticated filter could be applied for instance using the completeness, the relative score, the evidence as well as statistics based on RNA-seq: start=='M' and stop=='*' and score/aa>=0.75 and (evidence>1 or tpc==1.0)", false, new RegExpValidator("[a-zA-Z 0-9\\.()><=!'\\-\\+\\*\\/]*"), "start=='M' and stop=='*' and (isNaN(score) or score/aa>=0.75)"), new SimpleParameter(DataType.STRING, "sorting", "comma-separated list that defines the way predictions are sorted within a cluster", true, "sumWeight,score,aa"), new SimpleParameter(DataType.BOOLEAN, "intermediate result", "a switch to decide whether an intermediate result of filtered predictions that are not combined to genes should be returned", true, false), new SimpleParameter(DataType.DOUBLE, "length difference", "maximal percentage of length difference between the representative transcript and an alternative transcript, alternative transcripts with a higher percentage are discarded", false, new NumberValidator<Double>(0.0, 10000.0)), new SimpleParameter(DataType.STRING, "alternative transcript filter", "If a prediction is suggested as an alternative transcript, this additional filter will be applied. The filter works syntactically like the 'filter' parameter and allows you to keep the number of alternative transcripts small based on meaningful criteria. Reasonable filter could be based on RNA-seq data (tie==1) or on sumWeight (sumWeight>1). A more sophisticated filter could be applied combining several criteria: tie==1 or sumWeight>1", false, new RegExpValidator("[a-zA-Z 0-9\\.()><=!?:'\\-\\+\\*\\/]*"), "tie==1 or sumWeight>1"), new SimpleParameter(DataType.DOUBLE, "common border filter", "the filter on the common borders of transcripts, the lower the more transcripts will be checked as alternative splice isoforms", true, new NumberValidator<Double>(0.0, 1.0), 0.75), new SimpleParameter(DataType.INT, "maximal number of transcripts per gene", "the maximal number of allowed transcript predictions per gene", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE), Integer.MAX_VALUE), new SimpleParameter(DataType.BOOLEAN, "add alternative transcripts", "a switch to decide whether the IDs of alternative transcripts that have the same CDS should be listed for each prediction", true, false), new SimpleParameter(DataType.BOOLEAN, "transfer features", "if true, additional features like UTRs will be transfered from the input to the output. Only features of the representatives will be transfered. The UTRs of identical CDS predictions listed in \"alternative\" will not be transfered or combined", true, false));
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new RuntimeException();
        }
    }

    @Override
    public String getToolName() {
        return "GeMoMa Annotation Filter";
    }

    @Override
    public String getShortName() {
        return "GAF";
    }

    @Override
    public String getDescription() {
        return "filters most reliable gene predictions";
    }

    @Override
    public String getHelpText() {
        return "This tool combines and filters gene predictions from different sources yielding a common gene prediction. The tool does not modify the predictions, but filters redundant and low-quality predictions and selects relevant predictions. In addition, it adds attributes to the annotation of transcript predictions.\n\nThe algorithm does the following:\nFirst, redundant predictions are identified (and additional attributes (evidence, sumWeight) are introduced).\nSecond, the predictions are filtered using the user-specified criterium based on the attributes from the annotation.\nThird, clusters of overlapping predictions are determined, the predictions are sorted within the cluster and relevant predictions are extracted.\n\nOptionally, annotation info can be added for each reference organism enabling a functional prediction for predicted transcripts based on the function of the reference transcript.\nPhytozome provides annotation info tables for plants, but annotation info can be used from any source as long as they are tab-delimited files with at least the following columns: transcriptName, GO and .*defline.\n\nInitially, GAF was build to combine gene predictions obtained from **GeMoMa**. It allows to combine the predictions from multiple reference organisms, but works also using only one reference organism. However, GAF also allows to integrate predictions from ab-initio or purely RNA-seq-based gene predictors as well as manually curated annotation. If you like to do so, we recommend to run **AnnotationEvidence** for each of these input files to add additional attributes that can be used for sorting and filtering within **GAF**. The sort and filter criteria need to be carefully revised in this case. Default values can be set for missing attributes." + MORE;
    }

    @Override
    public JstacsTool.ResultEntry[] getDefaultResultInfos() {
        return new JstacsTool.ResultEntry[]{new JstacsTool.ResultEntry(TextResult.class, "gff", "filtered predictions")};
    }

    @Override
    public ToolResult[] getTestCases(String path) {
        try {
            return new ToolResult[]{new ToolResult(FileManager.readFile(String.valueOf(path) + File.separator + "tests/gemoma/xml/gaf-test.xml"))};
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
    }

    static class Prediction
    implements Comparable<Prediction> {
        static boolean first = true;
        boolean altCand = false;
        boolean used = false;
        String[] split;
        ArrayList<CDS> cds;
        ArrayList<String> add;
        HashMap<String, String> hash;
        int length;
        int start;
        int end;
        int score;
        String contigStrand;
        HashSet<String> alternative;
        HashSet<String> alternativeTranscript;
        boolean[] evidence;
        String prefix;
        String oldId;
        String id;
        HashSet<String> gos;
        HashSet<String> defl;
        Comparable[] comp;
        HashSet<Integer> s;
        HashSet<Integer> e;

        public Prediction(String[] split, int max, int index, String prefix, HashMap<String, int[]> del) {
            this(split, max, index, prefix, del, null, -1, -1, null);
        }

        public Prediction(String[] split, int max, int index, String prefix, HashMap<String, int[]> del, HashMap<String, String[]> annotInfo, int go, int defline, String[] defAttributes) {
            this.evidence = new boolean[max];
            Arrays.fill(this.evidence, false);
            this.evidence[index] = true;
            this.split = split;
            this.contigStrand = String.valueOf(split[0]) + split[6];
            split = split[8].split(";");
            boolean lastNotSemi = this.split[8].charAt(this.split[8].length() - 1) != ';';
            this.hash = new HashMap();
            String par = null;
            int i = 0;
            while (i < split.length) {
                int idx = split[i].indexOf(61);
                String s = split[i].substring(idx + 1);
                String key = split[i].substring(0, idx);
                int[] stat = del.get(key);
                if (stat != null) {
                    stat[0] = stat[0] + 1;
                    if (key.equals("Parent")) {
                        par = s;
                    }
                    String delete = String.valueOf(split[i]) + (i + 1 == split.length && lastNotSemi ? "" : ";");
                    this.split[8] = this.split[8].replace(delete, "");
                } else {
                    if (s.charAt(0) == '?') {
                        s = "NA";
                    }
                    this.hash.put(key, s);
                }
                ++i;
            }
            String sc = this.hash.get("score");
            this.score = sc == null ? Integer.MIN_VALUE : Integer.parseInt(sc);
            this.oldId = this.hash.get("ID");
            String rg = this.hash.get("ref-gene");
            if (rg == null) {
                rg = par != null ? par : this.oldId;
                this.hash.put("ref-gene", rg);
                this.split[8] = this.split[8].replace("ID=" + this.oldId, "ID=" + this.oldId + ";ref-gene=" + this.hash.get("ref-gene"));
            }
            if (prefix != null && prefix.length() > 0) {
                this.prefix = prefix;
                if (prefix.charAt(prefix.length() - 1) != '_') {
                    this.prefix = String.valueOf(this.prefix) + "_";
                }
                this.id = String.valueOf(this.prefix) + this.oldId;
                this.split[8] = this.split[8].replace("ID=" + this.oldId, "ID=" + this.id);
                this.split[8] = this.split[8].replace("ref-gene=" + rg, "ref-gene=" + this.prefix + rg);
                this.hash.put("ref-gene", String.valueOf(this.prefix) + rg);
            } else {
                this.id = this.oldId;
            }
            if (defAttributes != null) {
                String nan = "NaN";
                int i2 = 0;
                while (i2 < defAttributes.length) {
                    if (defAttributes[i2] != null && !this.hash.containsKey(defAttributes[i2])) {
                        this.hash.put(defAttributes[i2], nan);
                    }
                    ++i2;
                }
            }
            if (annotInfo != null && annotInfo.size() > 0) {
                this.gos = new HashSet();
                this.defl = new HashSet();
                int i3 = -1;
                String[] tab = null;
                while ((i3 = this.oldId.indexOf(".", i3 + 1)) >= 0 && (tab = annotInfo.get(this.oldId.substring(0, i3))) == null) {
                }
                if (tab != null) {
                    String goValue;
                    Object object = goValue = tab.length > go ? tab[go] : null;
                    if (goValue != null) {
                        String[] stringArray = goValue.split(",");
                        int n = stringArray.length;
                        int n2 = 0;
                        while (n2 < n) {
                            String e = stringArray[n2];
                            if (e.length() > 0) {
                                this.gos.add(e);
                            }
                            ++n2;
                        }
                    }
                    if (tab.length > defline) {
                        this.defl.add(tab[12].replaceAll(";", ","));
                    }
                } else {
                    System.out.println("Could not identify annotation info for: " + this.oldId);
                }
            }
            this.cds = new ArrayList();
            this.length = 0;
            this.start = Integer.MAX_VALUE;
            this.end = Integer.MIN_VALUE;
            this.alternative = new HashSet();
            this.alternativeTranscript = new HashSet();
            this.add = null;
        }

        public int getIndex() {
            int i = 0;
            while (i < this.evidence.length && !this.evidence[i]) {
                ++i;
            }
            return i;
        }

        void addAdd(String line) {
            if (this.add == null) {
                this.add = new ArrayList();
            }
            this.add.add(line);
        }

        public void setEvidenceAndWeight(double[] weight) {
            this.hash.put("evidence", "" + GeMoMaAnnotationFilter.count(this.evidence));
            this.hash.put("sumWeight", "" + GeMoMaAnnotationFilter.sum(this.evidence, weight));
        }

        void addCDS(String cds) {
            if (this.prefix != null && this.prefix.length() > 0) {
                cds = GeMoMaAnnotationFilter.replace(cds, "Parent=" + this.oldId, "Parent=" + this.id, 0);
                cds = GeMoMaAnnotationFilter.replace(cds, "ID=" + this.oldId, "ID=" + this.id, 0);
            }
            CDS current = new CDS(cds);
            this.cds.add(current);
            this.length += current.end - current.start + 1;
            this.start = Math.min(this.start, current.start);
            this.end = Math.max(this.end, current.end);
        }

        @Override
        public int compareTo(Prediction o) {
            int res = this.split[0].compareTo(o.split[0]);
            if (res == 0 && (res = Integer.compare(this.start, o.start)) == 0 && (res = Integer.compare(this.end, o.end)) == 0 && (res = Integer.compare(this.cds.size(), o.cds.size())) == 0) {
                CDS part1 = null;
                CDS part2 = null;
                int i = 0;
                while (i < this.cds.size()) {
                    part1 = this.cds.get(i);
                    part2 = o.cds.get(i);
                    if (part1.start == part2.start) {
                        if (part1.end != part2.end) {
                            res = Integer.compare(part1.end, part2.end);
                            break;
                        }
                    } else {
                        res = Integer.compare(part1.start, part2.start);
                        break;
                    }
                    ++i;
                }
            }
            return res;
        }

        public void combine(Prediction n, boolean addAltTransIDs) {
            String rg = n.hash.get("ref-gene");
            if (!rg.equals(this.hash.get("ref-gene"))) {
                this.alternative.add(rg);
            }
            int i = 0;
            while (i < this.evidence.length) {
                int n2 = i;
                this.evidence[n2] = this.evidence[n2] | n.evidence[i];
                ++i;
            }
            this.alternative.addAll(n.alternative);
            if (addAltTransIDs) {
                this.alternativeTranscript.add(n.id);
                this.alternativeTranscript.addAll(n.alternativeTranscript);
            }
            if (this.gos != null) {
                if (n.gos != null) {
                    this.gos.addAll(n.gos);
                    this.defl.addAll(n.defl);
                }
            } else if (n.gos != null) {
                this.gos = n.gos;
                this.defl = n.defl;
            }
        }

        public void write(StringBuffer w, Protocol p, int gene) throws IOException, NumberFormatException, ScriptException {
            int i;
            Object[] it;
            int count = Integer.parseInt(this.hash.get("evidence"));
            String we = this.hash.get("sumWeight");
            String t = this.hash.get("tie");
            String tpc = this.hash.get("tpc");
            if (p != null) {
                int i2 = 0;
                while (i2 < this.evidence.length) {
                    int n = i2;
                    combinedEvidence[n] = combinedEvidence[n] | this.evidence[i2];
                    ++i2;
                }
                int[] nArray = stats[count - 1];
                nArray[2] = nArray[2] + 1;
                if (t == null || t.equals("NA")) {
                    if (tpc != null && !tpc.equals("NA") && Double.parseDouble(tpc) == 1.0) {
                        int[] nArray2 = stats[count - 1];
                        nArray2[4] = nArray2[4] + 1;
                    }
                } else if (t != null) {
                    double tie = Double.parseDouble(t);
                    if (tie == 1.0) {
                        int[] nArray3 = stats[count - 1];
                        nArray3[3] = nArray3[3] + 1;
                    }
                    maxTie = Math.max(tie, maxTie);
                }
            }
            int i3 = 0;
            while (i3 < this.split.length) {
                if (this.add == null && (i3 == 3 || i3 == 4)) {
                    w.append("\t" + (i3 == 3 ? this.start : this.end));
                } else {
                    w.append(String.valueOf(i3 == 0 ? "" : "\t") + this.split[i3]);
                }
                ++i3;
            }
            String h = this.split[this.split.length - 1];
            if (h.charAt(h.length() - 1) != ';') {
                w.append(";");
            }
            w.append("evidence=" + count + ";");
            if (p != null) {
                w.append("Parent=gene_" + gene + ";");
            }
            w.append("sumWeight=" + we + ";");
            if (p != null) {
                maxEvidence = Math.max(count, maxEvidence);
                if (this.hash.containsKey("start") && this.hash.containsKey("stop")) {
                    complete += this.hash.get("start").charAt(0) == 'M' && this.hash.get("stop").charAt(0) == '*' ? 1 : 0;
                } else if (first) {
                    p.appendWarning("Could not find attributes 'start' or 'stop' for at least one prediction. You can use AnnotationEvidence to add these to the input file.");
                    first = false;
                }
            }
            if (this.alternative.size() > 0) {
                it = this.alternative.toArray(new String[0]);
                Arrays.sort(it);
                w.append("alternative=\"" + (String)it[0]);
                i = 1;
                while (i < it.length) {
                    w.append("," + (String)it[i]);
                    ++i;
                }
                w.append("\";");
            }
            if (this.alternativeTranscript.size() > 0) {
                it = this.alternativeTranscript.toArray(new String[0]);
                Arrays.sort(it);
                w.append("alternativeTranscript=\"" + (String)it[0]);
                i = 1;
                while (i < it.length) {
                    w.append("," + (String)it[i]);
                    ++i;
                }
                w.append("\";");
            }
            if (this.gos != null) {
                Object[] defTerms;
                Object[] goTerms;
                Object[] objectArray = goTerms = this.gos == null ? new String[]{} : this.gos.toArray(new String[0]);
                if (goTerms != null && goTerms.length > 0) {
                    h = Arrays.toString(goTerms).replace("[", "\"").replace("]", "\"");
                    w.append("potential_GO=" + h + ";");
                }
                Object[] objectArray2 = defTerms = this.defl == null ? new String[]{} : this.defl.toArray(new String[0]);
                if (defTerms != null && defTerms.length > 0) {
                    h = Arrays.toString(defTerms).replace("[", "\"").replace("]", "\"");
                    w.append("potential_defline=" + h);
                }
            }
            w.append("\n");
            if (this.add != null) {
                int i4 = 0;
                while (i4 < this.add.size()) {
                    String line = this.add.get(i4);
                    if (this.oldId != this.id) {
                        line = line.replace("Parent=" + this.oldId, "Parent=" + this.id);
                    }
                    w.append(line);
                    w.append("\n");
                    ++i4;
                }
            }
            int i5 = 0;
            while (i5 < this.cds.size()) {
                w.append(this.cds.get((int)i5).line);
                w.append("\n");
                ++i5;
            }
            if (p != null) {
                GeMoMaAnnotationFilter.fillEvidence(this.evidence, 1);
            }
        }

        public String toString() {
            String r = "";
            int i = 0;
            while (i < this.split.length) {
                r = String.valueOf(r) + (i == 0 ? "" : "\t") + this.split[i];
                ++i;
            }
            return r;
        }

        public double commonBorders(Prediction o) {
            CDS c;
            int i;
            int anz = 0;
            if (this.s == null) {
                this.s = new HashSet();
                this.e = new HashSet();
                i = 0;
                while (i < this.cds.size()) {
                    c = this.cds.get(i);
                    this.s.add(c.start);
                    this.e.add(c.end);
                    ++i;
                }
            }
            i = 0;
            while (i < o.cds.size()) {
                c = o.cds.get(i);
                if (this.s.contains(c.start)) {
                    ++anz;
                }
                if (this.e.contains(c.end)) {
                    ++anz;
                }
                ++i;
            }
            return anz;
        }

        void fillNuc(BitSet nuc, int s, int e) {
            int i = 0;
            while (i < this.cds.size()) {
                CDS c = this.cds.get(i);
                try {
                    nuc.set(c.start - s, c.end - s + 1);
                }
                catch (IndexOutOfBoundsException ioobe) {
                    System.out.println(Arrays.toString(this.split));
                    System.out.println(c.line);
                    throw ioobe;
                }
                ++i;
            }
        }

        int overlap(BitSet b, int clusterStart, int clusterEnd) {
            int dir = this.split[6].charAt(0) == '+' ? 1 : -1;
            int overlap = 0;
            int i = dir == 1 ? 0 : this.cds.size() - 1;
            while (!(dir == 1 ? i >= this.cds.size() : i < 0)) {
                CDS c = this.cds.get(i);
                int s = c.start - clusterStart;
                int e = c.end - clusterStart;
                int set = b.nextSetBit(s);
                while (set >= 0 && set < e) {
                    int unset = b.nextClearBit(set);
                    if (unset > e) {
                        overlap += e - set + 1;
                        break;
                    }
                    overlap += unset - set;
                    set = b.nextSetBit(unset);
                }
                if (set < 0) break;
                i += dir;
            }
            return overlap;
        }

        static class CDS {
            String line;
            int start;
            int end;

            CDS(String line) {
                this.line = line;
                String[] split = line.split("\t");
                this.start = Integer.parseInt(split[3]);
                this.end = Integer.parseInt(split[4]);
            }
        }
    }

    static class UserSpecifiedComparator
    implements Comparator<Prediction> {
        static HashSet<String> asDouble = new HashSet();
        String[] keys;
        HashSet<String> errors;
        Protocol protocol;
        ScriptEngine engine;

        static {
            asDouble.add("aa");
            asDouble.add("raa");
            asDouble.add("score");
            asDouble.add("bestScore");
            asDouble.add("maxScore");
            asDouble.add("tae");
            asDouble.add("tde");
            asDouble.add("tie");
            asDouble.add("minSplitReads");
            asDouble.add("tpc");
            asDouble.add("minCov");
            asDouble.add("avgCov");
            asDouble.add("iAA");
            asDouble.add("pAA");
            asDouble.add("lpm");
            asDouble.add("maxGap");
            asDouble.add("evidence");
            asDouble.add("sumWeight");
        }

        public UserSpecifiedComparator(String specified, ScriptEngine engine, Protocol protocol) {
            this.keys = specified.split(",");
            int i = 0;
            while (i < this.keys.length) {
                this.keys[i] = this.keys[i].trim();
                ++i;
            }
            this.errors = new HashSet();
            this.engine = engine;
            this.protocol = protocol;
        }

        public static Double parse(String d) {
            if (d.equals("NA")) {
                return null;
            }
            if (d.equals("NA")) {
                return Double.NaN;
            }
            return -Double.parseDouble(d);
        }

        public void prepare(Prediction p) {
            p.comp = new Comparable[this.keys.length + 1];
            int i = 0;
            while (i < this.keys.length) {
                boolean asDoubleNow;
                String v;
                block4: {
                    v = p.hash.get(this.keys[i]);
                    asDoubleNow = asDouble.contains(this.keys[i]);
                    if (v == null) {
                        try {
                            v = Tools.eval(this.engine, this.keys[i], p.hash);
                            asDoubleNow = true;
                        }
                        catch (ScriptException se) {
                            if (this.errors.contains(this.keys[i])) break block4;
                            this.errors.add(this.keys[i]);
                            this.protocol.appendWarning("Could not find key (" + this.keys[i] + ") that is used for sorting\n");
                        }
                    }
                }
                p.comp[i] = asDoubleNow ? UserSpecifiedComparator.parse(v) : v;
                ++i;
            }
            p.comp[this.keys.length] = p.id;
        }

        @Override
        public int compare(Prediction o1, Prediction o2) {
            int d = 0;
            int i = 0;
            while (i < o1.comp.length && d == 0) {
                if (o1.comp[i] != null && o2.comp[i] != null) {
                    d = o1.comp[i].compareTo(o2.comp[i]);
                }
                ++i;
            }
            return d;
        }
    }
}

