/*
 * Decompiled with CFR 0.152.
 */
package projects.gemoma;

import de.jstacs.io.ArrayHandler;
import java.io.BufferedReader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import projects.gemoma.Tools;

public class ReferenceBasedComparison {
    public static void main(String[] args) throws Exception {
        int parts = 1;
        int num = parts * (args.length - 2);
        double maxThreshold = Double.parseDouble(args[0]);
        double sampleThreshold = Double.parseDouble(args[1]);
        boolean simple = false;
        HashMap hash = new HashMap();
        int i = 2;
        while (i < args.length) {
            String line;
            BufferedReader r = Tools.openGzOrPlain(args[i]);
            while ((line = r.readLine()) != null && line.charAt(0) == '#') {
            }
            do {
                if (line.indexOf("\tmRNA\t") < 0) continue;
                String[] gff = line.split("\t");
                int index = (i - 2) * parts;
                String[] split = gff[8].split(";");
                String ref = null;
                String alt = null;
                String id = null;
                String iAA = null;
                int j = 0;
                while (j < split.length) {
                    if (split[j].startsWith("ID=")) {
                        id = ReferenceBasedComparison.get(split[j]);
                    } else if (split[j].startsWith("ref-gene=")) {
                        ref = ReferenceBasedComparison.get(split[j]);
                    } else if (split[j].startsWith("alternativeTranscript=")) {
                        alt = ReferenceBasedComparison.get(split[j]);
                    } else if (split[j].startsWith("iAA=")) {
                        iAA = ReferenceBasedComparison.get(split[j]);
                    }
                    ++j;
                }
                ref = id;
                ReferenceBasedComparison.add(simple, hash, index, num, id, gff[0], String.valueOf(gff[3]) + "-" + gff[4], iAA, ref, alt);
            } while ((line = r.readLine()) != null);
            r.close();
            ++i;
        }
        Object[] genes = hash.keySet().toArray(new String[0]);
        Arrays.sort(genes);
        String[] additional = new String[]{"sum"};
        if (parts > 1) {
            System.out.print("\t");
            int j = 2;
            while (j < args.length) {
                System.out.print(args[j]);
                int i2 = 0;
                while (i2 < parts + additional.length) {
                    System.out.print("\t");
                    ++i2;
                }
                ++j;
            }
            System.out.println();
        }
        System.out.print("geneID");
        int j = 2;
        while (j < args.length) {
            System.out.print("\t" + args[j]);
            int i3 = 0;
            while (i3 < additional.length) {
                System.out.print("\t" + additional[i3]);
                ++i3;
            }
            ++j;
        }
        System.out.println("\tsample\tsum\tmax\t#alleles\talleles");
        ReferenceBasedComparison.print((String[])genes, num, parts, hash, maxThreshold, sampleThreshold);
    }

    private static String get(String split) {
        int start = split.indexOf(61) + 1;
        int end = split.length();
        if (split.charAt(start) == '\"') {
            ++start;
            --end;
        }
        return split.substring(start, end);
    }

    private static void add(boolean simple, HashMap hash, int index, int max, String id, String chr, String pos, String iAA, String ref, String alt) throws CloneNotSupportedException {
        chr = chr.toUpperCase().substring(0, 5);
        ReferenceBasedComparison.add(simple, hash, ref, index, max, id, chr, pos, iAA);
        if (alt != null) {
            String[] refs;
            String[] stringArray = refs = alt.split(",");
            int n = refs.length;
            int n2 = 0;
            while (n2 < n) {
                String r = stringArray[n2];
                ReferenceBasedComparison.add(simple, hash, r, index, max, id, chr, pos, iAA);
                ++n2;
            }
        }
    }

    private static void add(boolean simple, HashMap hash, String r, int index, int max, String id, String chr, String pos, String iAA) throws CloneNotSupportedException {
        Object stat;
        int idx = r.indexOf("_R");
        if (idx > 0) {
            r = r.substring(0, idx);
        }
        if ((stat = hash.get(r = String.valueOf(chr) + "~" + r)) == null) {
            stat = simple ? (Object)new int[max] : ArrayHandler.createArrayOf(new ArrayList(), (int)max);
            hash.put(r, stat);
        }
        if (simple) {
            int[] nArray = (int[])stat;
            int n = index;
            nArray[n] = nArray[n] + 1;
        } else {
            ((ArrayList[])stat)[index].add(String.valueOf(id) + ":" + pos + ":" + iAA);
        }
    }

    private static <V> void print(String[] genes, int num, int parts, HashMap<String, V> hash, double maxThreshold, double sampleThreshold) {
        int[] myShortStat = null;
        ArrayList[] myLongStat = null;
        StringBuffer o = new StringBuffer();
        HashMap<Double, int[]> iAA = new HashMap<Double, int[]>();
        String[] stringArray = genes;
        int n = genes.length;
        int n2 = 0;
        while (n2 < n) {
            String g = stringArray[n2];
            V stat = hash.get(g);
            if (stat instanceof int[]) {
                myShortStat = (int[])stat;
            } else {
                myLongStat = (ArrayList[])stat;
                iAA.clear();
            }
            o.delete(0, o.length());
            o.append(g);
            double allSum = 0.0;
            double max = 0.0;
            int sample = 0;
            int i = 0;
            while (i < num) {
                int anz;
                if (myShortStat != null) {
                    anz = myShortStat[i];
                    o.append("\t" + myShortStat[i]);
                } else {
                    anz = myLongStat[i].size();
                    String out = myLongStat[i].toString();
                    out = out.substring(1, out.length() - 1);
                    ReferenceBasedComparison.addStats(iAA, out);
                    o.append("\t" + out);
                }
                o.append("\t" + anz);
                allSum += (double)anz;
                if (anz > 0) {
                    ++sample;
                }
                if ((double)anz > max) {
                    max = anz;
                }
                ++i;
            }
            if (max <= maxThreshold && (double)sample >= sampleThreshold) {
                System.out.println(o + "\t" + sample + "\t" + allSum + "\t" + max + "\t" + iAA.size() + "\t" + ReferenceBasedComparison.toString(iAA));
            }
            ++n2;
        }
    }

    static String toString(HashMap<Double, int[]> iAA) {
        StringBuffer sb = new StringBuffer();
        Object[] array = iAA.keySet().toArray(new Double[0]);
        Arrays.sort(array);
        int i = 0;
        while (i < array.length) {
            if (i > 0) {
                sb.append(", ");
            }
            sb.append(array[i] + "=" + iAA.get(array[i])[0]);
            ++i;
        }
        return sb.toString();
    }

    private static void addStats(HashMap<Double, int[]> iAA, String out) {
        if (out.length() > 0) {
            String[] split = out.split(",");
            int i = 0;
            while (i < split.length) {
                String[] info = split[i].split(":");
                double current = Double.parseDouble(info[2]);
                int[] stat = iAA.get(current);
                if (stat == null) {
                    stat = new int[1];
                    iAA.put(current, stat);
                }
                stat[0] = stat[0] + 1;
                ++i;
            }
        }
    }
}

