/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.alphabets;

import de.jstacs.NonParsableException;
import de.jstacs.data.Alphabet;
import de.jstacs.data.alphabets.ComplementableDiscreteAlphabet;
import de.jstacs.data.alphabets.DoubleSymbolException;

public final class DNAAlphabet
extends ComplementableDiscreteAlphabet {
    public DNAAlphabet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public DNAAlphabet(DNAAlphabetParameterSet parameters) throws IllegalArgumentException, DoubleSymbolException {
        this();
        this.parameters = parameters;
    }

    public DNAAlphabet() throws DoubleSymbolException, IllegalArgumentException {
        super(true, DNAAlphabetParameterSet.DNA);
    }

    public int getComplementaryCode(int code) {
        return 3 - code;
    }

    public Alphabet.AlphabetParameterSet getCurrentParameterSet() throws Exception {
        if (this.parameters == null) {
            return new DNAAlphabetParameterSet();
        }
        return this.parameters;
    }

    public static final class DNAAlphabetParameterSet
    extends Alphabet.AlphabetParameterSet {
        private static final String[] DNA = new String[]{"A", "C", "G", "T"};

        public DNAAlphabetParameterSet() throws Exception {
            super(DNAAlphabet.class);
        }

        public DNAAlphabetParameterSet(StringBuffer representation) throws NonParsableException {
            super(representation);
        }

        protected void loadParameters() throws Exception {
            this.initParameterList();
        }

        public String getInstanceComment() {
            return "An alphabet for DNA.";
        }
    }
}

