/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous.shared;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.graphs.tensor.SymmetricTensor;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.modelBased.ModelBasedClassifier;
import de.jstacs.data.Sample;
import de.jstacs.io.XMLParser;
import de.jstacs.models.Model;
import de.jstacs.models.discrete.inhomogeneous.FSDAGModel;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.BayesianNetworkModelParameterSet;
import de.jstacs.results.CategoricalResult;

public class SharedStructureClassifier
extends ModelBasedClassifier {
    private StructureLearner.ModelType model;
    private byte order;
    private StructureLearner.LearningType method;
    private StructureLearner sl;

    public SharedStructureClassifier(int length, StructureLearner.ModelType model, byte order, StructureLearner.LearningType method, FSDAGModel ... models) throws IllegalArgumentException, CloneNotSupportedException, ClassDimensionException {
        super(true, (Model[])models);
        this.model = model;
        if (order < 0) {
            throw new IllegalArgumentException("The value of order has to be non-negative.");
        }
        this.order = order;
        this.method = method;
        this.sl = new StructureLearner(this.getAlphabetContainer(), length);
    }

    public SharedStructureClassifier(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public SharedStructureClassifier clone() throws CloneNotSupportedException {
        SharedStructureClassifier clone = (SharedStructureClassifier)super.clone();
        clone.sl = new StructureLearner(this.getAlphabetContainer(), this.getLength());
        return clone;
    }

    public void train(Sample[] data, double[][] weights) throws IllegalArgumentException, Exception {
        int dimension = this.models.length;
        SymmetricTensor[] parts = new SymmetricTensor[dimension];
        double[] w = new double[dimension];
        for (int i = 0; i < dimension; ++i) {
            this.sl.setESS(((FSDAGModel)this.models[i]).getESS());
            parts[i] = this.sl.getTensor(data[i], weights[i], this.order, this.method);
            w[i] = 1.0;
        }
        FSDAGModel.train(this.models, StructureLearner.getStructure(new SymmetricTensor(parts, w), this.model, this.order), weights, data);
    }

    public String getInstanceName() {
        return "shared-structure classifier";
    }

    protected void extractFurtherClassifierInfosFromXML(StringBuffer xml) throws NonParsableException {
        super.extractFurtherClassifierInfosFromXML(xml);
        this.model = (StructureLearner.ModelType)((Object)XMLParser.extractEnumForTag(xml, "model"));
        this.order = XMLParser.extractByteForTag(xml, "order");
        this.method = (StructureLearner.LearningType)((Object)XMLParser.extractEnumForTag(xml, "method"));
        this.sl = new StructureLearner(this.getAlphabetContainer(), this.getLength());
    }

    protected StringBuffer getFurtherClassifierInfos() {
        StringBuffer xml = super.getFurtherClassifierInfos();
        XMLParser.appendEnumWithTags(xml, this.model, "model");
        XMLParser.appendByteWithTags(xml, this.order, "order");
        XMLParser.appendEnumWithTags(xml, this.method, "method");
        return xml;
    }

    public CategoricalResult[] getClassifierAnnotation() {
        CategoricalResult[] res = new CategoricalResult[this.models.length + 1];
        res[0] = new CategoricalResult("classifier", "a <b>short</b> description of the classifier", this.getInstanceName());
        int i = 0;
        while (i < this.models.length) {
            res[i + 1] = new CategoricalResult("class info " + i, "some information about the class", BayesianNetworkModelParameterSet.getModelInstanceName(this.model, this.order, this.method, ((FSDAGModel)this.models[i++]).getESS()));
        }
        return res;
    }
}

