/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.algorithms.graphs;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Edge
implements Comparable<Edge>,
Cloneable {
    protected int source;
    protected int target;
    protected double weight;

    private Edge(Edge e) {
        this.source = e.source;
        this.target = e.target;
        this.weight = e.weight;
    }

    public Edge(int s, int t, double w) throws IllegalArgumentException {
        if (s < 0 || t < 0) {
            throw new IllegalArgumentException("The nodes have to be integer, that are bigger than or equal to zero.");
        }
        this.source = s;
        this.target = t;
        this.weight = w;
    }

    public int getStartNode() {
        return this.source;
    }

    public int getEndNode() {
        return this.target;
    }

    public double getWeight() {
        return this.weight;
    }

    public String toString() {
        return "(" + this.source + ", " + this.target + "; " + this.weight + ")";
    }

    @Override
    public int compareTo(Edge e) throws ClassCastException {
        if (this.weight < e.weight) {
            return -1;
        }
        if (this.weight == e.weight) {
            return 0;
        }
        return 1;
    }

    public Edge clone() {
        return new Edge(this);
    }
}

