/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier;

import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.classifier.ClassDimensionException;
import de.jstacs.classifier.ConfusionMatrix;
import de.jstacs.classifier.MeasureParameters;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.parameters.ParameterException;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import java.util.LinkedList;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractClassifier
implements Storable,
Cloneable {
    private AlphabetContainer alphabets;
    private int length;

    public static final MeasureParameters getMeasuresForEvaluate() throws ParameterException {
        return new MeasureParameters(false);
    }

    public static final MeasureParameters getMeasuresForEvaluateAll() throws ParameterException {
        return new MeasureParameters(true);
    }

    public AbstractClassifier(AlphabetContainer abc) {
        this(abc, 0);
    }

    public AbstractClassifier(AlphabetContainer abc, int length) throws IllegalArgumentException {
        int l = abc.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("The length and the possible length of the AlphabetContainer does not match.");
        }
        this.alphabets = abc;
        this.length = length;
    }

    public AbstractClassifier(StringBuffer xml) throws NonParsableException {
        this.alphabets = null;
        this.length = -1;
        this.fromXML(xml);
        if (this.length < 0 || this.alphabets == null) {
            throw new NonParsableException("The alphabets or the length were not set.");
        }
    }

    public abstract byte classify(Sequence var1) throws Exception;

    public byte[] classify(Sample s) throws Exception {
        byte[] clazz = new byte[s.getNumberOfElements()];
        Sample.ElementEnumerator ei = new Sample.ElementEnumerator(s);
        for (int i = 0; i < clazz.length; ++i) {
            clazz[i] = this.classify(ei.nextElement());
        }
        return clazz;
    }

    public AbstractClassifier clone() throws CloneNotSupportedException {
        return (AbstractClassifier)super.clone();
    }

    public final NumericalResultSet evaluate(MeasureParameters params, boolean exceptionIfNotComputeable, Sample ... s) throws Exception {
        return new NumericalResultSet(this.getResults(s, params, exceptionIfNotComputeable, false));
    }

    public final ResultSet evaluateAll(MeasureParameters params, boolean exceptionIfNotComputeable, Sample ... s) throws Exception {
        return new ResultSet(this.getResults(s, params, exceptionIfNotComputeable, true));
    }

    protected LinkedList<? extends Result> getResults(Sample[] s, MeasureParameters params, boolean exceptionIfNotComputeable, boolean all) throws Exception {
        LinkedList<NumericalResult> list = new LinkedList<NumericalResult>();
        int numSelected = params.getNumberOfValues();
        if (params.isSelected(MeasureParameters.Measure.ClassificationRate)) {
            list.add(this.getClassificationRate(s));
            --numSelected;
        }
        if (exceptionIfNotComputeable && numSelected > 0) {
            throw new IllegalArgumentException("There are measure that could not be evaluate with this classifier (" + this.getClass() + ")");
        }
        return list;
    }

    protected final NumericalResult getClassificationRate(Sample[] s) throws Exception {
        if (s.length != this.getNumberOfClasses()) {
            throw new ClassDimensionException();
        }
        int correct = 0;
        double n = 0.0;
        for (int i = 0; i < s.length; ++i) {
            if (s == null) continue;
            n += (double)s[i].getNumberOfElements();
            for (int j = 0; j < s[i].getNumberOfElements(); ++j) {
                if (this.classify(s[i].getElementAt(j)) != i) continue;
                ++correct;
            }
        }
        return new NumericalResult(MeasureParameters.Measure.ClassificationRate.getNameString(), MeasureParameters.Measure.ClassificationRate.getCommentString(), (double)correct / n);
    }

    public final AlphabetContainer getAlphabetContainer() {
        return this.alphabets;
    }

    public ResultSet getCharacteristics() throws Exception {
        return new ResultSet(this.getNumericalCharacteristics().getResults(), {new StorableResult("classifer", "the xml representation of the classifier", this)});
    }

    public abstract String getInstanceName();

    public abstract CategoricalResult[] getClassifierAnnotation();

    public final int getLength() {
        return this.length;
    }

    public abstract NumericalResultSet getNumericalCharacteristics() throws Exception;

    public abstract int getNumberOfClasses();

    public abstract boolean isTrained();

    public boolean setNewAlphabetContainerInstance(AlphabetContainer abc) {
        if (abc.checkConsistency(this.alphabets)) {
            this.alphabets = abc;
            return true;
        }
        return false;
    }

    public ConfusionMatrix test(Sample ... testData) throws Exception, ClassDimensionException {
        if (testData.length != this.getNumberOfClasses()) {
            throw new ClassDimensionException();
        }
        ConfusionMatrix matrix = new ConfusionMatrix(testData.length);
        for (int i = 0; i < testData.length; ++i) {
            if (testData[i] == null) continue;
            Sample.ElementEnumerator ei = new Sample.ElementEnumerator(testData[i]);
            while (ei.hasMoreElements()) {
                matrix.add(i, this.classify(ei.nextElement()));
            }
        }
        return matrix;
    }

    public void train(Sample ... s) throws Exception {
        this.train(s, new double[s.length][]);
    }

    public abstract void train(Sample[] var1, double[][] var2) throws Exception;

    protected abstract String getXMLTag();

    private void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, this.getXMLTag());
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "alphabetcontainer");
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.extractFurtherClassifierInfosFromXML(xml);
    }

    protected abstract void extractFurtherClassifierInfosFromXML(StringBuffer var1) throws NonParsableException;

    @Override
    public final StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendStorableWithTags(xml, this.alphabets, "alphabetcontainer");
        XMLParser.appendIntWithTags(xml, this.length, "length");
        xml.append(this.getFurtherClassifierInfos());
        XMLParser.addTags(xml, this.getXMLTag());
        return xml;
    }

    protected abstract StringBuffer getFurtherClassifierInfos();
}

