/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.assessment;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.classifier.assessment.ClassifierAssessmentAssessParameterSet;
import de.jstacs.data.Sample;
import de.jstacs.parameters.EnumParameter;
import de.jstacs.parameters.Parameter;
import de.jstacs.parameters.SimpleParameter;
import de.jstacs.parameters.validation.NumberValidator;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import java.util.ArrayList;
import java.util.Collection;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Sampled_RepeatedHoldOutAssessParameterSet
extends ClassifierAssessmentAssessParameterSet {
    public Sampled_RepeatedHoldOutAssessParameterSet() throws UnsupportedOperationException {
    }

    public Sampled_RepeatedHoldOutAssessParameterSet(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public Sampled_RepeatedHoldOutAssessParameterSet(Sample.PartitionMethod dataSplitMethod, int elementLength, boolean exceptionIfMPNotComputable, int repeats, int referenceClass, double percentage, boolean sameLength) throws SimpleParameter.IllegalValueException {
        super(elementLength, exceptionIfMPNotComputable);
        ((Parameter)this.parameters.get(2)).setValue(repeats);
        ((Parameter)this.parameters.get(3)).setValue(referenceClass);
        ((Parameter)this.parameters.get(4)).setValue(percentage);
        ((Parameter)this.parameters.get(5)).setValue((Object)dataSplitMethod);
        ((Parameter)this.parameters.get(6)).setValue(sameLength);
    }

    @Override
    protected void initializeMyParametersArrayList() {
        this.initParameterList(6);
    }

    @Override
    protected void loadParameters() throws Exception {
        super.loadParameters();
        this.parameters.add(new SimpleParameter(DataType.INT, "repeats", "Determines how often the procedure of train/test classifers using random created train- and test-data should be repeated.", true, new NumberValidator<Integer>(1, Integer.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.INT, "reference class", "the index of the class for which the complete data set is partitioned in an iteration; typically this should be the smallest data set (to meet all constraints)", true, new NumberValidator<Integer>(0, Integer.MAX_VALUE)));
        this.parameters.add(new SimpleParameter(DataType.DOUBLE, "testDataPercentage", "the percentage of of the foreground data set  that is used in each iterations as test-data-set", true, new NumberValidator<Double>(0.0, 1.0)));
        this.parameters.add(new EnumParameter(Sample.PartitionMethod.class, "The method used to compute the percentages of the partitions", true));
        this.parameters.add(new SimpleParameter(DataType.BOOLEAN, "sameLength", "if true then for test respectively train data set the sequences of the non-referenceclasses have the same length as the corresponding sequence of the reference class", true));
    }

    public int getRepeats() {
        return (Integer)this.getParameterAt(2).getValue();
    }

    public int getReferenceClass() {
        return (Integer)this.getParameterAt(3).getValue();
    }

    public double getPercent() {
        return (Double)this.getParameterAt(4).getValue();
    }

    public Sample.PartitionMethod getDataSplitMethod() {
        return (Sample.PartitionMethod)((EnumParameter)this.getParameterAt(5)).getValue();
    }

    public boolean sameLength() {
        return (Boolean)this.getParameterAt(6).getValue();
    }

    @Override
    public Collection<Result> getAnnotation() {
        ArrayList<Result> l = new ArrayList<Result>(3);
        l.add(new NumericalResult("repeats", "The number of iterations", this.getRepeats()));
        l.add(new NumericalResult("reference class", "The index of the class for which the complete data set is partitioned in an iteration", this.getReferenceClass()));
        l.add(new NumericalResult("percentage", "The percentage of the entire data of the reference class, that was used in an assessment", this.getPercent()));
        l.add(new CategoricalResult("dataSplitMethod", "Describes how data should be splitted in ClassifierAssessment.evaluateClassifier())", this.getDataSplitMethod().name()));
        l.add(new CategoricalResult("sameLength", "if true then for test respectively train data set the sequences of the non-referenceclasses have the same length as the corresponding sequence of the reference class", this.sameLength()));
        return l;
    }
}

