/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.logPrior;

import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifier.scoringFunctionBased.logPrior.LogPrior;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.ScoringFunction;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;

public class CompositeLogPrior
extends LogPrior {
    private NormalizableScoringFunction[] function;
    private double fullEss;
    private double logGammaSum;
    private double[] ess;
    private double[] expClass;
    private boolean freeParameters;

    public CompositeLogPrior() {
    }

    public CompositeLogPrior(StringBuffer xml) {
        this();
    }

    public void set(boolean freeParameters, ScoringFunction ... funs) throws Exception {
        this.function = new NormalizableScoringFunction[funs.length];
        this.ess = new double[funs.length];
        this.expClass = new double[funs.length];
        this.fullEss = 0.0;
        this.logGammaSum = 0.0;
        for (int i = 0; i < funs.length; ++i) {
            if (!(funs[i] instanceof NormalizableScoringFunction)) {
                throw new Exception("Only NormalizableScoringFunction allowed.");
            }
            this.function[i] = (NormalizableScoringFunction)funs[i];
            this.ess[i] = this.function[i].getEss();
            if (this.ess[i] == 0.0) {
                throw new IllegalArgumentException("The ess of the function " + i + " is zero, but should be positive.");
            }
            this.fullEss += this.ess[i];
            this.logGammaSum -= Gamma.logOfGamma((double)this.ess[i]);
        }
        this.logGammaSum += Gamma.logOfGamma((double)this.fullEss);
        this.freeParameters = freeParameters;
    }

    public void addGradientFor(double[] params, double[] grad) throws EvaluationException {
        try {
            int k;
            double fullNorm = 0.0;
            double[] norms = new double[this.function.length];
            int start = 0;
            int j = this.function.length - (this.freeParameters ? 1 : 0);
            for (k = 0; k < j; ++k) {
                this.expClass[k] = Math.exp(params[k]);
                norms[k] = this.expClass[k] * this.function[k].getNormalizationConstant();
                fullNorm += norms[k];
            }
            if (this.freeParameters) {
                this.expClass[j] = 1.0;
                norms[j] = this.function[j].getNormalizationConstant();
                fullNorm += norms[j];
            }
            for (start = 0; start < j; ++start) {
                int n = start;
                grad[n] = grad[n] + (this.ess[start] - this.fullEss * norms[start] / fullNorm);
            }
            for (j = 0; j < this.function.length; ++j) {
                this.function[j].addGradientOfLogPriorTerm(grad, start);
                k = this.function[j].getNumberOfParameters();
                for (int l = 0; l < k; ++l) {
                    int n = start++;
                    grad[n] = grad[n] - this.fullEss * this.expClass[j] * this.function[j].getPartialNormalizationConstant(l) / fullNorm;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new EvaluationException(e.getMessage());
        }
    }

    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        try {
            double norm = 0.0;
            double logProductPart = 0.0;
            int j = this.function.length - (this.freeParameters ? 1 : 0);
            for (int i = 0; i < j; ++i) {
                norm += Math.exp(x[i]) * this.function[i].getNormalizationConstant();
                logProductPart += x[i] * this.ess[i] + this.function[i].getLogPriorTerm();
            }
            if (this.freeParameters) {
                norm += 1.0 * this.function[j].getNormalizationConstant();
                logProductPart += this.function[j].getLogPriorTerm();
            }
            return this.logGammaSum - this.fullEss * Math.log(norm) + logProductPart;
        }
        catch (Exception e) {
            e.printStackTrace();
            EvaluationException eva = new EvaluationException(e.getCause().getMessage());
            eva.setStackTrace(e.getStackTrace());
            throw eva;
        }
    }

    public int getDimensionOfScope() {
        int all = this.function.length - (this.freeParameters ? 1 : 0);
        for (int i = 0; i < this.function.length; ++i) {
            int current = this.function[i].getNumberOfParameters();
            if (current == -1) {
                return -1;
            }
            all += current;
        }
        return all;
    }

    public CompositeLogPrior getNewInstance() throws CloneNotSupportedException {
        return new CompositeLogPrior();
    }

    public StringBuffer toXML() {
        return new StringBuffer(1);
    }

    public String getInstanceName() {
        return "Composite log prior";
    }
}

