/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.classifier.scoringFunctionBased.logPrior;

import de.jstacs.NonParsableException;
import de.jstacs.algorithms.optimization.DimensionException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.classifier.scoringFunctionBased.logPrior.SeparateLogPrior;

public class SeparateLaplaceLogPrior
extends SeparateLogPrior {
    private double[] bs;
    private double[] mus;

    public SeparateLaplaceLogPrior(double[] vars, double[] classVars, double[] classMus) {
        super(vars, classVars, classMus);
    }

    public SeparateLaplaceLogPrior(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    protected void unset() {
        this.bs = null;
        this.mus = null;
    }

    private void computeBs() {
        int i;
        int num = this.funs.length - (this.freeParameters ? 1 : 0);
        for (i = 0; i < this.funs.length; ++i) {
            num += this.funs[i].getNumberOfParameters();
        }
        this.bs = new double[num];
        this.mus = new double[num];
        for (num = 0; num < this.funs.length - (this.freeParameters ? 1 : 0); ++num) {
            this.bs[num] = Math.sqrt(this.classVars[num] / 2.0);
            this.mus[num] = this.classMus[num];
        }
        for (i = 0; i < this.funs.length; ++i) {
            for (int j = 0; j < this.funs[i].getNumberOfParameters(); ++j) {
                this.bs[num] = Math.sqrt(this.vars[i] * (double)this.funs[i].getSizeOfEventSpaceForRandomVariablesOfParameter(j) / 2.0);
                this.mus[num] = 0.0;
                ++num;
            }
        }
    }

    public void addGradientFor(double[] params, double[] vector) {
        if (this.bs == null) {
            this.computeBs();
        }
        for (int j = 0; j < params.length; ++j) {
            int n = j;
            vector[n] = vector[n] - Math.signum(params[j] - this.mus[j]) / this.bs[j];
        }
    }

    public double evaluateFunction(double[] x) throws DimensionException, EvaluationException {
        if (this.bs == null) {
            this.computeBs();
        }
        double prior = 0.0;
        for (int i = 0; i < x.length; ++i) {
            prior -= Math.abs(x[i] - this.mus[i]) / this.bs[i];
        }
        return prior;
    }

    public int getDimensionOfScope() {
        if (this.bs == null) {
            return -1;
        }
        return this.bs.length;
    }

    public String getInstanceName() {
        return "Separate Laplace prior";
    }
}

