/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.data.sequences;

import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.SymbolExtractor;

public class ArbitrarySequence
extends Sequence {
    private double[] content;

    public ArbitrarySequence(AlphabetContainer alphabetContainer, double[] content) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, null);
        this.content = new double[content.length];
        for (int i = 0; i < content.length; ++i) {
            if (!alphabetContainer.isEncodedSymbol(i, content[i])) {
                throw new WrongAlphabetException();
            }
            this.content[i] = content[i];
        }
    }

    private ArbitrarySequence(AlphabetContainer cont, SequenceAnnotation[] annotation, double[] content) {
        super(cont, annotation);
        this.content = content;
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, String sequence) throws WrongAlphabetException, WrongSequenceTypeException {
        this(alphabetContainer, null, new SymbolExtractor(sequence, alphabetContainer.getDelim()));
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, String sequence, String delim) throws WrongAlphabetException, WrongSequenceTypeException, IllegalArgumentException {
        this(alphabetContainer, annotation, new SymbolExtractor(sequence, ArbitrarySequence.checkDelim(alphabetContainer, delim)));
    }

    private static String checkDelim(AlphabetContainer alphabetContainer, String delim) throws IllegalArgumentException {
        if (!alphabetContainer.isDiscrete() && delim.length() == 0) {
            throw new IllegalArgumentException("The emtpy delimiter is forbidden for non discrete AlphabetContainers.");
        }
        return delim;
    }

    public ArbitrarySequence(AlphabetContainer alphabetContainer, SequenceAnnotation[] annotation, SymbolExtractor extractor) throws WrongAlphabetException, WrongSequenceTypeException {
        super(alphabetContainer, annotation);
        this.content = new double[extractor.countElements()];
        for (int k = 0; k < this.content.length; ++k) {
            this.content[k] = alphabetContainer.getCode(k, extractor.nextElement());
        }
    }

    public double continuousVal(int pos) {
        return this.content[pos];
    }

    public int discreteVal(int pos) {
        return this.toDiscrete(pos, this.content[pos]);
    }

    public int getLength() {
        return this.content.length;
    }

    protected Sequence flatCloneWithoutAnnotation() {
        try {
            return new ArbitrarySequence(this.alphabetCon, null, this.content);
        }
        catch (Exception doesnothappen) {
            throw new RuntimeException(doesnothappen);
        }
    }
}

