/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.results.NumericalResultSet;
import java.io.IOException;
import java.util.Random;

public class UniformModel
extends AbstractModel {
    private static final long serialVersionUID = 1L;
    private static final String XML_TAG = "DiscreteUniformModel";
    private static final Random r = new Random();

    public UniformModel(AlphabetContainer alphabet) {
        super(alphabet, alphabet.getPossibleLength());
    }

    public UniformModel(StringBuffer stringBuff) throws NonParsableException {
        super(stringBuff);
    }

    public UniformModel clone() throws CloneNotSupportedException {
        return (UniformModel)super.clone();
    }

    public double getProbFor(Sequence sequence, int startpos, int endpos) throws IllegalArgumentException, WrongAlphabetException {
        if (!this.alphabets.checkConsistency(sequence.getAlphabetContainer())) {
            throw new WrongAlphabetException("This sequence and model doesnot match.");
        }
        if (0 > startpos || endpos > sequence.getLength()) {
            throw new IllegalArgumentException("Attention: 0 <= startpos, endpos < sequence.length()");
        }
        if (endpos - startpos + 1 < 0) {
            throw new IllegalArgumentException("The sequence does not have a correct length. The length has to be non-negative.");
        }
        if (this.length > 0) {
            if (endpos - startpos + 1 == this.length) {
                double p = 1.0;
                for (int i = 0; i < this.length; ++i) {
                    p /= this.alphabets.getAlphabetLengthAt(i);
                }
                return p;
            }
            throw new IllegalArgumentException("The sequence does not have a correct length (" + this.length + ").");
        }
        return Math.pow(this.alphabets.getAlphabetLengthAt(0), startpos - 1 - endpos);
    }

    public boolean isTrained() {
        return true;
    }

    public void fromXML(StringBuffer representation) throws NonParsableException {
        this.alphabets = new AlphabetContainer(XMLParser.extractForTag(representation, XML_TAG));
        this.length = this.alphabets.getPossibleLength();
    }

    public StringBuffer toXML() {
        StringBuffer xml = this.alphabets.toXML();
        XMLParser.addTags(xml, XML_TAG);
        return xml;
    }

    public String toString() {
        return "";
    }

    @Deprecated
    public void train(Sample data, double[] weights) throws IOException {
    }

    public Sample emitSample(int n, int ... lengths) throws Exception {
        Sequence[] seq;
        if (this.length == 0) {
            if (lengths.length == 1) {
                seq = this.getSequences(n, lengths[0]);
            } else {
                seq = new Sequence[n];
                for (int i = 0; i < n; ++i) {
                    seq[i] = this.getSequences(1, lengths[i])[0];
                }
            }
        } else {
            if (lengths != null && lengths.length != 0) {
                throw new Exception("This is an inhomogeneous model. Please check parameter lengths.");
            }
            double[] content = new double[this.length];
            seq = new Sequence[n];
            for (int i = 0; i < n; ++i) {
                for (int j = 0; j < this.length; ++j) {
                    content[j] = this.alphabets.getMin(j) + r.nextDouble() * this.alphabets.getAlphabetLengthAt(j);
                    if (!this.alphabets.isDiscreteAt(j)) continue;
                    content[j] = (int)content[j];
                }
                seq[i] = new ArbitrarySequence(this.alphabets, content);
            }
        }
        return new Sample("sampled from " + this.getInstanceName(), seq);
    }

    private Sequence[] getSequences(int n, int length) throws WrongAlphabetException, WrongSequenceTypeException {
        Sequence[] seqs = new Sequence[n];
        if (this.alphabets.isDiscrete()) {
            int[] seq = new int[length];
            int j = 0;
            int l = (int)this.alphabets.getAlphabetLengthAt(0);
            while (j < n) {
                for (int i = 0; i < length; ++i) {
                    seq[i] = r.nextInt(l);
                }
                seqs[j++] = new IntSequence(this.alphabets, seq);
            }
        } else {
            double[] seq = new double[length];
            double m = this.alphabets.getMin(0);
            double l = this.alphabets.getAlphabetLengthAt(0);
            int j = 0;
            while (j < n) {
                for (int i = 0; i < length; ++i) {
                    seq[i] = m + r.nextDouble() * l;
                }
                seqs[j++] = new ArbitrarySequence(this.alphabets, seq);
            }
        }
        return seqs;
    }

    public double getLogPriorTerm() throws Exception {
        return 0.0;
    }

    public byte getMaximalMarkovOrder() throws UnsupportedOperationException {
        return 0;
    }

    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        return null;
    }

    public String getInstanceName() {
        return "uniform";
    }
}

