/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.discrete.inhomogeneous;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.models.discrete.DGMParameterSet;
import de.jstacs.models.discrete.inhomogeneous.DAGModel;
import de.jstacs.models.discrete.inhomogeneous.StructureLearner;
import de.jstacs.models.discrete.inhomogeneous.parameters.BayesianNetworkModelParameterSet;
import java.util.Arrays;

public class BayesianNetworkModel
extends DAGModel {
    private StructureLearner sl;
    private static final String XML_TAG = "BayesianNetworkModel";

    public BayesianNetworkModel(BayesianNetworkModelParameterSet params) throws CloneNotSupportedException, IllegalArgumentException, NonParsableException {
        super(params);
    }

    public BayesianNetworkModel(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public BayesianNetworkModel clone() throws CloneNotSupportedException {
        BayesianNetworkModel clone = (BayesianNetworkModel)super.clone();
        clone.sl = new StructureLearner(this.alphabets, this.length, this.getESS());
        return clone;
    }

    public String getInstanceName() {
        return ((BayesianNetworkModelParameterSet)this.params).getModelInstanceName();
    }

    protected String getXMLTag() {
        return XML_TAG;
    }

    public void train(Sample data, double[] weights) throws Exception {
        this.createConstraints(this.sl.getStructure(data, weights, this.getModel(), this.getMaximalMarkovOrder(), this.getMethod()));
        this.estimateParameters(data, weights);
    }

    public double getLogPriorTerm() throws Exception {
        if (this.getMethod() == StructureLearner.LearningType.BMA) {
            throw new UnsupportedOperationException();
        }
        return super.getLogPriorTerm();
    }

    public byte getMaximalMarkovOrder() {
        return (byte)Math.min(this.length - 1, ((Byte)this.params.getParameterAt(3).getValue()).byteValue());
    }

    private StructureLearner.LearningType getMethod() {
        return (StructureLearner.LearningType)((Object)this.params.getParameterAt(4).getValue());
    }

    private StructureLearner.ModelType getModel() {
        return (StructureLearner.ModelType)((Object)this.params.getParameterAt(2).getValue());
    }

    protected int[] count(int[][] structure, byte maxOrder) {
        int[] counts = new int[maxOrder + 1];
        for (int i = 0; i < this.length; ++i) {
            int j;
            if (i != structure[i][structure[i].length - 1]) {
                throw new IllegalArgumentException("The structure is not correct. Look at the parents of node " + i);
            }
            if (structure[i].length - 1 > maxOrder) {
                throw new IllegalArgumentException("The structure is not correct. There is at least one node (" + i + ") that has to many parents.");
            }
            int n = structure[i].length - 1;
            counts[n] = counts[n] + 1;
            int[] help = (int[])structure[i].clone();
            Arrays.sort(help);
            for (j = 1; j < help.length && help[j - 1] < help[j]; ++j) {
            }
            if (j == help.length) continue;
            throw new IllegalArgumentException("The structure is not correct. Look at the parents of node " + i);
        }
        return counts;
    }

    protected void set(DGMParameterSet parameter, boolean trained) throws CloneNotSupportedException, NonParsableException {
        super.set(parameter, trained);
        this.sl = new StructureLearner(this.alphabets, this.length, this.getESS());
    }
}

