/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.models.mixture;

import de.jstacs.NonParsableException;
import de.jstacs.NotTrainedException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.algorithms.optimization.EvaluationException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.io.XMLParser;
import de.jstacs.models.AbstractModel;
import de.jstacs.models.Model;
import de.jstacs.models.mixture.gibbssampling.BurnInTest;
import de.jstacs.models.mixture.gibbssampling.GibbsSamplingComponent;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.utils.Normalisation;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.random.DirichletMRG;
import de.jstacs.utils.random.DirichletMRGParams;
import de.jstacs.utils.random.FastDirichletMRGParams;
import de.jstacs.utils.random.MRGParams;
import de.jstacs.utils.random.MultivariateRandomGenerator;
import de.jstacs.utils.random.SoftOneOfN;
import de.jtem.numericalMethods.calculus.specialFunctions.Gamma;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;
import javax.naming.OperationNotSupportedException;

public abstract class AbstractMixtureModel
extends AbstractModel {
    private static final int NO_OF_UNSURE_DECIMAL_PLACES = 3;
    protected double[] weights;
    protected double[] logWeights;
    protected double[] componentHyperParams;
    protected Model[] model;
    protected Model[] alternativeModel;
    protected int starts;
    protected int dimension;
    private double best;
    protected SafeOutputStream sostream;
    protected Sample[] sample;
    protected boolean estimateComponentProbs;
    protected boolean[] optimizeModel;
    protected Algorithm algorithm;
    protected boolean algorithmHasBeenRun;
    private Parameterization parametrization;
    private double alpha;
    private double eps;
    protected int initialIteration;
    protected int stationaryIteration;
    protected BurnInTest burnInTest;
    protected BufferedWriter filewriter;
    protected BufferedReader filereader;
    protected File[] file;
    protected int[] counter;
    protected int samplingIndex;
    protected double[] compProb;
    private double[][][] usedWeights;
    private double[][] seqWeights;
    private static final Random r = new Random();

    protected AbstractMixtureModel(int length, Model[] models, boolean[] optimizeModel, int dimension, int starts, boolean estimateComponentProbs, double[] componentHyperParams, double[] weights, Algorithm algorithm, double alpha, double eps, Parameterization parametrization, int initialIteration, int stationaryIteration, BurnInTest burnInTest) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        super(models[0].getAlphabetContainer(), length);
        if (dimension < 1) {
            throw new IllegalArgumentException("The dimension has to be at least 1.");
        }
        this.dimension = dimension;
        this.set((Model[])ArrayHandler.clone((Cloneable[])models), optimizeModel, starts, weights, estimateComponentProbs, componentHyperParams, algorithm, alpha, eps, parametrization, initialIteration, stationaryIteration, burnInTest != null ? burnInTest.clone() : null);
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
        this.algorithmHasBeenRun = false;
    }

    protected AbstractMixtureModel(StringBuffer xml) throws NonParsableException {
        super(xml);
    }

    public AbstractMixtureModel clone() throws CloneNotSupportedException {
        try {
            AbstractMixtureModel clone = (AbstractMixtureModel)super.clone();
            clone.weights = null;
            clone.set((Model[])ArrayHandler.clone((Cloneable[])this.model), this.optimizeModel, this.starts, this.weights, this.estimateComponentProbs, this.componentHyperParams, this.algorithm, this.alpha, this.eps, this.parametrization, this.initialIteration, this.stationaryIteration, this.burnInTest != null ? this.burnInTest.clone() : null);
            if (this.file != null) {
                clone.counter = (int[])this.counter.clone();
                clone.file = new File[this.file.length];
                try {
                    for (int i = 0; i < this.file.length; ++i) {
                        if (this.file[i] == null) continue;
                        clone.file[i] = File.createTempFile("pi-", ".dat", null);
                        FileManager.copy(this.file[i].getAbsolutePath(), clone.file[i].getAbsolutePath());
                    }
                }
                catch (IOException e) {
                    CloneNotSupportedException c = new CloneNotSupportedException(e.getMessage());
                    c.setStackTrace(e.getStackTrace());
                    throw c;
                }
            }
            clone.filereader = null;
            clone.filewriter = null;
            clone.setOutputStream(this.sostream.doesNothing() ? null : SafeOutputStream.DEFAULT_STREAM);
            clone.best = this.best;
            return clone;
        }
        catch (IllegalArgumentException e) {
            throw AbstractMixtureModel.getCloneNotSupportedException(e);
        }
        catch (WrongAlphabetException e) {
            throw AbstractMixtureModel.getCloneNotSupportedException(e);
        }
    }

    private static CloneNotSupportedException getCloneNotSupportedException(Exception e) {
        CloneNotSupportedException ex = new CloneNotSupportedException("impossible Exception in method clone in class AbstractMixtureModel: " + e.getMessage());
        ex.setStackTrace(e.getStackTrace());
        return ex;
    }

    protected MultivariateRandomGenerator getMRG() {
        switch (this.algorithm) {
            case EM: {
                return DirichletMRG.DEFAULT_INSTANCE;
            }
            case GIBBS_SAMPLING: {
                return new SoftOneOfN();
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    protected MRGParams getMRGParams() {
        switch (this.algorithm) {
            case EM: {
                return new FastDirichletMRGParams(this.alpha);
            }
            case GIBBS_SAMPLING: {
                return null;
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public void train(Sample data, double[] dataWeights) throws Exception {
        this.setNewAlphabetContainerInstance(data.getAlphabetContainer());
        this.sample = null;
        System.gc();
        this.setTrainData(data);
        MultivariateRandomGenerator rg = this.getMRG();
        Object[] params = new MRGParams[data.getNumberOfElements()];
        Arrays.fill(params, this.getMRGParams());
        switch (this.algorithm) {
            case EM: {
                int i;
                double max = Double.NEGATIVE_INFINITY;
                double[] p = (double[])this.weights.clone();
                if (this.alternativeModel == null) {
                    this.alternativeModel = (Model[])ArrayHandler.clone((Cloneable[])this.model);
                    for (i = 0; i < this.model.length; ++i) {
                        this.alternativeModel[i].setNewAlphabetContainerInstance(this.alphabets);
                    }
                }
                for (i = 0; i < this.starts; ++i) {
                    double current = this.iterate(i, dataWeights, rg, (MRGParams[])params);
                    if (!(max < current)) continue;
                    this.swap();
                    p = (double[])this.weights.clone();
                    max = current;
                }
                this.swap();
                this.setWeights(p);
                p = null;
                this.best = max;
                this.sostream.writeln("best = " + max);
                break;
            }
            case GIBBS_SAMPLING: {
                boolean finished;
                int i;
                this.burnInTest.resetAllValues();
                this.initModelForSampling(this.starts);
                for (i = 0; i < this.starts; ++i) {
                    double current = this.iterate(i, dataWeights, rg, (MRGParams[])params);
                }
                do {
                    int burnIn = this.burnInTest.getLengthOfBurnIn();
                    int m = 0;
                    int anz = 0;
                    finished = true;
                    for (i = 0; i < this.starts; ++i) {
                        m = this.counter[i] - burnIn;
                        if (m > 0) {
                            anz += m;
                            continue;
                        }
                        finished = false;
                    }
                    if ((anz = (int)Math.ceil((double)(this.stationaryIteration - anz) / (double)this.starts)) <= 0) continue;
                    for (i = 0; i < this.starts; ++i) {
                        this.sostream.writeln("=== extend start: " + i + " ==========");
                        this.continueIterations(dataWeights, this.seqWeights, anz, i);
                    }
                } while (!finished);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of algorithm is unknown.");
            }
        }
        rg = null;
        params = null;
        System.gc();
    }

    protected void swap() {
        Model[] helpM = this.alternativeModel;
        this.alternativeModel = this.model;
        this.model = helpM;
    }

    protected abstract void setTrainData(Sample var1) throws Exception;

    protected double[][] createSeqWeightsArray() {
        return new double[this.model.length][this.sample[0].getNumberOfElements()];
    }

    public double iterate(Sample data, double[] dataWeights, MultivariateRandomGenerator m, MRGParams[] params) throws Exception {
        this.sample = null;
        System.gc();
        this.setTrainData(data);
        return this.iterate(0, dataWeights, m, params);
    }

    protected double iterate(int start, double[] dataWeights, MultivariateRandomGenerator m, MRGParams[] params) throws Exception {
        this.sostream.writeln("========== start: " + start + " ==========");
        switch (this.algorithm) {
            case EM: {
                this.best = this.continueIterations(dataWeights, this.doFirstIteration(dataWeights, m, params));
                break;
            }
            case GIBBS_SAMPLING: {
                this.extendSampling(start);
                this.burnInTest.setCurrentSamplingIndex(start);
                this.seqWeights = this.doFirstIteration(dataWeights, m, params);
                this.samplingStopped();
                this.continueIterations(dataWeights, this.seqWeights, this.initialIteration, start);
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of algorithm is unknown.");
            }
        }
        this.algorithmHasBeenRun = true;
        return this.best;
    }

    protected double[][] doFirstIteration(Sample data, double[] dataWeights) throws Exception {
        Object[] params = new FastDirichletMRGParams[data.getNumberOfElements()];
        Arrays.fill(params, new FastDirichletMRGParams(this.alpha));
        return this.doFirstIteration(data, dataWeights, DirichletMRG.DEFAULT_INSTANCE, (MRGParams[])params);
    }

    protected double[][] doFirstIteration(Sample data, double[] dataWeights, MultivariateRandomGenerator m, MRGParams[] params) throws Exception {
        this.sample = null;
        System.gc();
        this.setTrainData(data);
        return this.doFirstIteration(dataWeights, m, params);
    }

    protected abstract double[][] doFirstIteration(double[] var1, MultivariateRandomGenerator var2, MRGParams[] var3) throws Exception;

    protected double continueIterations(double[] dataWeights, double[][] seqweights) throws Exception {
        if (this.sample == null) {
            throw new OperationNotSupportedException("There is no reference to an internal sample, so you can not go on with training.");
        }
        int i = 0;
        double[] w = new double[this.dimension];
        if (seqweights == null) {
            seqweights = this.createSeqWeightsArray();
        }
        double pr = this.getLogPriorTerm();
        double L_old = Double.NEGATIVE_INFINITY;
        double L_new = this.getNewWeights(dataWeights, w, seqweights);
        this.sostream.write(i + "\t" + L_new + "\t " + pr + "\t");
        this.sostream.writeln((L_new += pr) + "\t" + (L_new - L_old));
        while (L_new - L_old > this.eps) {
            this.getNewParameters(++i, seqweights, w);
            L_old = L_new;
            pr = this.getLogPriorTerm();
            L_new = this.getNewWeights(dataWeights, w, seqweights);
            this.sostream.write(i + "\t" + L_new + "\t " + pr + "\t");
            this.sostream.writeln((L_new += pr) + "\t" + (L_new - L_old));
        }
        if (L_new - L_old < 0.0) {
            int d;
            String s = "" + L_new;
            int n = s.indexOf(".");
            n = n >= 0 ? 17 - n : 17 - s.length();
            if (n - 3 >= (d = L_old >= 1.0 ? -((int)Math.ceil(Math.log(L_old) / Math.log(10.0))) : -((int)Math.floor(Math.log(L_old -= L_new) / Math.log(10.0))))) {
                throw new EvaluationException("The score decreases after " + i + " steps! decimal places = " + n + ", delta = " + -L_old);
            }
            s = "Negative abort after " + i + " steps caused by the limited precision of double.";
            if (this.sostream.doesNothing()) {
                System.out.println(s);
            } else {
                this.sostream.writeln(s);
            }
        }
        return L_new;
    }

    protected void continueIterations(double[] dataWeights, double[][] seqweights, int iterations, int start) throws Exception {
        int j;
        if (this.burnInTest != null) {
            this.extendSampling(start);
            this.burnInTest.setCurrentSamplingIndex(start);
        }
        if (this.sample == null) {
            throw new OperationNotSupportedException("There is no reference to an internal sample, so you can not go on with training.");
        }
        double[] w = new double[this.dimension];
        if (seqweights == null) {
            seqweights = this.createSeqWeightsArray();
        }
        double pr = this.getLogPriorTerm();
        double L_old = Double.NEGATIVE_INFINITY;
        double L_new = this.getNewWeights(dataWeights, w, seqweights);
        int i = 0;
        int n = j = this.burnInTest == null ? 0 : this.counter[this.samplingIndex];
        while (i < iterations) {
            this.sostream.write(j + "\t" + L_new + "\t " + pr + "\t");
            this.sostream.writeln((L_new += pr) + "\t" + (L_new - L_old));
            if (this.burnInTest != null) {
                this.burnInTest.setValue(L_new);
            }
            this.getNewParameters(i, seqweights, w);
            L_old = L_new;
            pr = this.getLogPriorTerm();
            L_new = this.getNewWeights(dataWeights, w, seqweights);
            ++i;
            ++j;
        }
        if (this.burnInTest != null) {
            this.samplingStopped();
        }
    }

    protected void getNewParameters(int iteration, double[][] seqWeights, double[] w) throws Exception {
        for (int i = 0; i < seqWeights.length; ++i) {
            this.getNewParametersForModel(i, iteration, 0, seqWeights[i]);
        }
        this.getNewComponentProbs(w);
    }

    protected void getNewParametersForModel(int modelIndex, int iteration, int sampleIndex, double[] seqWeights) throws Exception {
        if (this.optimizeModel[modelIndex]) {
            switch (this.algorithm) {
                case EM: {
                    if (this.model[modelIndex] instanceof AbstractMixtureModel) {
                        if (iteration == 0) {
                            this.usedWeights[modelIndex] = ((AbstractMixtureModel)this.model[modelIndex]).doFirstIteration(this.sample[sampleIndex], seqWeights);
                            break;
                        }
                        ((AbstractMixtureModel)this.model[modelIndex]).continueIterations(seqWeights, this.usedWeights[modelIndex], 1, 0);
                        break;
                    }
                    this.model[modelIndex].train(this.sample[sampleIndex], seqWeights);
                    break;
                }
                case GIBBS_SAMPLING: {
                    ((GibbsSamplingComponent)((Object)this.model[modelIndex])).drawParameters(this.sample[sampleIndex], seqWeights);
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type of algorithm is unknown.");
                }
            }
        }
    }

    protected abstract double getNewWeights(double[] var1, double[] var2, double[][] var3) throws Exception;

    protected double modifyWeights(double[] w) {
        switch (this.algorithm) {
            case EM: {
                return Normalisation.logSumNormalisation(w, 0, w.length, w, 0);
            }
            case GIBBS_SAMPLING: {
                double l = Normalisation.logSumNormalisation(w, 0, w.length, w, 0);
                int index = AbstractMixtureModel.draw(w, 0);
                Arrays.fill(w, 0.0);
                w[index] = 1.0;
                return l;
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    protected void initWithPrior(double[] w) {
        System.arraycopy(this.componentHyperParams, 0, w, 0, this.dimension);
    }

    public double getLogProbFor(int component, Sequence s) throws Exception {
        switch (this.algorithm) {
            case EM: {
                return this.getLogProbUsingCurrentParameterSetFor(component, s, 0, s.getLength() - 1);
            }
            case GIBBS_SAMPLING: {
                throw new OperationNotSupportedException();
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    protected abstract double getLogProbUsingCurrentParameterSetFor(int var1, Sequence var2, int var3, int var4) throws Exception;

    public double getProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        return Math.exp(this.getLogProbFor(sequence, startpos, endpos));
    }

    public final double getLogProbFor(Sequence sequence, int startpos, int endpos) throws Exception {
        if (!this.isTrained()) {
            throw new NotTrainedException();
        }
        switch (this.algorithm) {
            case EM: {
                for (int i = 0; i < this.dimension; ++i) {
                    this.compProb[i] = this.getLogProbUsingCurrentParameterSetFor(i, sequence, startpos, endpos);
                }
                return Normalisation.getLogSum(this.compProb);
            }
            case GIBBS_SAMPLING: {
                int anz = 0;
                int burnIn = this.burnInTest.getLengthOfBurnIn();
                double res = Double.NEGATIVE_INFINITY;
                for (int sampling = 0; sampling < this.starts; ++sampling) {
                    boolean b = this.parseParameterSet(sampling, burnIn);
                    while (b) {
                        for (int i = 0; i < this.dimension; ++i) {
                            this.compProb[i] = this.getLogProbUsingCurrentParameterSetFor(i, sequence, startpos, endpos);
                        }
                        res = Normalisation.getLogSum(res, Normalisation.getLogSum(this.compProb));
                        b = this.parseNextParameterSet();
                        ++anz;
                    }
                }
                return res - Math.log(anz);
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public final double[] getLogProbFor(Sample data) throws Exception {
        if (!this.isTrained()) {
            throw new NotTrainedException();
        }
        switch (this.algorithm) {
            case EM: {
                return super.getLogProbFor(data);
            }
            case GIBBS_SAMPLING: {
                int k;
                int anz = 0;
                int burnIn = this.burnInTest.getLengthOfBurnIn();
                Sequence[] sequence = data.getAllElements();
                double[] res = new double[sequence.length];
                Arrays.fill(res, Double.NEGATIVE_INFINITY);
                for (int sampling = 0; sampling < this.starts; ++sampling) {
                    boolean b = this.parseParameterSet(sampling, burnIn);
                    while (b) {
                        for (k = 0; k < sequence.length; ++k) {
                            for (int i = 0; i < this.dimension; ++i) {
                                this.compProb[i] = this.getLogProbUsingCurrentParameterSetFor(i, sequence[k], 0, sequence[k].getLength() - 1);
                            }
                            res[k] = Normalisation.getLogSum(res[k], Normalisation.getLogSum(this.compProb));
                        }
                        b = this.parseNextParameterSet();
                        ++anz;
                    }
                }
                double d = Math.log(anz);
                k = 0;
                while (k < sequence.length) {
                    int n = k++;
                    res[n] = res[n] - d;
                }
                return res;
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public double getLogPriorTerm() throws Exception {
        switch (this.algorithm) {
            case GIBBS_SAMPLING: {
                return 0.0;
            }
            case EM: {
                double erg = 0.0;
                for (int counter = 0; counter < this.model.length; ++counter) {
                    if (!this.optimizeModel[counter]) continue;
                    erg += this.model[counter].getLogPriorTerm();
                }
                return erg + this.getLogPriorTermForComponentProbs();
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    protected final double getLogPriorTermForComponentProbs() {
        double prior = 0.0;
        double sum = 0.0;
        if (this.estimateComponentProbs && this.componentHyperParams[0] > 0.0) {
            for (int counter = 0; counter < this.dimension; ++counter) {
                sum += this.componentHyperParams[counter];
                prior += (this.componentHyperParams[counter] + this.parametrization.getCount()) * this.logWeights[counter] - Gamma.logOfGamma((double)this.componentHyperParams[counter]);
            }
            prior += Gamma.logOfGamma((double)sum);
        }
        return prior;
    }

    public final double getScoreForBestRun() throws NotTrainedException, OperationNotSupportedException {
        if (this.algorithmHasBeenRun()) {
            if (this.algorithm == Algorithm.EM) {
                return this.best;
            }
            throw new OperationNotSupportedException();
        }
        throw new NotTrainedException();
    }

    public String getInstanceName() {
        StringBuffer erg = new StringBuffer(this.getClass().getSimpleName() + "(");
        erg.append(this.model[0].getInstanceName());
        for (int i = 1; i < this.model.length; ++i) {
            erg.append(", ");
            erg.append(this.model[i].getInstanceName());
        }
        if (!this.estimateComponentProbs) {
            erg.append("; " + Arrays.toString(this.weights));
        }
        erg.append(") " + this.getNameOfAlgorithm());
        return erg.toString();
    }

    public int getIndexOfMaximalComponentFor(Sequence s) throws Exception {
        switch (this.algorithm) {
            case EM: {
                double best = this.getLogProbFor(0, s);
                int index = 0;
                for (int i = 1; i < this.dimension; ++i) {
                    double current = this.getLogProbFor(i, s);
                    if (!(current > best)) continue;
                    best = current;
                    index = i;
                }
                return index;
            }
            case GIBBS_SAMPLING: {
                throw new OperationNotSupportedException();
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public final Model[] getModels() throws CloneNotSupportedException {
        return (Model[])ArrayHandler.clone((Cloneable[])this.model);
    }

    public final Model getModel(int i) throws CloneNotSupportedException {
        return this.model[i].clone();
    }

    public String getNameOfAlgorithm() {
        switch (this.algorithm) {
            case EM: {
                return "EM";
            }
            case GIBBS_SAMPLING: {
                return "Gibbs Sampling";
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public final int getNumberOfComponents() {
        return this.dimension;
    }

    public ResultSet getCharacteristics() throws Exception {
        LinkedList<Result> infos = new LinkedList<Result>();
        for (int i = 0; i < this.model.length; ++i) {
            ResultSet part = this.model[i].getCharacteristics();
            if (part == null || part.getNumberOfResults() <= 0) continue;
            infos.add(new NumericalResult("model number", "type of model " + this.model[i].getClass().getSimpleName(), new Integer(i)));
            for (int j = 0; j < part.getNumberOfResults(); ++j) {
                infos.add(part.getResultAt(j));
            }
        }
        infos.add(new StorableResult("model", "the xml representation of the model", this));
        return new ResultSet(infos);
    }

    public NumericalResultSet getNumericalCharacteristics() throws Exception {
        LinkedList<NumericalResult> infos = new LinkedList<NumericalResult>();
        for (int i = 0; i < this.model.length; ++i) {
            NumericalResultSet part = this.model[i].getNumericalCharacteristics();
            if (part == null || part.getNumberOfResults() <= 0) continue;
            infos.add(new NumericalResult("model number", "type of model " + this.model[i].getClass().getSimpleName(), new Integer(i)));
            for (int j = 0; j < part.getNumberOfResults(); ++j) {
                infos.add(part.getResultAt(j));
            }
        }
        return new NumericalResultSet(infos);
    }

    public final double[] getWeights() {
        return (double[])this.weights.clone();
    }

    public boolean algorithmHasBeenRun() {
        return this.algorithmHasBeenRun;
    }

    public boolean isTrained() {
        switch (this.algorithm) {
            case EM: {
                int i;
                for (i = 0; i < this.model.length && this.model[i].isTrained(); ++i) {
                }
                return i == this.model.length;
            }
            case GIBBS_SAMPLING: {
                return this.algorithmHasBeenRun;
            }
        }
        throw new IllegalArgumentException("The type of algorithm is unknown.");
    }

    public final void setAlpha(double alpha) throws IllegalArgumentException {
        if (alpha <= 0.0) {
            throw new IllegalArgumentException("alpha has to be strict positive.");
        }
        this.alpha = alpha;
    }

    public final void setOutputStream(OutputStream o) {
        this.sostream = new SafeOutputStream(o);
    }

    public final void setThreshold(double eps) throws IllegalArgumentException {
        if (eps < 0.0) {
            throw new IllegalArgumentException("The threshold eps has to be non-negative.");
        }
        this.eps = eps;
    }

    protected void getNewComponentProbs(double[] weights) throws Exception {
        if (this.estimateComponentProbs) {
            int i;
            double sum = 0.0;
            switch (this.algorithm) {
                case EM: {
                    boolean map;
                    boolean bl = map = this.componentHyperParams[0] != 0.0;
                    for (i = 0; i < this.dimension; ++i) {
                        if (map) {
                            int n = i;
                            weights[n] = weights[n] + this.parametrization.getCount();
                        }
                        sum += weights[i];
                        if (!(weights[i] < 0.0)) continue;
                        throw new IllegalArgumentException("Every weight has to be at least 0. Violate at position " + i + ".");
                    }
                    for (i = 0; i < this.dimension; ++i) {
                        this.weights[i] = weights[i] / sum;
                    }
                    break;
                }
                case GIBBS_SAMPLING: {
                    DirichletMRG.DEFAULT_INSTANCE.generate(this.weights, 0, this.dimension, new DirichletMRGParams(weights));
                    this.filewriter.write(this.counter[this.samplingIndex] + "\t");
                    while (i < this.dimension) {
                        this.filewriter.write(this.weights[i] + "\t");
                        ++i;
                    }
                    this.filewriter.write("\n");
                    this.filewriter.flush();
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type of algorithm is unknown.");
                }
            }
            for (i = 0; i < this.dimension; ++i) {
                this.logWeights[i] = Math.log(this.weights[i]);
            }
        }
        if (this.algorithm == Algorithm.GIBBS_SAMPLING) {
            int n = this.samplingIndex;
            this.counter[n] = this.counter[n] + 1;
        }
    }

    protected void setWeights(double ... weights) throws IllegalArgumentException {
        int i;
        if (weights.length != this.dimension) {
            throw new IllegalArgumentException("The number of weights is incorrect");
        }
        double sum = 0.0;
        for (i = 0; i < this.dimension; ++i) {
            sum += weights[i];
            if (!(weights[i] < 0.0)) continue;
            throw new IllegalArgumentException("Every weight has to be at least 0. Violate at position " + i + ".");
        }
        if (Math.abs(1.0 - sum) > 1.0E-9) {
            throw new IllegalArgumentException("The weights do not sum to 1.");
        }
        if (this.weights == null) {
            this.weights = new double[this.dimension];
            this.logWeights = new double[this.dimension];
        }
        for (i = 0; i < this.dimension; ++i) {
            this.weights[i] = weights[i];
            this.logWeights[i] = Math.log(this.weights[i]);
        }
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(100000);
        XMLParser.appendIntWithTags(xml, this.length, "length");
        XMLParser.appendIntWithTags(xml, this.dimension, "dimension");
        XMLParser.appendIntWithTags(xml, this.starts, "starts");
        XMLParser.appendBooleanWithTags(xml, this.estimateComponentProbs, "estimateComponentProbs");
        XMLParser.appendDoubleArrayWithTags(xml, this.componentHyperParams, "componentHyperParams");
        XMLParser.appendStorableArrayWithTags(xml, this.model, "models");
        XMLParser.appendBooleanArrayWithTags(xml, this.optimizeModel, "optimizeModel");
        XMLParser.appendBooleanWithTags(xml, this.algorithmHasBeenRun, "algorithmHasBeenRun");
        XMLParser.appendDoubleArrayWithTags(xml, this.weights, "weights");
        XMLParser.appendEnumWithTags(xml, this.algorithm, "algorithm");
        switch (this.algorithm) {
            case EM: {
                XMLParser.appendDoubleWithTags(xml, this.alpha, "alpha");
                XMLParser.appendDoubleWithTags(xml, this.eps, "epsilon");
                XMLParser.appendEnumWithTags(xml, this.parametrization, "parametrization");
                break;
            }
            case GIBBS_SAMPLING: {
                XMLParser.appendIntWithTags(xml, this.initialIteration, "initialIteration");
                XMLParser.appendIntWithTags(xml, this.stationaryIteration, "stationaryIteration");
                XMLParser.appendStorableWithTags(xml, this.burnInTest, "burnInTest");
                XMLParser.appendBooleanWithTags(xml, this.file != null, "hasParameterFiles");
                if (this.file == null) break;
                XMLParser.appendIntArrayWithTags(xml, this.counter, "counter");
                try {
                    for (int i = 0; i < this.counter.length; ++i) {
                        String content = this.file[i] != null ? FileManager.readFile(this.file[i]).toString() : "";
                        XMLParser.appendStringWithTags(xml, content, "fileContent pos=\"" + i + "\"", "fileContent");
                    }
                    break;
                }
                catch (IOException e) {
                    RuntimeException r = new RuntimeException(e.getMessage());
                    r.setStackTrace(e.getStackTrace());
                    throw r;
                }
            }
        }
        XMLParser.appendDoubleWithTags(xml, this.best, "best");
        xml.append(this.getFurtherInformation());
        XMLParser.addTags(xml, this.getClass().getSimpleName());
        return xml;
    }

    protected StringBuffer getFurtherInformation() {
        return new StringBuffer(1);
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(representation, this.getClass().getSimpleName());
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.dimension = XMLParser.extractIntForTag(xml, "dimension");
        this.starts = XMLParser.extractIntForTag(xml, "starts");
        this.estimateComponentProbs = XMLParser.extractBooleanForTag(xml, "estimateComponentProbs");
        this.componentHyperParams = XMLParser.extractDoubleArrayForTag(xml, "componentHyperParams");
        this.model = ArrayHandler.cast(Model.class, XMLParser.extractStorableArrayForTag(xml, "models"));
        this.optimizeModel = XMLParser.extractBooleanArrayForTag(xml, "optimizeModel");
        this.algorithmHasBeenRun = XMLParser.extractBooleanForTag(xml, "algorithmHasBeenRun");
        double[] w = XMLParser.extractDoubleArrayForTag(xml, "weights");
        this.algorithm = (Algorithm)((Object)XMLParser.extractEnumForTag(xml, "algorithm"));
        try {
            switch (this.algorithm) {
                case EM: {
                    this.parametrization = (Parameterization)((Object)XMLParser.extractEnumForTag(xml, "parametrization"));
                    this.set(this.model, this.optimizeModel, this.starts, w, this.estimateComponentProbs, this.componentHyperParams, this.algorithm, XMLParser.extractDoubleForTag(xml, "alpha"), XMLParser.extractDoubleForTag(xml, "epsilon"), this.parametrization, 0, 0, null);
                    break;
                }
                case GIBBS_SAMPLING: {
                    this.set(this.model, this.optimizeModel, this.starts, w, this.estimateComponentProbs, this.componentHyperParams, this.algorithm, 0.0, 0.0, Parameterization.LAMBDA, XMLParser.extractIntForTag(xml, "initialIteration"), XMLParser.extractIntForTag(xml, "stationaryIteration"), (BurnInTest)XMLParser.extractStorableForTag(xml, "burnInTest"));
                    if (XMLParser.extractBooleanForTag(xml, "hasParameterFiles")) {
                        this.counter = XMLParser.extractIntArrayForTag(xml, "counter");
                        this.file = new File[this.counter.length];
                        try {
                            for (int i = 0; i < this.counter.length; ++i) {
                                String content = XMLParser.extractStringForTag(xml, "fileContent pos=\"" + i + "\"", "fileContent");
                                if (content.equalsIgnoreCase("")) continue;
                                this.file[i] = File.createTempFile("pi-", ".dat", null);
                                FileManager.writeFile(this.file[i], new StringBuffer(content));
                            }
                            break;
                        }
                        catch (IOException e) {
                            NonParsableException r = new NonParsableException(e.getMessage());
                            r.setStackTrace(e.getStackTrace());
                            throw r;
                        }
                    }
                    this.file = null;
                    break;
                }
                default: {
                    throw new IllegalArgumentException("The type of algorithm is unknown.");
                }
            }
        }
        catch (Exception e) {
            NonParsableException n = new NonParsableException(e.getMessage());
            n.setStackTrace(e.getStackTrace());
            throw n;
        }
        this.best = XMLParser.extractDoubleForTag(xml, "best");
        this.alphabets = this.model[0].getAlphabetContainer();
        this.setOutputStream(SafeOutputStream.DEFAULT_STREAM);
        this.extractFurtherInformation(xml);
    }

    protected void extractFurtherInformation(StringBuffer xml) throws NonParsableException {
    }

    protected void set(AlphabetContainer abc) {
        for (int i = 0; i < this.model.length; ++i) {
            this.model[i].setNewAlphabetContainerInstance(abc);
        }
    }

    private void set(Model[] model, boolean[] optimizeModel, int starts, double[] weights, boolean estimateComponentProbs, double[] componentHyperParams, Algorithm algorithm, double alpha, double eps, Parameterization parametrization, int initialIteration, int stationaryIteration, BurnInTest burnInTest) throws IllegalArgumentException, WrongAlphabetException {
        boolean minValueOfUsedHyperParamIsZero;
        int i;
        if (starts < 1) {
            throw new IllegalArgumentException("The number of iterations has to be at least 1.");
        }
        this.starts = starts;
        AlphabetContainer abc = model[0].getAlphabetContainer();
        for (i = 0; i < model.length; ++i) {
            if (i != 0 && !model[i].setNewAlphabetContainerInstance(abc)) {
                throw new WrongAlphabetException("The models have to have the same alphabet like the AbstractMixtureModel. Violated at position " + i + ".");
            }
            if (model[i] instanceof AbstractMixtureModel) {
                ((AbstractMixtureModel)model[i]).setOutputStream(null);
            }
            this.checkLength(i, model[i].getLength());
        }
        if (optimizeModel == null) {
            this.optimizeModel = new boolean[model.length];
            Arrays.fill(this.optimizeModel, true);
        } else {
            if (optimizeModel.length != model.length) {
                throw new IllegalArgumentException("The dimension of the switch whether the individual models should be optimized/adjusted has wrong dimension.");
            }
            this.optimizeModel = new boolean[model.length];
            System.arraycopy(optimizeModel, 0, this.optimizeModel, 0, optimizeModel.length);
        }
        if (weights == null) {
            weights = new double[this.dimension];
            Arrays.fill(weights, 1.0 / (double)this.dimension);
        }
        this.setWeights(weights);
        this.model = model;
        this.alternativeModel = null;
        this.estimateComponentProbs = estimateComponentProbs;
        if (!estimateComponentProbs || componentHyperParams == null) {
            this.componentHyperParams = new double[this.dimension];
            minValueOfUsedHyperParamIsZero = estimateComponentProbs;
        } else {
            if (componentHyperParams.length != this.dimension) {
                throw new IllegalArgumentException("The dimension of the component assignment hyperparameter is not correct.");
            }
            this.componentHyperParams = new double[this.dimension];
            minValueOfUsedHyperParamIsZero = componentHyperParams[0] == 0.0;
            for (i = 0; i < this.dimension; ++i) {
                if (componentHyperParams[i] < 0.0 || minValueOfUsedHyperParamIsZero && componentHyperParams[i] > 0.0 || !minValueOfUsedHyperParamIsZero && componentHyperParams[i] == 0.0) {
                    throw new IllegalArgumentException("The " + i + "-th component assignment hyperparameter is not correct.");
                }
                this.componentHyperParams[i] = componentHyperParams[i];
            }
        }
        this.best = Double.NEGATIVE_INFINITY;
        this.compProb = new double[this.dimension];
        this.usedWeights = new double[model.length][][];
        switch (algorithm) {
            case EM: {
                if (parametrization != Parameterization.THETA && parametrization != Parameterization.LAMBDA) {
                    throw new IllegalArgumentException("The type of parametrization is unknown.");
                }
                this.parametrization = parametrization;
                this.setAlpha(alpha);
                this.setThreshold(eps);
                break;
            }
            case GIBBS_SAMPLING: {
                if (minValueOfUsedHyperParamIsZero) {
                    throw new IllegalArgumentException("The component hyper parameters have to be set to positive values.");
                }
                if (initialIteration <= 0) {
                    throw new IllegalArgumentException("The given number of intial iterations has to be at least 1.");
                }
                if (initialIteration * starts > stationaryIteration) {
                    throw new IllegalArgumentException("The given number of intial iterations has to be most (stationaryIteration/starts).");
                }
                if (stationaryIteration <= 0) {
                    throw new IllegalArgumentException("The given number of iterations has to be at least 1.");
                }
                if (burnInTest == null) {
                    throw new IllegalArgumentException("You have to specify a burn in test.");
                }
                this.initialIteration = initialIteration;
                this.stationaryIteration = stationaryIteration;
                this.burnInTest = burnInTest;
                this.checkModelsForGibbsSampling();
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of algorithm is unknown.");
            }
        }
        this.algorithm = algorithm;
    }

    protected void checkModelsForGibbsSampling() {
        for (int i = 0; i < this.model.length; ++i) {
            if (!this.optimizeModel[i] || this.model[i] instanceof GibbsSamplingComponent) continue;
            throw new IllegalArgumentException("The model for component " + i + " doesn't implement the interface GibbsSamplingComponent!");
        }
    }

    protected void checkLength(int index, int l) {
        if (l != 0 && this.length != l) {
            throw new IllegalArgumentException("The models have to use the same length like the AbstractMixtureModel. Violated at position " + index + ".");
        }
    }

    public Sample emitSample(int n, int ... lengths) throws Exception {
        Sequence[] seqs;
        if (!this.isTrained()) {
            throw new NotTrainedException();
        }
        switch (this.algorithm) {
            case EM: {
                seqs = this.emitSampleUsingCurrentParameterSet(n, lengths);
                break;
            }
            case GIBBS_SAMPLING: {
                int i;
                int[] anz = new int[this.starts];
                int all = 0;
                int burnIn = this.burnInTest.getLengthOfBurnIn();
                for (i = 0; i < this.starts; ++i) {
                    all = anz[i] = all + Math.max(0, this.counter[i] - burnIn);
                }
                int[] no = new int[all];
                for (i = 0; i < n; ++i) {
                    int n2 = r.nextInt(all);
                    no[n2] = no[n2] + 1;
                }
                seqs = new Sequence[n];
                all = 0;
                int j = 0;
                for (i = 0; i < this.starts; ++i) {
                    this.parseParameterSet(i, burnIn);
                    while (all < anz[i]) {
                        if (no[all] > 0) {
                            int[] len;
                            if (lengths == null || lengths.length <= 1) {
                                len = lengths;
                            } else {
                                len = new int[no[all]];
                                System.arraycopy(lengths, j, len, 0, no[all]);
                            }
                            Sequence[] help = this.emitSampleUsingCurrentParameterSet(no[all], len);
                            int k = 0;
                            while (k < no[all]) {
                                seqs[j] = help[k];
                                ++k;
                                ++j;
                            }
                        }
                        this.parseNextParameterSet();
                        ++all;
                    }
                }
                break;
            }
            default: {
                throw new IllegalArgumentException("The type of algorithm is unknown.");
            }
        }
        return new Sample("sampled from " + this.getInstanceName(), seqs);
    }

    protected abstract Sequence[] emitSampleUsingCurrentParameterSet(int var1, int ... var2) throws Exception;

    protected boolean parseParameterSet(int sampling, int burnInIteration) throws Exception {
        boolean parsed = true;
        for (int i = 0; i < this.model.length; ++i) {
            if (!this.optimizeModel[i]) continue;
            parsed &= ((GibbsSamplingComponent)((Object)this.model[i])).parseParameterSet(sampling, burnInIteration);
        }
        return parsed &= this.parseComponentParameterSet(sampling, burnInIteration);
    }

    private boolean parseComponentParameterSet(int sampling, int burnInIteration) throws IOException {
        String str;
        if (this.filereader != null) {
            this.filereader.close();
        }
        this.filereader = new BufferedReader(new FileReader(this.file[sampling]));
        while ((str = this.filereader.readLine()) != null) {
            if (Integer.parseInt(str.substring(0, str.indexOf("\t"))) != burnInIteration) continue;
            this.parse(str);
            return true;
        }
        return false;
    }

    private void parse(String str) {
        String[] strarray = str.split("\t");
        int l = 1;
        for (int i = 0; i < this.model.length; ++i) {
            this.weights[i] = Double.parseDouble(strarray[l++]);
            this.logWeights[i] = Math.log(this.weights[i]);
        }
    }

    protected boolean parseNextParameterSet() throws Exception {
        String str = this.filereader.readLine();
        if (str == null) {
            return false;
        }
        this.parse(str);
        boolean parsed = true;
        for (int i = 0; i < this.model.length && parsed; ++i) {
            if (!this.optimizeModel[i]) continue;
            parsed &= ((GibbsSamplingComponent)((Object)this.model[i])).parseNextParameterSet();
        }
        return parsed;
    }

    protected void initModelForSampling(int starts) throws IOException {
        if (this.file != null && this.file.length == starts) {
            for (int i = 0; i < starts; ++i) {
                if (this.file[i] != null) {
                    FileOutputStream o = new FileOutputStream(this.file[i]);
                    o.close();
                }
                this.counter[i] = 0;
            }
        } else {
            this.deleteParameterFiles();
            this.file = new File[starts];
            this.counter = new int[starts];
        }
        for (int i = 0; i < this.model.length; ++i) {
            if (!this.optimizeModel[i]) continue;
            ((GibbsSamplingComponent)((Object)this.model[i])).initModelForSampling(starts);
        }
    }

    protected void extendSampling(int sampling) throws Exception {
        if (this.file[sampling] == null) {
            this.file[sampling] = File.createTempFile("pi-", ".dat", null);
        } else {
            this.parseComponentParameterSet(sampling, this.counter[sampling] - 1);
            this.filereader.close();
            this.filereader = null;
        }
        this.filewriter = new BufferedWriter(new FileWriter(this.file[sampling], true));
        for (int i = 0; i < this.model.length; ++i) {
            if (!this.optimizeModel[i]) continue;
            ((GibbsSamplingComponent)((Object)this.model[i])).extendSampling(sampling, true);
        }
        this.samplingIndex = sampling;
    }

    protected void samplingStopped() throws IOException {
        for (int i = 0; i < this.model.length; ++i) {
            if (!this.optimizeModel[i]) continue;
            ((GibbsSamplingComponent)((Object)this.model[i])).samplingStopped();
        }
        this.filewriter.close();
        this.filewriter = null;
    }

    protected boolean isInSamplingMode() {
        int i;
        for (i = 0; i < this.model.length && (!this.optimizeModel[i] || ((GibbsSamplingComponent)((Object)this.model[i])).isInSamplingMode()); ++i) {
        }
        return i == this.model.length && this.filewriter != null;
    }

    protected void finalize() throws Throwable {
        this.alternativeModel = null;
        this.model = null;
        this.compProb = null;
        this.componentHyperParams = null;
        this.logWeights = null;
        this.weights = null;
        this.sample = null;
        this.counter = null;
        this.optimizeModel = null;
        this.usedWeights = null;
        if (this.filereader != null) {
            this.filereader.close();
        }
        if (this.filewriter != null) {
            this.filewriter.close();
        }
        this.deleteParameterFiles();
        super.finalize();
    }

    private void deleteParameterFiles() {
        if (this.file != null) {
            for (int i = 0; i < this.file.length; ++i) {
                if (this.file[i] == null) continue;
                this.file[i].delete();
            }
        }
    }

    public static final int draw(double[] w, int start) {
        int i = start;
        for (double p = r.nextDouble(); i < w.length && p > w[i]; p -= w[i++]) {
        }
        if (i == w.length) {
            --i;
        }
        return i;
    }

    public static final int max(double[] w, int start, int end) {
        int max = start;
        for (int i = start + 1; i < end; ++i) {
            if (!(w[i] > w[max])) continue;
            max = i;
        }
        return max;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Algorithm {
        EM,
        GIBBS_SAMPLING;

    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum Parameterization {
        THETA(-1.0),
        LAMBDA(0.0);

        private double count;

        private Parameterization(double count) {
            this.count = count;
        }

        double getCount() {
            return this.count;
        }
    }
}

