/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.results.MeanResultSet;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.ComparableElement;
import java.io.PrintWriter;
import java.io.StringWriter;
import java.util.Arrays;

public class ListResult
extends Result {
    protected ResultSet[] list;
    private ResultSet annotation;

    public ListResult(String name, String comment, ResultSet annotation, ResultSet ... results) {
        super(name, comment, DataType.LIST);
        this.list = new ResultSet[results.length];
        System.arraycopy(results, 0, this.list, 0, results.length);
        this.annotation = annotation;
    }

    public ListResult(StringBuffer representation) throws NonParsableException {
        super(representation);
    }

    public ResultSet[] getResult() {
        ResultSet[] resultsToShow = new ResultSet[this.list.length];
        for (int i = 0; i < this.list.length; ++i) {
            if (this.list[i] instanceof MeanResultSet) {
                int k;
                ResultSet infos = ((MeanResultSet)this.list[i]).getInfos();
                NumericalResultSet statistics = ((MeanResultSet)this.list[i]).getStatistics();
                Result[] all = new Result[infos.getNumberOfResults() + statistics.getNumberOfResults()];
                for (k = 0; k < infos.getNumberOfResults(); ++k) {
                    all[k] = infos.getResultAt(k);
                }
                for (k = 0; k < statistics.getNumberOfResults(); ++k) {
                    all[k + infos.getNumberOfResults()] = statistics.getResultAt(k);
                }
                resultsToShow[i] = new ResultSet(new Result[][]{all});
                continue;
            }
            resultsToShow[i] = this.list[i];
        }
        return resultsToShow;
    }

    public ResultSet[] getRawResult() {
        ResultSet[] res = new ResultSet[this.list.length];
        System.arraycopy(this.list, 0, res, 0, res.length);
        return res;
    }

    public ResultSet getAnnotation() {
        return this.annotation;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        this.appendMainInfo(buf);
        if (this.annotation != null) {
            XMLParser.appendStorableWithTags(buf, this.annotation, "annotation");
        }
        XMLParser.appendStorableArrayWithTags(buf, this.list, "list");
        XMLParser.addTags(buf, "listResult");
        return buf;
    }

    protected void fromXML(StringBuffer representation) throws NonParsableException {
        representation = XMLParser.extractForTag(representation, "listResult");
        this.extractMainInfo(representation);
        try {
            this.annotation = (ResultSet)XMLParser.extractStorableForTag(representation, "annotation");
        }
        catch (NonParsableException e) {
            this.annotation = null;
        }
        this.list = ArrayHandler.cast(ResultSet.class, XMLParser.extractStorableArrayForTag(representation, "list"));
    }

    public String toString() {
        StringWriter s = new StringWriter();
        PrintWriter writer = new PrintWriter(s);
        this.print(writer);
        return s.toString();
    }

    public void print(PrintWriter writer) {
        if (this.annotation != null) {
            for (int i = 0; i < this.annotation.getNumberOfResults(); ++i) {
                Result r = this.annotation.getResultAt(i);
                DataType d = r.getDatatype();
                if (d == DataType.PNG || d == DataType.HTML || d == DataType.LIST || d == DataType.STORABLE) continue;
                if (r.getName().equals("kind of assessment")) {
                    writer.println("#");
                }
                writer.print("# ");
                writer.print(r.getName());
                writer.print(": ");
                writer.println(r.getResult().toString());
            }
        }
        if (this.list != null) {
            writer.println("# ");
            ResultSet[] res = this.getResult();
            for (int i = 0; i < res.length; ++i) {
                int j;
                boolean newNames = i == 0;
                int k = res[i].getNumberOfResults() - 1;
                if (!newNames) {
                    if (k + 1 != res[i - 1].getNumberOfResults()) {
                        newNames = true;
                    } else {
                        for (j = 0; j <= k; ++j) {
                            if (res[i].getResultAt(j).getName().equals(res[i - 1].getResultAt(j).getName())) continue;
                            newNames = true;
                            break;
                        }
                    }
                }
                if (newNames) {
                    writer.print("# ");
                    for (j = 0; j <= k; ++j) {
                        writer.print(res[i].getResultAt(j).getName());
                        if (j < k) {
                            writer.print("\t");
                            continue;
                        }
                        writer.println();
                    }
                }
                for (j = 0; j <= k; ++j) {
                    writer.print(res[i].getResultAt(j).getResult());
                    if (j < k) {
                        writer.print("\t");
                        continue;
                    }
                    writer.println();
                }
            }
            writer.flush();
        }
    }

    public ListResult sort(String columnName) throws IllegalArgumentException {
        int i;
        Object[] c = new ComparableElement[this.list.length];
        Comparable comp = null;
        for (i = 0; i < this.list.length; ++i) {
            int k = this.list[i].findColumn(columnName);
            if (k < 0) {
                ResultSet r;
                if (this.list[i] instanceof MeanResultSet && (k = (r = ((MeanResultSet)this.list[i]).getInfos()).findColumn(columnName)) >= 0) {
                    comp = (Comparable)r.getResultAt(k).getResult();
                }
                if (k < 0) {
                    throw new IllegalArgumentException("Could not find such a column.");
                }
            } else {
                comp = (Comparable)this.list[i].getResultAt(k).getResult();
            }
            c[i] = new ComparableElement<ResultSet, Comparable>(this.list[i], comp);
        }
        Arrays.sort(c);
        ResultSet[] results = new ResultSet[this.list.length];
        for (i = 0; i < this.list.length; ++i) {
            results[i] = (ResultSet)((ComparableElement)c[i]).getElement();
        }
        return new ListResult(this.name, this.comment, this.annotation, results);
    }
}

