/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.results;

import de.jstacs.DataType;
import de.jstacs.NonParsableException;
import de.jstacs.Storable;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.StringExtractor;
import de.jstacs.io.XMLParser;
import de.jstacs.results.Result;

public class SampleResult
extends Result {
    private Sample data;

    public SampleResult(String name, String comment, Sample data) {
        super(name, comment, DataType.SAMPLE);
        this.data = data;
    }

    public SampleResult(StringBuffer source) throws NonParsableException {
        super(source);
    }

    protected void fromXML(StringBuffer rep) throws NonParsableException {
        rep = XMLParser.extractForTag(rep, "sampleResult");
        AlphabetContainer cont = (AlphabetContainer)XMLParser.extractStorableForTag(rep, "alphabet");
        String sampleAnn = XMLParser.extractStringForTag(rep, "sampleAnnotation");
        String seqs = XMLParser.extractStringForTag(rep, "data");
        StringExtractor ex = new StringExtractor(seqs, 100, "");
        try {
            Sample data = new Sample(cont, ex);
            Sequence[] seq = data.getAllElements();
            Storable[][] annotation = XMLParser.extractStorable2ArrayForTag(rep, "annotation");
            for (int i = 0; i < seq.length; ++i) {
                if (annotation[i].length <= 0) continue;
                seq[i] = seq[i].annotate(false, ArrayHandler.cast(SequenceAnnotation.class, annotation[i]));
            }
            this.data = new Sample(sampleAnn, seq);
        }
        catch (Exception e) {
            NonParsableException np = new NonParsableException(e.getCause().getMessage());
            np.setStackTrace(e.getStackTrace());
            throw np;
        }
    }

    public Sample getResult() {
        return this.data;
    }

    public StringBuffer toXML() {
        StringBuffer buf = new StringBuffer();
        AlphabetContainer cont = this.data.getAlphabetContainer();
        XMLParser.appendStorableWithTags(buf, cont, "alphabet");
        StringBuffer seqs = new StringBuffer();
        Storable[][] annotation = new Storable[this.data.getNumberOfElements()][];
        Sample.ElementEnumerator it = new Sample.ElementEnumerator(this.data);
        int i = 0;
        while (it.hasMoreElements()) {
            Sequence seq = it.nextElement();
            buf.append(seq.toString());
            buf.append("\n");
            SequenceAnnotation[] ann = seq.getAnnotation();
            annotation[i] = ann == null ? new Storable[0] : ann;
            ++i;
        }
        XMLParser.appendStringWithTags(buf, this.data.getAnnotation(), "sampleAnnotation");
        XMLParser.appendStringWithTags(buf, seqs.toString(), "data");
        XMLParser.appendStorable2ArrayWithTags(buf, annotation, "annotation");
        XMLParser.addTags(buf, "sampleResult");
        return buf;
    }
}

