/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.WrongAlphabetException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.data.sequences.annotation.StrandedLocatedSequenceAnnotationWithLength;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.XMLParser;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.scoringFunctions.NormalizableScoringFunction;
import de.jstacs.scoringFunctions.VariableLengthScoringFunction;
import de.jstacs.scoringFunctions.mix.AbstractMixtureScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;

public class IndependentProductScoringFunction
extends AbstractNormalizableScoringFunction
implements MutableMotifDiscoverer {
    private NormalizableScoringFunction[] score;
    private int[] index;
    private int[] start;
    private int[] partialLength;
    private int[] params;
    private int[] motifs;
    private int[] componentsUntilNow;
    private int[] motifIndexArray;
    private int[] components;
    private int[] componentIndexArray;
    private boolean[] reverse;
    private boolean[] isVariable;
    private double ess;
    private IntList partIList;
    private boolean plugIn;
    private HashSet<Integer> hash;

    private static final AlphabetContainer getAlphabetContainer(NormalizableScoringFunction[] functions, int[] index, int[] length, boolean[] reverse) throws IllegalArgumentException, WrongAlphabetException {
        boolean direct = index == null;
        int len = direct ? functions.length : index.length;
        AlphabetContainer[] cons = new AlphabetContainer[len];
        int[] lengths = new int[len];
        for (int i = 0; i < len; ++i) {
            int j = direct ? i : index[i];
            cons[i] = functions[j].getAlphabetContainer();
            lengths[i] = length[i];
            if (reverse == null || !reverse[i] || cons[i].isReverseComplementable()) continue;
            throw new WrongAlphabetException("The AlpabetContainer is not reverse complementable.");
        }
        return new AlphabetContainer(cons, lengths);
    }

    private static final int sum(int[] length) throws IllegalArgumentException {
        int res = 0;
        int i = 0;
        while (i < length.length && length[i] > 0) {
            res += length[i++];
        }
        if (i != length.length) {
            throw new IllegalArgumentException("The length with index " + i + " is 0.");
        }
        return res;
    }

    private static final int[] getLengthArray(NormalizableScoringFunction ... functions) throws IllegalArgumentException {
        int i;
        int[] res = new int[functions.length];
        for (i = 0; i < functions.length && functions[i].getLength() > 0; ++i) {
            res[i] = functions[i].getLength();
        }
        if (i != functions.length) {
            throw new IllegalArgumentException("The NormalizableScoringFunction with index " + i + " has a length 0.");
        }
        return res;
    }

    public IndependentProductScoringFunction(double ess, boolean plugIn, NormalizableScoringFunction ... functions) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        this(ess, plugIn, functions, IndependentProductScoringFunction.getLengthArray(functions));
    }

    public IndependentProductScoringFunction(double ess, boolean plugIn, NormalizableScoringFunction[] functions, int[] length) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        this(ess, plugIn, functions, null, length, null);
    }

    public IndependentProductScoringFunction(double ess, boolean plugIn, NormalizableScoringFunction[] functions, int[] index, int[] length, boolean[] reverse) throws CloneNotSupportedException, IllegalArgumentException, WrongAlphabetException {
        super(IndependentProductScoringFunction.getAlphabetContainer(functions, index, length, reverse), IndependentProductScoringFunction.sum(length));
        if (ess < 0.0) {
            throw new IllegalArgumentException("The equivalent sample size (ess) has to be non-negative.");
        }
        this.ess = ess;
        this.plugIn = plugIn;
        this.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])functions);
        this.set(index, length, reverse);
        this.setParamsStarts();
        this.prepare();
    }

    private void prepare() {
        int i;
        this.motifs = new int[this.score.length + 1];
        this.components = new int[this.score.length];
        for (i = 0; i < this.score.length; ++i) {
            this.motifs[i + 1] = this.motifs[i];
            if (this.score[i] instanceof MotifDiscoverer) {
                int n = i + 1;
                this.motifs[n] = this.motifs[n] + ((MotifDiscoverer)((Object)this.score[i])).getNumberOfMotifs();
            }
            this.components[i] = this.score[i] instanceof AbstractMixtureScoringFunction ? ((AbstractMixtureScoringFunction)this.score[i]).getNumberOfComponents() : (this.score[i] instanceof MotifDiscoverer ? ((MotifDiscoverer)((Object)this.score[i])).getNumberOfComponents() : 1);
        }
        this.componentsUntilNow = new int[this.index.length + 1];
        this.componentsUntilNow[0] = 1;
        for (i = 0; i < this.index.length; ++i) {
            this.componentsUntilNow[i + 1] = this.componentsUntilNow[i] * this.components[this.index[i]];
        }
        this.motifIndexArray = new int[3];
        this.componentIndexArray = new int[this.index.length];
    }

    public IndependentProductScoringFunction(StringBuffer source) throws NonParsableException {
        super(source);
    }

    private void set(int[] index, int[] length, boolean[] reverse) throws IllegalArgumentException {
        int i;
        int[] used = new int[this.score.length];
        boolean direct = index == null;
        int oldStart = 0;
        int len = direct ? this.score.length : index.length;
        this.start = new int[len];
        this.partialLength = new int[len];
        this.isVariable = new boolean[this.score.length];
        this.index = new int[len];
        this.reverse = new boolean[len];
        for (i = 0; i < len; ++i) {
            if (direct) {
                this.index[i] = i;
            } else if (0 <= index[i] && index[i] < this.score.length) {
                this.index[i] = index[i];
            } else {
                throw new IndexOutOfBoundsException("index " + index[i]);
            }
            int n = this.index[i];
            used[n] = used[n] + 1;
            this.reverse[i] = reverse == null ? false : reverse[i];
            this.start[i] = oldStart;
            this.partialLength[i] = length[i];
            this.isVariable[this.index[i]] = this.score[this.index[i]] instanceof VariableLengthScoringFunction;
            if (!this.isVariable[this.index[i]] && this.score[this.index[i]].getLength() != this.partialLength[i]) {
                throw new IllegalArgumentException("Could not use length " + this.partialLength[i] + " at part " + i + " for NormalizableScoringFunction with index " + this.index[i] + ".");
            }
            oldStart += this.partialLength[i];
        }
        for (i = 0; i < used.length; ++i) {
            if (used[i] != 0) continue;
            throw new IllegalArgumentException("The ScoringFunction with index " + i + " is never used.");
        }
        this.partIList = new IntList();
    }

    private void setParamsStarts() {
        if (this.params == null) {
            this.params = new int[this.score.length + 1];
        }
        for (int i = 0; i < this.score.length; ++i) {
            int n = this.score[i].getNumberOfParameters();
            if (n == -1) {
                this.params = null;
                break;
            }
            this.params[i + 1] = this.params[i] + n;
        }
    }

    public IndependentProductScoringFunction clone() throws CloneNotSupportedException {
        IndependentProductScoringFunction clone = (IndependentProductScoringFunction)super.clone();
        clone.score = (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
        clone.set(this.index, this.partialLength, this.reverse);
        clone.params = null;
        clone.setParamsStarts();
        clone.motifs = (int[])this.motifs.clone();
        clone.motifIndexArray = (int[])this.motifIndexArray.clone();
        clone.components = (int[])this.components.clone();
        clone.componentsUntilNow = (int[])this.componentsUntilNow.clone();
        clone.componentIndexArray = (int[])this.componentIndexArray.clone();
        return clone;
    }

    private int getSFIndex(int index) {
        int i;
        for (i = 1; i < this.params.length && index >= this.params[i]; ++i) {
        }
        return i - 1;
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        int i = this.getSFIndex(index);
        return this.score[i].getSizeOfEventSpaceForRandomVariablesOfParameter(index - this.params[i]);
    }

    public double getNormalizationConstant() {
        double norm = 1.0;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.isVariable[i]) {
                norm *= ((VariableLengthScoringFunction)this.score[this.index[i]]).getNormalizationConstant(this.partialLength[i]);
                continue;
            }
            norm *= this.score[this.index[i]].getNormalizationConstant();
        }
        return norm;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        int j = this.getSFIndex(parameterIndex);
        int k = parameterIndex - this.params[j];
        double normOfOther = 1.0;
        double myNorm = 1.0;
        double myPartNorm = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.index[i] == j) {
                double n;
                double p;
                if (this.isVariable[i]) {
                    p = ((VariableLengthScoringFunction)this.score[j]).getPartialNormalizationConstant(k, this.partialLength[i]);
                    n = ((VariableLengthScoringFunction)this.score[j]).getNormalizationConstant(this.partialLength[i]);
                } else {
                    p = this.score[j].getPartialNormalizationConstant(k);
                    n = this.score[j].getNormalizationConstant();
                }
                myPartNorm = myPartNorm * n + myNorm * p;
                myNorm *= n;
                continue;
            }
            if (this.isVariable[i]) {
                normOfOther *= ((VariableLengthScoringFunction)this.score[this.index[i]]).getNormalizationConstant(this.partialLength[i]);
                continue;
            }
            normOfOther *= this.score[this.index[i]].getNormalizationConstant();
        }
        return normOfOther * myPartNorm;
    }

    public double getEss() {
        return this.ess;
    }

    public void initializeFunction(int index, boolean freeParams, Sample[] data, double[][] weights) throws Exception {
        Sample[] part = new Sample[data.length];
        for (int i = 0; i < this.score.length; ++i) {
            if (!this.plugIn && this.motifs[i + 1] - this.motifs[i] <= 0) continue;
            int a = this.extractSequenceParts(i, data, part);
            double[][] help = a == 1 ? weights : this.extractWeights(a, weights);
            this.score[i].initializeFunction(index, freeParams, part, help);
        }
        this.setParamsStarts();
    }

    private int extractSequenceParts(int scoringFunctionIndex, Sample[] data, Sample[] result) throws Exception {
        Arrays.fill(result, null);
        int used = 0;
        for (int k = 0; k < this.index.length; ++k) {
            if (this.index[k] != scoringFunctionIndex) continue;
            ++used;
            for (int j = 0; j < data.length; ++j) {
                Sample current = data[j].getInfixSample(this.start[k], this.partialLength[k]);
                if (this.reverse[k]) {
                    Sequence[] seq = new Sequence[current.getNumberOfElements()];
                    for (int n = 0; n < seq.length; ++n) {
                        seq[n] = current.getElementAt(n).reverseComplement();
                    }
                    current = new Sample("reverse complement of \"" + current.getAnnotation() + "\"", seq);
                }
                result[j] = result[j] == null ? current : Sample.union(result[j], current);
            }
        }
        return used;
    }

    private double[][] extractWeights(int number, double[][] weights) {
        Object res;
        if (number == 1 || weights == null) {
            res = weights;
        } else {
            res = new double[weights.length][];
            for (int k = 0; k < ((double[][])res).length; ++k) {
                int n = weights[k].length;
                res[k] = new double[number * n];
                for (int j = 0; j < number; ++j) {
                    System.arraycopy(weights[k], 0, res[k], j * n, n);
                }
            }
        }
        return res;
    }

    protected void fromXML(StringBuffer rep) throws NonParsableException {
        StringBuffer xml = XMLParser.extractForTag(rep, this.getInstanceName());
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(xml, "AlphabetContainer");
        this.length = XMLParser.extractIntForTag(xml, "length");
        this.ess = XMLParser.extractDoubleForTag(xml, "ess");
        this.score = ArrayHandler.cast(NormalizableScoringFunction.class, XMLParser.extractStorableArrayForTag(xml, "ScoringFunctions"));
        this.set(XMLParser.extractIntArrayForTag(xml, "index"), XMLParser.extractIntArrayForTag(xml, "partialLength"), XMLParser.extractBooleanArrayForTag(xml, "reverse"));
        try {
            this.plugIn = XMLParser.extractBooleanForTag(xml, "plugIn");
        }
        catch (Exception e) {
            this.plugIn = true;
        }
        this.setParamsStarts();
        this.prepare();
    }

    public String getInstanceName() {
        return this.getClass().getSimpleName();
    }

    public NormalizableScoringFunction[] getFunctions() throws Exception {
        return (NormalizableScoringFunction[])ArrayHandler.clone((Cloneable[])this.score);
    }

    public int[] getIndices() {
        return (int[])this.index.clone();
    }

    public int[] getPartialLengths() {
        return (int[])this.partialLength.clone();
    }

    public boolean[] getReverseSwitches() {
        return (boolean[])this.reverse.clone();
    }

    public double[] getCurrentParameterValues() throws Exception {
        int numPars = this.getNumberOfParameters();
        double[] pars = new double[numPars];
        int k = 0;
        for (int i = 0; i < this.score.length; ++i) {
            double[] help = this.score[i].getCurrentParameterValues();
            System.arraycopy(help, 0, pars, k, help.length);
            k += help.length;
        }
        return pars;
    }

    public double getLogScore(Sequence seq, int start) {
        double s = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            if (this.reverse[i]) {
                try {
                    if (this.isVariable[this.index[i]]) {
                        s += ((VariableLengthScoringFunction)this.score[this.index[i]]).getLogScore(seq.reverseComplement(), seq.getLength() - start - this.start[i] - this.partialLength[i], this.partialLength[i]);
                        continue;
                    }
                    s += this.score[this.index[i]].getLogScore(seq.reverseComplement(), seq.getLength() - start - this.start[i] - this.partialLength[i]);
                    continue;
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            }
            if (this.isVariable[this.index[i]]) {
                s += ((VariableLengthScoringFunction)this.score[this.index[i]]).getLogScore(seq, start + this.start[i], this.partialLength[i]);
                continue;
            }
            s += this.score[this.index[i]].getLogScore(seq, start + this.start[i]);
        }
        return s;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList partialDer) {
        double s = 0.0;
        for (int i = 0; i < this.index.length; ++i) {
            this.partIList.clear();
            if (this.reverse[i]) {
                try {
                    if (this.isVariable[this.index[i]]) {
                        s += ((VariableLengthScoringFunction)this.score[this.index[i]]).getLogScoreAndPartialDerivation(seq.reverseComplement(), seq.getLength() - start - this.start[i] - this.partialLength[i], this.partialLength[i], this.partIList, partialDer);
                    }
                    s += this.score[this.index[i]].getLogScoreAndPartialDerivation(seq.reverseComplement(), seq.getLength() - start - this.start[i] - this.partialLength[i], this.partIList, partialDer);
                }
                catch (Exception e) {
                    throw new RuntimeException(e.getMessage());
                }
            } else {
                s = this.isVariable[this.index[i]] ? (s += ((VariableLengthScoringFunction)this.score[this.index[i]]).getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partialLength[i], this.partIList, partialDer)) : (s += this.score[this.index[i]].getLogScoreAndPartialDerivation(seq, start + this.start[i], this.partIList, partialDer));
            }
            for (int j = 0; j < this.partIList.length(); ++j) {
                indices.add(this.partIList.get(j) + this.params[this.index[i]]);
            }
        }
        return s;
    }

    public int getNumberOfParameters() {
        if (this.params == null) {
            return -1;
        }
        return this.params[this.score.length];
    }

    public int getNumberOfRecommendedStarts() {
        int max = this.score[0].getNumberOfRecommendedStarts();
        for (int i = 1; i < this.score.length; ++i) {
            max = Math.max(max, this.score[i].getNumberOfRecommendedStarts());
        }
        return max;
    }

    public void setParameters(double[] params, int start) {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].setParameters(params, start + this.params[i]);
        }
    }

    public StringBuffer toXML() {
        StringBuffer xml = new StringBuffer(10000);
        XMLParser.appendStorableWithTags(xml, this.alphabets, "AlphabetContainer");
        XMLParser.appendIntWithTags(xml, this.length, "length");
        XMLParser.appendDoubleWithTags(xml, this.ess, "ess");
        XMLParser.appendStorableArrayWithTags(xml, this.score, "ScoringFunctions");
        XMLParser.appendIntArrayWithTags(xml, this.index, "index");
        XMLParser.appendIntArrayWithTags(xml, this.partialLength, "partialLength");
        XMLParser.appendBooleanArrayWithTags(xml, this.reverse, "reverse");
        XMLParser.appendBooleanWithTags(xml, this.plugIn, "plugIn");
        XMLParser.addTags(xml, this.getInstanceName());
        return xml;
    }

    public String toString() {
        int i;
        StringBuffer sb = new StringBuffer(100000);
        for (i = 0; i < this.score.length; ++i) {
            sb.append("ScoringFunction " + i + ": " + this.score[i].getInstanceName() + "\n");
            sb.append(this.score[i].toString() + "\n");
        }
        sb.append("digraph {\n");
        sb.append("n0[shape=house, orientation=" + (this.reverse[0] ? 90 : -90) + ", label=\"emission: " + this.index[0] + "\\nduration: " + this.partialLength[0] + "\"]\n");
        for (i = 1; i < this.index.length; ++i) {
            sb.append("n" + i + "[shape=house, orientation=" + (this.reverse[i] ? 90 : -90) + ", label=\"emission: " + this.index[i] + "\\nduration: " + this.partialLength[i] + "\"]\n");
            sb.append("n" + (i - 1) + "->n" + i + "\n");
        }
        sb.append("}");
        return sb.toString();
    }

    public double getLogPriorTerm() {
        double val = 0.0;
        for (int i = 0; i < this.score.length; ++i) {
            val += this.score[i].getLogPriorTerm();
        }
        return val;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].addGradientOfLogPriorTerm(grad, start + this.params[i]);
        }
    }

    public boolean isInitialized() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isInitialized(); ++i) {
        }
        return i == this.score.length;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
        for (int i = 0; i < this.score.length; ++i) {
            this.score[i].initializeFunctionRandomly(freeParams);
        }
        this.setParamsStarts();
    }

    private void fillMotifIndexArray(int motifIndex) throws IndexOutOfBoundsException {
        this.motifIndexArray[0] = -1;
        for (int i = 1; i < this.motifs.length; ++i) {
            if (!(this.score[i - 1] instanceof MotifDiscoverer) || motifIndex < this.motifs[i - 1] || motifIndex >= this.motifs[i]) continue;
            this.motifIndexArray[0] = i - 1;
            this.motifIndexArray[1] = motifIndex - this.motifs[this.motifIndexArray[0]];
            this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
            return;
        }
        throw new IndexOutOfBoundsException();
    }

    public void initializeMotif(int motifIndex, Sample data, double[] weights) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).initializeMotif(this.motifIndexArray[1], data, weights);
            this.setParamsStarts();
        } else {
            System.out.println("warning: not possible");
        }
    }

    public boolean modifyMotif(int motifIndex, double[] weightsLeft, double[] weightsRight, double[][][][] replacementLeft, double[][][][] replacementRight, int offsetLeft, int offsetRight) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            boolean b = ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).modifyMotif(this.motifIndexArray[1], weightsLeft, weightsRight, replacementLeft, replacementRight, offsetLeft, offsetRight);
            this.setParamsStarts();
            return b;
        }
        return false;
    }

    public boolean modifyMotif(int motifIndex, int offsetLeft, int offsetRight) throws Exception {
        this.fillMotifIndexArray(motifIndex);
        if (this.motifIndexArray[2] >= 0) {
            boolean b = ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).modifyMotif(this.motifIndexArray[1], offsetLeft, offsetRight);
            this.setParamsStarts();
            return b;
        }
        return false;
    }

    public int[] determineNotSignificantPositionsFor(int motif, Sample[] data, double[][] weights, int classIdx) {
        this.fillMotifIndexArray(motif);
        if (motif < 0 || motif >= this.motifs[this.score.length]) {
            throw new IndexOutOfBoundsException();
        }
        if (this.motifIndexArray[2] == -1) {
            return new int[]{0, 0};
        }
        Sample[] part = new Sample[data.length];
        try {
            int a = this.extractSequenceParts(this.motifIndexArray[0], data, part);
            return ((MutableMotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).determineNotSignificantPositionsFor(this.motifIndexArray[1], part, this.extractWeights(a, weights), classIdx);
        }
        catch (Exception e) {
            RuntimeException r = new RuntimeException(e.getMessage());
            r.setStackTrace(r.getStackTrace());
            throw r;
        }
    }

    private void fillComponentIndexArray(int componentIndex) throws IndexOutOfBoundsException {
        if (componentIndex < 0 || componentIndex > this.getNumberOfComponents()) {
            throw new IndexOutOfBoundsException();
        }
        for (int i = this.index.length - 1; i >= 0; --i) {
            this.componentIndexArray[i] = componentIndex % this.components[i];
            componentIndex /= this.components[i];
        }
    }

    private void fillMotifIndexArrayForComponent(int componentIndex, int motifIndex) throws IndexOutOfBoundsException {
        this.fillComponentIndexArray(componentIndex);
        int i = -1;
        int anz = 0;
        do {
            motifIndex -= anz;
            if (++i == this.score.length) {
                throw new IndexOutOfBoundsException();
            }
            this.fillHashWith(i);
        } while ((anz = this.hash.size()) != 0 && motifIndex < anz);
        this.motifIndexArray[0] = i;
        this.motifIndexArray[2] = this.score[this.motifIndexArray[0]] instanceof MutableMotifDiscoverer ? 1 : -1;
        int[] specificMotifs = new int[anz];
        Iterator<Integer> it = this.hash.iterator();
        for (i = 0; i < anz; ++i) {
            specificMotifs[i] = it.next();
        }
        Arrays.sort(specificMotifs);
        this.motifIndexArray[1] = specificMotifs[motifIndex];
    }

    private void fillHashWith(int scoreIndex) {
        if (this.hash == null) {
            this.hash = new HashSet();
        }
        if (scoreIndex == this.score.length) {
            throw new IndexOutOfBoundsException();
        }
        this.hash.clear();
        if (this.score[scoreIndex] instanceof MotifDiscoverer) {
            MotifDiscoverer md = (MotifDiscoverer)((Object)this.score[scoreIndex]);
            for (int idx = 0; idx < this.index.length; ++idx) {
                if (this.index[idx] != scoreIndex) continue;
                int m = md.getNumberOfMotifsInComponent(this.components[idx]);
                for (int l = 0; l < m; ++l) {
                    int h = md.getGlobalIndexOfMotifInComponent(this.components[idx], l);
                    if (this.hash.contains(h)) continue;
                    this.hash.add(h);
                }
            }
        }
    }

    public int getGlobalIndexOfMotifInComponent(int component, int motif) {
        this.fillMotifIndexArrayForComponent(component, motif);
        return this.motifs[this.motifIndexArray[0]] + this.motifIndexArray[1];
    }

    public int getIndexOfMaximalComponentFor(Sequence sequence) throws Exception {
        int c = 0;
        for (int i = 0; i < this.index.length; ++i) {
            int idx = this.score[this.index[i]] instanceof AbstractMixtureScoringFunction ? (this.reverse[i] ? ((AbstractMixtureScoringFunction)this.score[this.index[i]]).getIndexOfMaximalComponentFor(sequence.reverseComplement(), sequence.getLength() - this.start[i] - this.partialLength[i]) : ((AbstractMixtureScoringFunction)this.score[this.index[i]]).getIndexOfMaximalComponentFor(sequence, this.start[i])) : (this.score[i] instanceof MotifDiscoverer ? (this.reverse[i] ? ((MotifDiscoverer)((Object)this.score[this.index[i]])).getIndexOfMaximalComponentFor(sequence.reverseComplement(sequence.getLength() - this.start[i] - this.partialLength[i], sequence.getLength() - this.start[i])) : ((MotifDiscoverer)((Object)this.score[this.index[i]])).getIndexOfMaximalComponentFor(sequence.getSubSequence(this.score[i].getAlphabetContainer(), this.start[i], this.partialLength[i]))) : 0);
            c += this.componentsUntilNow[i] * idx;
        }
        return c;
    }

    public int getMotifLength(int motif) {
        this.fillMotifIndexArray(motif);
        return ((MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]])).getMotifLength(this.motifIndexArray[1]);
    }

    public int getNumberOfComponents() {
        return this.componentsUntilNow[this.index.length];
    }

    public int getNumberOfMotifs() {
        return this.motifs[this.score.length];
    }

    public int getNumberOfMotifsInComponent(int component) {
        this.fillComponentIndexArray(component);
        int anz = 0;
        for (int i = 0; i < this.score.length; ++i) {
            this.fillHashWith(i);
            anz += this.hash.size();
        }
        return anz;
    }

    public double[] getProfileOfScoresFor(int component, int motif, Sequence sequence, int startpos, MotifDiscoverer.KindOfProfile dist) throws Exception {
        this.fillMotifIndexArrayForComponent(component, motif);
        MotifDiscoverer md = (MotifDiscoverer)((Object)this.score[this.motifIndexArray[0]]);
        int w = md.getMotifLength(this.motifIndexArray[1]);
        double[] erg = new double[this.length - w + 1];
        Arrays.fill(erg, Double.NEGATIVE_INFINITY);
        for (int i = 0; i < this.index.length; ++i) {
            double[] part;
            if (this.index[i] != this.motifIndexArray[0]) continue;
            int idx = 0;
            while (md.getGlobalIndexOfMotifInComponent(this.componentIndexArray[i], idx) != this.motifIndexArray[1]) {
                ++idx;
            }
            if (this.reverse[i]) {
                part = md.getProfileOfScoresFor(this.componentIndexArray[i], idx, sequence.reverseComplement(), sequence.getLength() - startpos - this.start[i] - this.partialLength[i], dist);
                System.arraycopy(part, 0, erg, this.start[i], this.partialLength[i] - w + 1);
                continue;
            }
            part = md.getProfileOfScoresFor(this.componentIndexArray[i], idx, sequence, startpos + this.start[i], dist);
            int k = this.start[i];
            int j = part.length - 1;
            while (j >= 0) {
                erg[k] = part[j];
                --j;
                ++k;
            }
        }
        return erg;
    }

    public StrandedLocatedSequenceAnnotationWithLength.Strand getStrandFor(int component, int motif, Sequence sequence, int startpos) throws Exception {
        return StrandedLocatedSequenceAnnotationWithLength.Strand.UNKNOWN;
    }

    public boolean isNormalized() {
        int i;
        for (i = 0; i < this.score.length && this.score[i].isNormalized(); ++i) {
        }
        return i == this.score.length;
    }
}

