/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions;

import de.jstacs.NonParsableException;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.Sample;
import de.jstacs.data.Sequence;
import de.jstacs.io.XMLParser;
import de.jstacs.scoringFunctions.AbstractNormalizableScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public class UniformScoringFunction
extends AbstractNormalizableScoringFunction {
    private double ess;
    private double logP;

    public UniformScoringFunction(AlphabetContainer alphabets, int length, double ess) {
        super(alphabets, length);
        if (!alphabets.isDiscrete()) {
            throw new IllegalArgumentException("The given AlphabetContainer has to be discrete.");
        }
        int l = alphabets.getPossibleLength();
        if (l != 0 && l != length) {
            throw new IllegalArgumentException("The given AlphabetContainer (possible length = " + l + ") and length (" + length + ") do not match.");
        }
        if (ess < 0.0) {
            throw new IllegalArgumentException("The given ess has to be non-negative.");
        }
        this.ess = ess;
        this.computeLogP();
    }

    public UniformScoringFunction(StringBuffer xml) throws NonParsableException {
        super(xml);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = 1.0;
        for (int i = 0; i < this.length; ++i) {
            this.logP *= this.alphabets.getAlphabetLengthAt(i);
        }
        this.logP = -Math.log(this.logP);
    }

    public String getInstanceName() {
        return "uniform";
    }

    public double getLogScore(Sequence seq, int start) {
        return this.logP;
    }

    public double getLogScoreAndPartialDerivation(Sequence seq, int start, IntList indices, DoubleList dList) {
        return this.logP;
    }

    public int getNumberOfParameters() {
        return 0;
    }

    public void setParameters(double[] params, int start) {
    }

    public StringBuffer toXML() {
        StringBuffer b = new StringBuffer(1000);
        XMLParser.appendIntWithTags(b, this.length, "length");
        XMLParser.appendStorableWithTags(b, this.alphabets, "alphabets");
        XMLParser.appendDoubleWithTags(b, this.ess, "ess");
        XMLParser.addTags(b, this.getClass().getSimpleName());
        return b;
    }

    public double getNormalizationConstant() {
        return 1.0;
    }

    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    protected void fromXML(StringBuffer xml) throws NonParsableException {
        StringBuffer b = XMLParser.extractForTag(xml, this.getClass().getSimpleName());
        this.length = XMLParser.extractIntForTag(b, "length");
        this.alphabets = (AlphabetContainer)XMLParser.extractStorableForTag(b, "alphabets");
        this.ess = XMLParser.extractDoubleForTag(b, "ess");
    }

    public int getSizeOfEventSpaceForRandomVariablesOfParameter(int index) {
        return 0;
    }

    public double getPartialNormalizationConstant(int parameterIndex) throws Exception {
        throw new IndexOutOfBoundsException("Since a uniform scoring function has no parameters, this method can not be used");
    }

    public double getEss() {
        return this.ess;
    }

    public String toString() {
        StringBuffer info = new StringBuffer(this.length * 100);
        for (int j = 0; j < this.length; ++j) {
            double val = 1.0 / this.alphabets.getAlphabetLengthAt(0);
            info.append(j + "\t" + val + " for each element of " + this.alphabets.getAlphabetAt(j).toString());
            if (j >= this.length - 1) continue;
            info.append("\n");
        }
        return info.toString();
    }

    public double getLogPriorTerm() {
        return 0.0;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isNormalized() {
        return true;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }
}

