/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs.scoringFunctions.mix.motifSearch;

import de.jstacs.NonParsableException;
import de.jstacs.data.Sample;
import de.jstacs.scoringFunctions.mix.motifSearch.DurationScoringFunction;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.IntList;

public final class UniformDurationScoringFunction
extends DurationScoringFunction {
    private double logP;

    public UniformDurationScoringFunction(int min, int max) {
        this(min, max, 0.0);
    }

    public UniformDurationScoringFunction(int min, int max, double ess) {
        super(min, max, ess);
        this.computeLogP();
    }

    public UniformDurationScoringFunction(StringBuffer b) throws NonParsableException {
        super(b);
        this.computeLogP();
    }

    private void computeLogP() {
        this.logP = -Math.log(this.delta + 1);
    }

    public String getInstanceName() {
        return "uniform";
    }

    public int getNumberOfParameters() {
        return 0;
    }

    public void setParameters(double[] params, int start) {
    }

    public void initializeFunction(int index, boolean meila, Sample[] data, double[][] weights) {
    }

    protected String getRNotation(String distributionName) {
        return "l = " + this.min + ":" + this.max + "; n = length(l); " + distributionName + " = rep(1,n)/n;";
    }

    public double getLogPriorTerm() {
        return 0.0;
    }

    public void addGradientOfLogPriorTerm(double[] grad, int start) {
    }

    public double getLogScore(int ... values) {
        return this.logP;
    }

    protected double getLogScoreAndPartialDerivation(IntList indices, DoubleList partialDer, int ... values) {
        return this.logP;
    }

    public void drawPosition(int[] positions) {
        positions[0] = this.min + r.nextInt(this.delta + 1);
    }

    public double[] getCurrentParameterValues() throws Exception {
        return new double[0];
    }

    public boolean isInitialized() {
        return true;
    }

    public boolean isNormalized() {
        return true;
    }

    public void initializeFunctionRandomly(boolean freeParams) throws Exception {
    }

    public void initializeUniformly() {
    }

    public void adjust(int[] length, double[] weight) {
    }
}

