/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.sequences.IntSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.utils.ComparableElement;
import java.io.FileOutputStream;
import java.util.Arrays;
import java.util.LinkedList;
import java.util.Random;

public class ChIPSeqTop500SplitAndShuffle {
    public static void main(String[] args) throws Exception {
        DNADataSet dso = new DNADataSet(args[0], '>', new SplitSequenceAnnotationParser(":", ";"));
        Object[] comp = new ComparableElement[dso.getNumberOfElements()];
        int i = 0;
        while (i < dso.getNumberOfElements()) {
            comp[i] = new ComparableElement<Sequence, Double>(dso.getElementAt(i), Double.parseDouble(dso.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier()));
            ++i;
        }
        Arrays.sort(comp);
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        int i2 = 0;
        while (i2 < 500 && i2 < comp.length) {
            seqs.add((Sequence)((ComparableElement)comp[comp.length - 1 - i2]).getElement());
            ++i2;
        }
        DataSet topo = new DataSet("", seqs);
        DataSet rest = DataSet.diff(dso, topo);
        DataSet[] tops = topo.partition(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, 10);
        DataSet[] rests = rest.partition(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, 10);
        int r = 0;
        while (r < tops.length) {
            tops[r].save(new FileOutputStream(args[0].replaceAll(".fa", "_top_" + r + ".fa")), '>', new SplitSequenceAnnotationParser(":", ";"));
            seqs.clear();
            int i3 = 0;
            while (i3 < tops[r].getNumberOfElements()) {
                int j = 0;
                while (j < 10) {
                    seqs.add(ChIPSeqTop500SplitAndShuffle.shuffle(tops[r].getElementAt(i3), 2));
                    ++j;
                }
                ++i3;
            }
            DataSet shuffled = new DataSet("", seqs);
            shuffled.save(new FileOutputStream(args[0].replaceAll(".fa", "_shuffled_" + r + ".fa")), '>', null);
            DataSet all = DataSet.union(tops[r], rests[r]);
            all.save(new FileOutputStream(args[0].replaceAll(".fa", "_part_" + r + ".fa")), '>', new SplitSequenceAnnotationParser(":", ";"));
            ++r;
        }
    }

    private static Sequence shuffle(Sequence original, int k) throws Exception {
        Random r = new Random();
        int n = original.getLength();
        int[] shuffle = new int[n];
        int[] help = (int[])shuffle.clone();
        int i = 0;
        while (i < n) {
            shuffle[i] = original.discreteVal(i);
            ++i;
        }
        int anz = 0;
        int i2 = 0;
        while (i2 < shuffle.length) {
            int a = r.nextInt(n - 4 * (k + 1));
            int b = a + 1 + r.nextInt(n - 3 * (k + 1) - a);
            int c = b + 1 + r.nextInt(n - 2 * (k + 1) - b);
            int d = c + 1 + r.nextInt(n - k + 1 - c);
            int j = 0;
            while (j < k - 1 && shuffle[a + j] == shuffle[c + j]) {
                ++j;
            }
            boolean matches = j == k - 1;
            j = 0;
            while (matches && j < k - 1 && shuffle[b + j] == shuffle[d + j]) {
                ++j;
            }
            if (matches &= j == k - 1) {
                ++anz;
                Arrays.fill(help, 0);
                System.arraycopy(shuffle, 0, help, 0, a);
                System.arraycopy(shuffle, c, help, a, d - c);
                System.arraycopy(shuffle, b, help, a + d - c, c - b);
                System.arraycopy(shuffle, a, help, a + d - b, b - a);
                System.arraycopy(shuffle, d, help, d, n - d);
                System.arraycopy(help, 0, shuffle, 0, n);
            }
            ++i2;
        }
        IntSequence seq = new IntSequence(original.getAlphabetContainer(), shuffle);
        return seq;
    }
}

