/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.ListResult;
import de.jstacs.results.ResultSet;
import java.io.BufferedReader;
import java.io.FileReader;
import projects.dimont.Interpolation;

public class EvaluateSELEX
extends EvaluateSingleDataSetSlimDimontHOSingleCl {
    public static void main(String[] args) throws Exception {
        String base = args[0];
        DNADataSet top = new DNADataSet(String.valueOf(base) + "_top.fa");
        DNADataSet shuffled = new DNADataSet(String.valueOf(base) + "_shuffled.fa");
        DataSet sampled = new DNADataSet(args[2]);
        sampled = EvaluateSELEX.subSample(sampled, top.getNumberOfElements() * 10);
        DNADataSet all = new DNADataSet(String.valueOf(base) + ".fa", '>', new SplitSequenceAnnotationParser(":", ";"));
        double[] allstat = new double[all.getNumberOfElements()];
        int i = 0;
        while (i < all.getNumberOfElements()) {
            allstat[i] = Double.parseDouble(all.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            ++i;
        }
        double[] allw = Interpolation.getWeight(all, allstat, 0.2, Interpolation.RANK_LOG);
        double[] nallw = Interpolation.getBgWeight(allw);
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        BufferedReader reader = new BufferedReader(new FileReader(args[1]));
        String str = "";
        double[][] matrix = null;
        int i2 = 0;
        while ((str = reader.readLine()) != null) {
            if ((str = str.trim()).length() <= 0) continue;
            String[] parts = str.split("\t");
            if (matrix == null) {
                matrix = new double[parts.length][4];
            }
            int j = 0;
            while (j < parts.length) {
                matrix[j][i2] = Math.log(Double.parseDouble(parts[j]) + 1.0E-6);
                ++j;
            }
            ++i2;
        }
        reader.close();
        double[] sc = EvaluateSELEX.getMaxScores(all, matrix);
        double[] topAr = EvaluateSELEX.getMaxScores(top, matrix);
        double[] shufAr = EvaluateSELEX.getMaxScores(shuffled, matrix);
        double[] sampAr = EvaluateSELEX.getMaxScores(sampled, matrix);
        ResultSet res = EvaluateSELEX.getResult(-1, -1, topAr, shufAr, sampAr, sc, Double.NaN, allstat, allw, nallw);
        System.out.println(new ListResult("", "", null, res));
    }

    private static double[] getMaxScores(DataSet data, double[][] pwm) throws Exception {
        double[] scs = new double[data.getNumberOfElements()];
        int i = 0;
        while (i < data.getNumberOfElements()) {
            double sc;
            double max = Double.NEGATIVE_INFINITY;
            Sequence seq = data.getElementAt(i);
            int j = 0;
            while (j < seq.getLength() - pwm.length + 1) {
                sc = EvaluateSELEX.getScore(pwm, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            seq = seq.reverseComplement();
            j = 0;
            while (j < seq.getLength() - pwm.length + 1) {
                sc = EvaluateSELEX.getScore(pwm, seq, j);
                if (sc > max) {
                    max = sc;
                }
                ++j;
            }
            scs[i] = max;
            ++i;
        }
        return scs;
    }

    private static double getScore(double[][] pwm, Sequence seq, int start) {
        double score = 0.0;
        int i = 0;
        while (i < pwm.length) {
            score += pwm[i][seq.discreteVal(start + i)];
            ++i;
        }
        return score;
    }

    private static void print(double[][] pwm) {
        DNAAlphabet alp = DNAAlphabet.SINGLETON;
        int i = 0;
        while (i < pwm.length) {
            int j = 0;
            while ((double)j < alp.length()) {
                System.out.print(" " + pwm[i][j]);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }
}

