/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.NumericalResultSet;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.utils.DoubleList;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;
import projects.dimont.Interpolation;

public class EvaluateTFFM {
    public static void main(String[] args) throws Exception {
        String base = args[0];
        String scorebase = args[1];
        DNADataSet all = new DNADataSet(String.valueOf(base) + ".fa", '>', new SplitSequenceAnnotationParser(":", ";"));
        BufferedReader reader = new BufferedReader(new FileReader(String.valueOf(scorebase) + ".txt"));
        HashMap<String, Double> map = new HashMap<String, Double>();
        String str = "";
        while ((str = reader.readLine()) != null) {
            String[] parts = str.split("\t");
            String id = parts[0].replaceAll("id:", "").replaceAll(";", "");
            double score = Double.parseDouble(parts[7]);
            map.put(id, score);
        }
        reader.close();
        double[] sc = new double[all.getNumberOfElements()];
        double[] in = new double[all.getNumberOfElements()];
        int i = 0;
        while (i < all.getNumberOfElements()) {
            String id = all.getElementAt(i).getSequenceAnnotationByType("id", 0).getIdentifier();
            in[i] = Double.parseDouble(all.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            Double temp = (Double)map.get(id);
            if (temp != null) {
                sc[i] = temp;
            }
            ++i;
        }
        double[] allw = Interpolation.getWeight(all, in, 0.2, Interpolation.RANK_LOG);
        double[] nallw = Interpolation.getBgWeight(allw);
        reader = new BufferedReader(new FileReader(String.valueOf(scorebase) + "_top.txt"));
        DoubleList topScores = new DoubleList();
        str = "";
        while ((str = reader.readLine()) != null) {
            String[] parts = str.split("\t");
            double score = Double.parseDouble(parts[7]);
            topScores.add(score);
        }
        reader.close();
        reader = new BufferedReader(new FileReader(String.valueOf(scorebase) + "_shuffled.txt"));
        DoubleList shufScores = new DoubleList();
        str = "";
        while ((str = reader.readLine()) != null) {
            String[] parts = str.split("\t");
            double score = Double.parseDouble(parts[7]);
            shufScores.add(score);
        }
        reader.close();
        AucROC aucroc = new AucROC();
        AucPR aucpr = new AucPR();
        double[] topAr = topScores.toArray();
        double[] shufAr = shufScores.toArray();
        Arrays.sort(topAr);
        Arrays.sort(shufAr);
        NumericalResultSet setROC = aucroc.compute(topAr, shufAr);
        NumericalResultSet setPR = aucpr.compute(topAr, shufAr);
        ResultSet set = EvaluateSingleDataSetSlimDimont.getMeasures(sc, all, in, allw, nallw, "");
        LinkedList<Result> list = new LinkedList<Result>();
        list.add(new CategoricalResult("Order", "", "TFFM"));
        list.add(new NumericalResult("LastScore", "", Double.NaN));
        int j = 0;
        while (j < setROC.getNumberOfResults()) {
            list.add(setROC.getResultAt(j));
            ++j;
        }
        j = 0;
        while (j < setPR.getNumberOfResults()) {
            list.add(setPR.getResultAt(j));
            ++j;
        }
        j = 0;
        while (j < set.getNumberOfResults()) {
            list.add(set.getResultAt(j));
            ++j;
        }
        System.out.println(new ListResult("", "", null, new ResultSet(list)));
    }
}

