/*
 * Decompiled with CFR 0.152.
 */
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import java.util.Random;

public class Musterloesung_Motivsuche {
    static Map<Character, Integer> alphabetMap;

    public static void main(String[] args) throws Exception {
        double oldLL;
        String file = args[0];
        int motifWidth = Integer.parseInt(args[1]);
        alphabetMap = new HashMap<Character, Integer>();
        Character[] symbols = new Character[]{Character.valueOf('A'), Character.valueOf('C'), Character.valueOf('G'), Character.valueOf('T')};
        int i = 0;
        while (i < symbols.length) {
            alphabetMap.put(symbols[i], i);
            ++i;
        }
        String[] sequences = Musterloesung_Motivsuche.readSequences(file);
        double[][] gammas = Musterloesung_Motivsuche.initGammas(sequences, motifWidth);
        double[][] pwm = new double[motifWidth][4];
        double ll = oldLL = Double.NEGATIVE_INFINITY;
        do {
            oldLL = ll;
            Musterloesung_Motivsuche.updatePWM(pwm, sequences, gammas);
            ll = Musterloesung_Motivsuche.updateGammas(pwm, sequences, gammas);
            System.out.println(ll);
        } while (ll - oldLL > 1.0E-4);
        System.out.println(String.valueOf(ll) + "\n");
        System.out.println("> my motif");
        int i2 = 0;
        while (i2 < pwm[0].length) {
            System.out.print(symbols[i2] + " [");
            int j = 0;
            while (j < pwm.length) {
                System.out.print("\t" + pwm[j][i2]);
                ++j;
            }
            System.out.println("]");
            ++i2;
        }
    }

    public static double updateGammas(double[][] pwm, String[] sequences, double[][] gammas) {
        double ll = 0.0;
        int i = 0;
        while (i < sequences.length) {
            double gammaSum = 0.0;
            int j = 0;
            while (j < sequences[i].length() - pwm.length + 1) {
                gammas[i][j] = 1.0;
                int k = 0;
                while (k < pwm.length) {
                    double[] dArray = gammas[i];
                    int n = j;
                    dArray[n] = dArray[n] * pwm[k][alphabetMap.get(Character.valueOf(sequences[i].charAt(j + k)))];
                    ++k;
                }
                gammaSum += gammas[i][j];
                ++j;
            }
            ll += Math.log(gammaSum) - Math.log(gammas[i].length) - (double)gammas[i].length * Math.log(4.0);
            j = 0;
            while (j < gammas[i].length) {
                double[] dArray = gammas[i];
                int n = j++;
                dArray[n] = dArray[n] / gammaSum;
            }
            ++i;
        }
        return ll;
    }

    public static void updatePWM(double[][] pwm, String[] sequences, double[][] gammas) {
        int i = 0;
        while (i < pwm.length) {
            Arrays.fill(pwm[i], 0.0);
            ++i;
        }
        i = 0;
        while (i < sequences.length) {
            int j = 0;
            while (j < sequences[i].length() - pwm.length + 1) {
                int k = 0;
                while (k < pwm.length) {
                    double[] dArray = pwm[k];
                    int n = alphabetMap.get(Character.valueOf(sequences[i].charAt(j + k)));
                    dArray[n] = dArray[n] + gammas[i][j];
                    ++k;
                }
                ++j;
            }
            ++i;
        }
        i = 0;
        while (i < pwm.length) {
            double sum = 0.0;
            int j = 0;
            while (j < pwm[i].length) {
                sum += pwm[i][j];
                ++j;
            }
            j = 0;
            while (j < pwm[i].length) {
                double[] dArray = pwm[i];
                int n = j++;
                dArray[n] = dArray[n] / sum;
            }
            ++i;
        }
    }

    public static double[][] initGammas(String[] sequences, int motifWidth) {
        double[][] gammas = new double[sequences.length][];
        Random r = new Random();
        int i = 0;
        while (i < sequences.length) {
            gammas[i] = new double[sequences[i].length() - motifWidth + 1];
            int oneIndex = r.nextInt(gammas[i].length);
            gammas[i][oneIndex] = 1.0;
            ++i;
        }
        return gammas;
    }

    public static String[] readSequences(String file) throws IOException {
        ArrayList<String> strings = new ArrayList<String>();
        BufferedReader read = new BufferedReader(new FileReader(file));
        String str = null;
        while ((str = read.readLine()) != null) {
            strings.add(str);
        }
        read.close();
        return strings.toArray(new String[0]);
    }
}

