/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.LinkedList;

public class RelativeKMers {
    public static void main(String[] args) throws Exception {
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        DataSet ds = SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, args[0], parser);
        double[] signal = new double[ds.getNumberOfElements()];
        int i = 0;
        while (i < signal.length) {
            signal[i] = Double.parseDouble(ds.getElementAt(i).getSequenceAnnotationByType("signal", 0).getIdentifier());
            ++i;
        }
        double[] wm = RelativeKMers.getWeightMapping(ds, signal);
        System.out.println(Arrays.toString(wm));
    }

    private static double[] getWeightMapping(DataSet seqs, double[] signal) throws Exception {
        int max = (int)ToolBox.max(signal);
        double[] weightMap = new double[max + 1];
        LinkedList[] seqMap = new LinkedList[max + 1];
        int i = 0;
        while (i < seqMap.length) {
            seqMap[i] = new LinkedList();
            ++i;
        }
        i = 0;
        while (i < seqs.getNumberOfElements()) {
            int idx = (int)signal[i];
            seqMap[idx].add(seqs.getElementAt(i));
            ++i;
        }
        double mi = Double.POSITIVE_INFINITY;
        double ma = Double.NEGATIVE_INFINITY;
        int i2 = 0;
        while (i2 < seqMap.length) {
            if (seqMap[i2].size() > 0) {
                DataSet.WeightedDataSetFactory fac = new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.SORT_BY_WEIGHTS, new DataSet("", seqMap[i2]), null, 10);
                double sum = fac.getSumOfWeights();
                double k = 0.0;
                int j = 0;
                while ((double)j < (double)fac.getNumberOfElements() * 0.01) {
                    k += fac.getWeight(j);
                    ++j;
                }
                weightMap[i2] = k / sum;
                if (mi > weightMap[i2]) {
                    mi = weightMap[i2];
                }
                if (ma < weightMap[i2]) {
                    ma = weightMap[i2];
                }
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < weightMap.length) {
            weightMap[i2] = weightMap[i2] < mi ? 0.0 : (weightMap[i2] - mi) / (ma - mi) * 0.9 + 0.05;
            ++i2;
        }
        return weightMap;
    }
}

