/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;

public class TALERepertoires {
    private static double getAverageNumberOfMismatches(Sequence tal1, Sequence tal2) {
        boolean swap = false;
        if (tal2.getLength() > tal1.getLength()) {
            swap = true;
            Sequence temp = tal1;
            tal1 = tal2;
            tal2 = temp;
        }
        int maxl = tal1.getLength();
        int minl = tal2.getLength();
        double minmis = Double.POSITIVE_INFINITY;
        int off = 0;
        int i = -minl;
        while (i < maxl) {
            double nmis = 0.0;
            int j = 0;
            while (j < minl) {
                if (i + j < 0 || i + j >= maxl || tal1.discreteVal(i + j) != tal2.discreteVal(j)) {
                    nmis += 1.0;
                }
                ++j;
            }
            if (nmis < minmis) {
                minmis = nmis;
                off = i;
            }
            ++i;
        }
        System.out.println();
        System.out.println(tal1);
        System.out.println(tal2);
        System.out.println("off:" + off);
        System.out.println(minmis);
        System.out.println();
        return minmis / (double)minl;
    }

    public static void main(String[] args) throws Exception {
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        DataSet maff = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor("/Users/dev/Desktop/TAL-Chips/Antrag/TAL-reperoires/effectors_maff.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        DataSet kacc = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor("/Users/dev/Desktop/TAL-Chips/Antrag/TAL-reperoires/effectors_kacc.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        DataSet pxo = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor("/Users/dev/Desktop/TAL-Chips/Antrag/TAL-reperoires/effectors_pxo99.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        DataSet bls = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor("/Users/dev/Desktop/TAL-Chips/Antrag/TAL-reperoires/effectors_bls256.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        System.out.println("MAFF:");
        TALERepertoires.printStatistics(maff);
        System.out.println("KACC:");
        TALERepertoires.printStatistics(kacc);
        System.out.println("PXO99:");
        TALERepertoires.printStatistics(pxo);
        System.out.println("BLS256");
        TALERepertoires.printStatistics(bls);
        DataSet all = DataSet.union(maff, kacc, pxo, bls);
        int i = 0;
        while (i < all.getNumberOfElements()) {
            System.out.print(String.valueOf(i > 0 ? "\t" : "") + all.getElementAt(i).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue());
            ++i;
        }
        System.out.println();
        i = 0;
        while (i < all.getNumberOfElements()) {
            System.out.print(all.getElementAt(i).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue());
            int j = 0;
            while (j < all.getNumberOfElements()) {
                System.out.print("\n" + all.getElementAt(i).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue());
                System.out.println("<->" + all.getElementAt(j).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue());
                double cost = TALERepertoires.getAverageNumberOfMismatches(all.getElementAt(i), all.getElementAt(j));
                System.out.print("\t" + cost);
                ++j;
            }
            System.out.println();
            ++i;
        }
    }

    private static void printStatistics(DataSet data) {
        System.out.println("number of TALES: " + data.getNumberOfElements());
        int i = 0;
        while (i < data.getNumberOfElements()) {
            System.out.println(data.getElementAt(i).getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue() + "\t" + data.getElementAt(i).getLength());
            ++i;
        }
    }
}

