/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.algorithms.alignment.Alignment;
import de.jstacs.algorithms.alignment.PairwiseStringAlignment;
import de.jstacs.algorithms.alignment.cost.SimpleCosts;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.SparseStringExtractor;
import java.util.LinkedList;

public class TestAlignment {
    public static void main(String[] args) throws Exception {
        AlphabetContainer con = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, "A", "C", "G", "T", "N", "R", "W"));
        DataSet ds = new DataSet(con, new SparseStringExtractor("/Users/dev/Desktop/Ath_Aly/new/promoters_500TSS100.fa", '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()));
        int i = 0;
        while (i < ds.getNumberOfElements()) {
            Sequence temp;
            Sequence seq1 = ds.getElementAt(i);
            Sequence seq2 = ds.getElementAt(i + 1);
            if (seq1.getLength() > 600) {
                temp = seq1.getSubSequence(0, 600);
                seq1 = temp.annotate(false, seq1.getAnnotation());
            }
            if (seq2.getLength() > 600) {
                temp = seq2.getSubSequence(0, 600);
                seq2 = temp.annotate(false, seq2.getAnnotation());
            }
            String id1 = (String)seq1.getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue();
            String id2 = (String)seq2.getSequenceAnnotationByType("unparsed comment line", 0).getResultAt(0).getValue();
            LinkedList<Sequence> list1 = new LinkedList<Sequence>();
            list1.add(seq1);
            LinkedList<Sequence> list2 = new LinkedList<Sequence>();
            list2.add(seq2);
            Alignment al = new Alignment(Alignment.AlignmentType.LOCAL, new SimpleCosts(-1.0, 3.0, 2.0));
            int firstNum = -1;
            int firstNumMM = -1;
            double firstScore = Double.NaN;
            int firstLength = -1;
            int sumNum = 0;
            int sumNumMM = 0;
            double sumScore = 0.0;
            int sumLength = 0;
            while (list1.size() > 0) {
                seq1 = (Sequence)list1.removeFirst();
                PairwiseStringAlignment psa = al.getAlignment(seq1, seq2 = (Sequence)list2.removeFirst());
                if (!(psa.getCost() < -10.0)) continue;
                String str1 = seq1.toString();
                String str2 = seq2.toString();
                String al1 = psa.getAlignedString(0).replaceAll("-", "");
                String al2 = psa.getAlignedString(1).replaceAll("-", "");
                int idx1 = str1.indexOf(al1);
                int idx2 = str2.indexOf(al2);
                if (idx1 > 0 && idx2 > 0) {
                    list1.add(seq1.getSubSequence(0, idx1));
                    list2.add(seq2.getSubSequence(0, idx2));
                }
                if (idx1 + al1.length() < seq1.getLength() && idx2 + al2.length() < seq2.getLength()) {
                    list1.add(seq1.getSubSequence(idx1 + al1.length(), seq1.getLength() - (idx1 + al1.length())));
                    list2.add(seq2.getSubSequence(idx2 + al2.length(), seq2.getLength() - (idx2 + al2.length())));
                }
                al1 = psa.getAlignedString(0);
                al2 = psa.getAlignedString(1);
                int count = 0;
                int countMM = 0;
                int j = 0;
                while (j < al1.length()) {
                    if (al1.charAt(j) == al2.charAt(j) && TestAlignment.isACGT(al1.charAt(j))) {
                        ++count;
                    } else if (TestAlignment.isACGT(al1.charAt(j)) && TestAlignment.isACGT(al2.charAt(j))) {
                        ++countMM;
                    }
                    ++j;
                }
                if (Double.isNaN(firstScore)) {
                    firstNum = count;
                    firstNumMM = countMM;
                    firstScore = psa.getCost();
                    firstLength = psa.getLength();
                }
                sumNum += count;
                sumNumMM += countMM;
                sumScore += psa.getCost();
                sumLength += psa.getLength();
            }
            System.out.println(String.valueOf(id1) + "\t" + id2 + "\t" + firstNum + "\t" + firstNumMM + "\t" + firstScore + "\t" + firstLength + "\t" + sumNum + "\t" + sumNumMM + "\t" + sumScore + "\t" + sumLength);
            i += 2;
        }
    }

    private static boolean isACGT(char charAt) {
        return (charAt = Character.toLowerCase(charAt)) == 'a' || charAt == 'c' || charAt == 'g' || charAt == 't';
    }
}

