/*
 * Decompiled with CFR 0.152.
 */
package de.jstacs;

import de.jstacs.AnnotatedEntity;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;

public class AnnotatedEntityList<T extends AnnotatedEntity> {
    private ArrayList<T> entityList;
    private HashMap<String, T> entities;

    public AnnotatedEntityList() {
        this(10);
    }

    public AnnotatedEntityList(int initialCapacity) {
        this.entityList = new ArrayList(initialCapacity);
        this.entities = new HashMap(initialCapacity);
    }

    public void set(int idx, T entity) {
        String name = ((AnnotatedEntity)this.entityList.get(idx)).getName();
        this.entities.remove(name);
        this.entityList.set(idx, entity);
        this.entities.put(((AnnotatedEntity)entity).getName(), entity);
    }

    public T remove(int idx) {
        AnnotatedEntity p = (AnnotatedEntity)this.entityList.remove(idx);
        this.entities.remove(p.getName());
        return (T)p;
    }

    public void add(int idx, T entity) {
        if (this.entities.containsKey(((AnnotatedEntity)entity).getName())) {
            throw new IllegalArgumentException("The name \"" + ((AnnotatedEntity)entity).getName() + "\" is already contained.");
        }
        this.entityList.add(idx, entity);
        this.entities.put(((AnnotatedEntity)entity).getName(), entity);
    }

    public void add(T ... entities) {
        int i = 0;
        while (i < entities.length) {
            if (this.entities.containsKey(((AnnotatedEntity)entities[i]).getName())) {
                throw new IllegalArgumentException("The name \"" + ((AnnotatedEntity)entities[i]).getName() + "\" is already contained.");
            }
            this.entityList.add(entities[i]);
            this.entities.put(((AnnotatedEntity)entities[i]).getName(), entities[i]);
            ++i;
        }
    }

    public void addAll(Collection<? extends T> entities) {
        Iterator<T> it = entities.iterator();
        while (it.hasNext()) {
            this.add(new AnnotatedEntity[]{(AnnotatedEntity)it.next()});
        }
    }

    public T get(int index) {
        return (T)((AnnotatedEntity)this.entityList.get(index));
    }

    public T get(String name) {
        return (T)((AnnotatedEntity)this.entities.get(name));
    }

    public int size() {
        return this.entityList.size();
    }

    public String[] getNames() {
        String[] names = new String[this.entityList.size()];
        int i = 0;
        while (i < names.length) {
            names[i] = ((AnnotatedEntity)this.entityList.get(i)).getName();
            ++i;
        }
        return names;
    }

    public <E extends T> E[] toArray(E[] ar) {
        return (AnnotatedEntity[])this.entityList.toArray(ar);
    }
}

