/*
 * Decompiled with CFR 0.152.
 */
package de.jtem.numericalMethods.algebra.linear;

public final class VectorOperations {
    private VectorOperations() {
    }

    public static final int times(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            n2 += nArray[i] * nArray2[i];
        }
        return n2;
    }

    public static final double dot(double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray3[i] * dArray[i] + dArray4[i] * dArray2[i];
        }
        return d;
    }

    public static final double times(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray2[i];
        }
        return d;
    }

    public static final double times(int[] nArray, double[] dArray) {
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)nArray[i] * dArray[i];
        }
        return d;
    }

    public static final double times(double[] dArray, int[] nArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * (double)nArray[i];
        }
        return d;
    }

    public static final void times(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i] * n;
        }
    }

    public static final void times(double[] dArray, double d, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] * d;
        }
    }

    public static final void times(int[] nArray, double d, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)nArray[i] * d;
        }
    }

    public static final void times(double[] dArray, double[] dArray2, double d, double d2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d3 = dArray[i];
            double d4 = dArray2[i];
            dArray3[i] = d3 * d - d4 * d2;
            dArray4[i] = d3 * d2 + d4 * d;
        }
    }

    public static final void divide(double[] dArray, double[] dArray2, double d, double d2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        double d3 = d * d + d2 * d2;
        for (int i = 0; i < n; ++i) {
            double d4 = dArray[i];
            double d5 = dArray2[i];
            dArray3[i] = (d4 * d + d5 * d2) / d3;
            dArray4[i] = (d5 * d - d4 * d2) / d3;
        }
    }

    public static final void divide(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i] / n;
        }
    }

    public static final void divide(int n, int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = n / nArray[i];
        }
    }

    public static final void divide(double d, int[] nArray, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d / (double)nArray[i];
        }
    }

    public static final void divide(double d, double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = d / dArray[i];
        }
    }

    public static final void divide(double d, double[] dArray, double[] dArray2, double[] dArray3, double[] dArray4) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            double d2 = dArray[i];
            double d3 = dArray2[i];
            double d4 = d2 * d2 + d3 * d3;
            if (d4 == 0.0) {
                dArray3[i] = d / d4;
                dArray4[i] = 0.0;
                continue;
            }
            dArray3[i] = d * d2 / d4;
            dArray4[i] = -d * d3 / d4;
        }
    }

    public static final void divide(double[] dArray, double d, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] / d;
        }
    }

    public static final void divide(int[] nArray, double d, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = (double)nArray[i] / d;
        }
    }

    public static final void plus(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[i] + nArray2[i];
        }
    }

    public static final void plus(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] + dArray2[i];
        }
    }

    public static final void plus(int[] nArray, double[] dArray, double[] dArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (double)nArray[i] + dArray[i];
        }
    }

    public static final void plus(double[] dArray, int[] nArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] + (double)nArray[i];
        }
    }

    public static final void plus(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i] + n;
        }
    }

    public static final void plus(double[] dArray, double d, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] + d;
        }
    }

    public static final void minus(int[] nArray, int[] nArray2, int[] nArray3) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray3[i] = nArray[i] - nArray2[i];
        }
    }

    public static final void minus(double[] dArray, double[] dArray2, double[] dArray3) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray3[i] = dArray[i] - dArray2[i];
        }
    }

    public static final void minus(int[] nArray, double[] dArray, double[] dArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = (double)nArray[i] - dArray[i];
        }
    }

    public static final void minus(double[] dArray, int[] nArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] - (double)nArray[i];
        }
    }

    public static final void minus(int[] nArray, int n, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = nArray[i] - n;
        }
    }

    public static final void minus(int n, int[] nArray, int[] nArray2) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray2[i] = n - nArray[i];
        }
    }

    public static final void minus(double[] dArray, double d, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = dArray[i] - d;
        }
    }

    public static final void minus(double d, double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = d - dArray[i];
        }
    }

    static final void assign(int[] nArray, int[] nArray2) {
        System.arraycopy(nArray, 0, nArray2, 0, nArray.length);
    }

    public static final void assign(double[] dArray, double[] dArray2) {
        System.arraycopy(dArray, 0, dArray2, 0, dArray.length);
    }

    public static final void assign(int[] nArray, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = nArray[i];
        }
    }

    public static final void assign(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = n;
        }
    }

    public static final void assign(double[] dArray, double d) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = d;
        }
    }

    public static final void assignZero(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = 0.0;
        }
    }

    public static final void assignZero(int[] nArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = 0;
        }
    }

    static final int[] copy(int[] nArray) {
        return (int[])nArray.clone();
    }

    public static final double[] copy(double[] dArray) {
        return (double[])dArray.clone();
    }

    public static final void round(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.floor(dArray[i] + 0.5);
        }
    }

    public static final void floor(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = Math.floor(dArray[i]);
        }
    }

    public static final void round(double[] dArray, int[] nArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.floor(dArray[i] + 0.5);
        }
    }

    public static final void floor(double[] dArray, int[] nArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            nArray[i] = (int)Math.floor(dArray[i]);
        }
    }

    public static final void neg(int[] nArray, int[] nArray2) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            nArray2[i] = -nArray[i];
        }
    }

    public static final void neg(double[] dArray, double[] dArray2) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray2[i] = -dArray[i];
        }
    }

    public static final void neg(int[] nArray, double[] dArray) {
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = -nArray[i];
        }
    }

    public static double normSqr(double[] dArray) {
        int n = dArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += dArray[i] * dArray[i];
        }
        return d;
    }

    public static double normSqr(int[] nArray) {
        int n = nArray.length;
        double d = 0.0;
        for (int i = 0; i < n; ++i) {
            d += (double)(nArray[i] * nArray[i]);
        }
        return d;
    }

    public static final void checkShape(double[] dArray, double[] dArray2) {
        if (dArray2.length != dArray.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(int[] nArray, int[] nArray2) {
        if (nArray2.length != nArray.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(double[] dArray, int[] nArray) {
        if (nArray.length != dArray.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void checkShape(int[] nArray, double[] dArray) {
        if (dArray.length != nArray.length) {
            throw new IllegalArgumentException("different vec sizes");
        }
    }

    public static final void random(double[] dArray) {
        int n = dArray.length;
        for (int i = 0; i < n; ++i) {
            dArray[i] = 2.0 * Math.random() - 1.0;
        }
    }

    public static final void random(int[] nArray, int n) {
        int n2 = nArray.length;
        for (int i = 0; i < n2; ++i) {
            nArray[i] = (int)Math.random() * n;
        }
    }
}

