/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont;

import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.FileManager;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.io.File;
import java.util.LinkedList;
import projects.dimont.DimontPredictorParameterSet;
import projects.dimont.Interpolation;
import projects.dimont.ThresholdedStrandChIPper;

public class DimontPredictorCY {
    public static void main(String[] args) throws Exception {
        ParameterSetTagger cParams = new ParameterSetTagger(DimontPredictorParameterSet.PREFIX, new DimontPredictorParameterSet());
        cParams.fillParameters("=", args);
        System.err.println("parameters:");
        System.err.println(cParams);
        System.err.println("_________________________________");
        if (!cParams.hasDefaultOrIsSet()) {
            System.err.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String home = cParams.getValueFromTag("home", String.class);
        String fgData = String.valueOf(home) + File.separator + cParams.getValueFromTag("data", String.class);
        String infix = cParams.getValueFromTag("infix", String.class);
        String value = cParams.getValueFromTag("value", String.class);
        String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
        String chipper = cParams.getValueFromTag("dimont", String.class);
        double pval = cParams.getValueFromTag("p-value", Double.class);
        GenDisMixClassifier cl = new GenDisMixClassifier(FileManager.readFile(chipper));
        ThresholdedStrandChIPper model = (ThresholdedStrandChIPper)cl.getDifferentiableSequenceScore(0);
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        DimontPredictorCY.run(SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, fgData, parser), value, weightingFactor, model, pval);
    }

    public static void run(DataSet data, String value, String weightingFactor, ThresholdedStrandChIPper model, double pval) throws Exception {
        double wf;
        double[][] weights = new double[2][data.getNumberOfElements()];
        double[] raw = (double[])weights[0].clone();
        int j = 0;
        while (j < weights[0].length) {
            Sequence seq = data.getElementAt(j);
            SequenceAnnotation[] seqAn = seq.getAnnotation();
            int i = 0;
            while (i < seqAn.length) {
                if (seqAn[i].getType().equals(value)) {
                    raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                }
                ++i;
            }
            ++j;
        }
        if (weightingFactor.endsWith("sd")) {
            double h = Double.parseDouble(weightingFactor.substring(0, weightingFactor.length() - 2));
            double meanRaw = ToolBox.sum(raw) / (double)raw.length;
            double sdRaw = 0.0;
            int i = 0;
            while (i < raw.length) {
                sdRaw += (raw[i] - meanRaw) * (raw[i] - meanRaw);
                ++i;
            }
            sdRaw = Math.sqrt(sdRaw / (double)raw.length);
            h = meanRaw + h * sdRaw;
            double anz = 0.0;
            int i2 = 0;
            while (i2 < raw.length) {
                if (raw[i2] >= h) {
                    anz += 1.0;
                }
                ++i2;
            }
            anz = Math.max(50.0, anz);
            wf = anz / (double)raw.length;
        } else {
            wf = Double.parseDouble(weightingFactor);
        }
        weights[0] = Interpolation.getWeight(data, raw, wf, Interpolation.RANK_LOG);
        weights[1] = Interpolation.getBgWeight(weights[0]);
        SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(model, data, weights[1], pval);
        Pair<double[][][], int[][]> pair = smof.getPWMAndPositions(0, data, weights[0], 0, 0);
        DimontPredictorCY.printResult(data, weights[0], pair, model.getMotifLength(0), 0);
    }

    public static void printResult(DataSet data, double[] weights, Pair<double[][][], int[][]> pair, int motifLength, int motifIndex) throws Exception {
        SplitSequenceAnnotationParser pars = new SplitSequenceAnnotationParser(":", ";");
        LinkedList set = new LinkedList();
        int[][] pos = pair.getSecondElement();
        double[][] pvals = pair.getFirstElement()[1];
        int numFound = 0;
        int numNot = 0;
        int i = 0;
        while (i < pos.length) {
            Sequence seq = data.getElementAt(i);
            double w = weights[i];
            String id = seq.getSequenceAnnotationByType("id", 0).getIdentifier();
            if (w == 1.0) {
                System.out.print(id);
                int j = 0;
                while (j < pos[i].length) {
                    System.out.print("\t" + pos[i][j]);
                    ++j;
                }
                System.out.println();
            } else if (pos[i].length == 0) {
                ++numNot;
            } else {
                ++numFound;
            }
            ++i;
        }
    }
}

