/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont;

import de.jstacs.data.DataSet;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.LinkedList;

public enum Interpolation {
    LOG_LINEAR,
    LINEAR_jens,
    LINEAR,
    RANK_OUTLIER,
    RANK_OUTLIER_REPEATED,
    RANK_LOG,
    RANK_SIGMOID,
    SIGMOID,
    PERCENTILE_LOGISTIC,
    RANK_SELEX;


    public static double[] getWeight(DataSet data, double[] intensa, double aPrioriWeight, Interpolation interpol) throws Exception {
        double[] weights = new double[intensa.length];
        double[] help = (double[])intensa.clone();
        Arrays.sort(help);
        double min = help[0];
        double max = help[help.length - 1];
        double thresh = help[(int)Math.ceil((1.0 - aPrioriWeight) * (double)help.length)];
        double c = 1.0E-10;
        double m = 0.0;
        int idx = -1;
        switch (interpol) {
            case PERCENTILE_LOGISTIC: {
                double p1 = 0.1;
                double p2 = 0.9;
                double x1 = ToolBox.percentile(intensa, p1);
                double x2 = ToolBox.percentile(intensa, p2);
                double a = (Math.log(p1 / (1.0 - p1)) - Math.log(p2 / (1.0 - p2))) / (x1 - x2);
                double b = Math.log(p1 / (1.0 - p1)) - a * x1;
                int i = 0;
                while (i < weights.length) {
                    weights[i] = 1.0 / (1.0 + Math.exp(-(a * intensa[i] + b)));
                    ++i;
                }
                break;
            }
            case LOG_LINEAR: {
                min = Math.log(min);
                max = Math.log(max) - min;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = aPrioriWeight + (1.0 - 2.0 * aPrioriWeight) * (Math.log(intensa[i]) - min) / max;
                    ++i;
                }
                break;
            }
            case LINEAR_jens: {
                max -= min;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = (intensa[i] - min) / max;
                    ++i;
                }
                break;
            }
            case LINEAR: {
                double distAbove = max - thresh;
                double distBelow = thresh - min;
                int i = 0;
                while (i < intensa.length) {
                    double temp;
                    if (intensa[i] >= thresh) {
                        temp = intensa[i] - thresh;
                        weights[i] = 0.5 + 0.5 * temp / distAbove;
                    } else {
                        temp = thresh - intensa[i];
                        weights[i] = 0.5 - 0.5 * temp / distBelow;
                    }
                    ++i;
                }
                break;
            }
            case RANK_OUTLIER: 
            case RANK_OUTLIER_REPEATED: {
                int n2;
                boolean repeat = interpol == RANK_OUTLIER_REPEATED;
                int idx1 = 0;
                int idx2 = -1000;
                do {
                    int n1;
                    if (idx2 < 0) {
                        n1 = 0;
                        n2 = help.length;
                    } else {
                        n1 = idx1;
                        n2 = idx2;
                    }
                    double q25 = help[n1 + (int)(0.25 * (double)(n2 - n1))];
                    double q75 = help[n1 + (int)(0.75 * (double)(n2 - n1))];
                    thresh = q75 + 1.5 * (q75 - q25);
                    idx2 = Arrays.binarySearch(help, thresh);
                    if (idx2 >= 0) continue;
                    idx2 = -idx2 + 1;
                } while (repeat && idx2 < n2);
                aPrioriWeight = 1.0 - (double)idx2 / (double)intensa.length;
                System.out.println(aPrioriWeight);
            }
            case RANK_LOG: {
                int[] rank = ToolBox.rank(intensa, ToolBox.TiedRanks.SPORTS);
                int i = 0;
                while (i < intensa.length) {
                    if (m <= (double)rank[i]) {
                        m = rank[i];
                    }
                    ++i;
                }
                i = 0;
                while (i < intensa.length) {
                    double h = (double)rank[i] / m;
                    weights[i] = 1.0 / (1.0 + h / (1.0 - h) * (1.0 - aPrioriWeight) / aPrioriWeight);
                    ++i;
                }
                break;
            }
            case RANK_SELEX: {
                double[] weightMap = Interpolation.getWeightMapping(data, intensa);
                int i = 0;
                while (i < weights.length) {
                    int cyc = (int)intensa[i];
                    weights[i] = weightMap[cyc];
                    ++i;
                }
                break;
            }
            case SIGMOID: {
                double b1 = (Math.log(c) - Math.log1p(-c)) / (1.0 - max / thresh);
                double a1 = b1 / thresh;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = 1.0 / (1.0 + Math.exp(-a1 * intensa[i] + b1));
                    ++i;
                }
                break;
            }
            case RANK_SIGMOID: {
                int[] rank = ToolBox.rank(intensa, true);
                int[] rankSorted = (int[])rank.clone();
                Arrays.sort(rankSorted);
                min = -rankSorted[rankSorted.length - 1];
                max = -rankSorted[0];
                thresh = -rankSorted[(int)Math.floor(aPrioriWeight * (double)rankSorted.length)];
                System.out.println(String.valueOf(min) + " " + max + " " + thresh);
                double b1 = (Math.log1p(-c) - Math.log(c)) / (1.0 - min / thresh);
                double a1 = b1 / thresh;
                int i = 0;
                while (i < intensa.length) {
                    weights[i] = 1.0 / (1.0 + Math.exp(-a1 * (double)(-rank[i]) + b1));
                    ++i;
                }
                break;
            }
            default: {
                throw new RuntimeException();
            }
        }
        return weights;
    }

    private static double[] getForegroundSelexWeight(DataSet seqs, double[] signal, double[] weights) throws Exception {
        int max = (int)ToolBox.max(signal);
        System.out.println("max: " + max);
        double v = 0.0;
        while (Math.pow(v + 1.0, v) < (double)max) {
            v += 1.0;
        }
        System.out.println(String.valueOf(v) + ": " + Math.pow(v + 1.0, v));
        double[] pows = new double[(int)v];
        int i = 0;
        while (i < pows.length) {
            pows[i] = Math.pow(v, i);
            ++i;
        }
        LinkedList[] seqMap = new LinkedList[(int)v];
        int i2 = 0;
        while (i2 < seqMap.length) {
            seqMap[i2] = new LinkedList();
            ++i2;
        }
        int[] idxs = new int[seqs.getNumberOfElements()];
        Arrays.fill(idxs, -1);
        int i3 = 0;
        while (i3 < seqs.getNumberOfElements()) {
            double sig = signal[i3];
            int j = seqMap.length - 1;
            while (j >= 0) {
                if (pows[j] <= sig) {
                    int idx = j;
                    if (idxs[i3] < 0) {
                        idxs[i3] = idx;
                    }
                    seqMap[idx].add(seqs.getElementAt(i3));
                    sig -= pows[j];
                }
                --j;
            }
            ++i3;
        }
        double mi = Double.POSITIVE_INFINITY;
        double ma = Double.NEGATIVE_INFINITY;
        double[] weightMap = new double[(int)v];
        int i4 = 0;
        while (i4 < seqMap.length) {
            if (seqMap[i4].size() > 0) {
                DataSet.WeightedDataSetFactory fac = new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.SORT_BY_WEIGHTS, new DataSet("", seqMap[i4]), null, 10);
                double sum = fac.getSumOfWeights();
                System.out.println("num " + i4 + ": " + fac.getNumberOfElements() + ", " + fac.getSumOfWeights());
                double k = 0.0;
                int j = 0;
                while ((double)j < (double)fac.getNumberOfElements() * 0.01) {
                    k += fac.getWeight(j);
                    ++j;
                }
                weightMap[i4] = k / sum;
                if (mi > weightMap[i4]) {
                    mi = weightMap[i4];
                }
                if (ma < weightMap[i4]) {
                    ma = weightMap[i4];
                }
            }
            ++i4;
        }
        System.out.println(Arrays.toString(weightMap));
        i4 = 0;
        while (i4 < weightMap.length) {
            weightMap[i4] = weightMap[i4] < mi ? 0.0 : (weightMap[i4] - mi) / (ma - mi) * 0.9 + 0.05;
            ++i4;
        }
        System.out.println(Arrays.toString(weightMap));
        i4 = 0;
        while (i4 < weights.length) {
            weights[i4] = weightMap[idxs[i4]];
            ++i4;
        }
        return weights;
    }

    private static double[] getWeightMapping(DataSet seqs, double[] signal) throws Exception {
        int max = (int)ToolBox.max(signal);
        double[] weightMap = new double[max + 1];
        LinkedList[] seqMap = new LinkedList[max + 1];
        int i = 0;
        while (i < seqMap.length) {
            seqMap[i] = new LinkedList();
            ++i;
        }
        i = 0;
        while (i < seqs.getNumberOfElements()) {
            int idx = (int)signal[i];
            seqMap[idx].add(seqs.getElementAt(i));
            ++i;
        }
        double mi = Double.POSITIVE_INFINITY;
        double ma = Double.NEGATIVE_INFINITY;
        double[] ens = new double[max + 1];
        double[] rels = new double[max + 1];
        int i2 = 0;
        while (i2 < seqMap.length) {
            if (seqMap[i2].size() > 0) {
                DataSet.WeightedDataSetFactory fac = new DataSet.WeightedDataSetFactory(DataSet.WeightedDataSetFactory.SortOperation.SORT_BY_WEIGHTS, new DataSet("", seqMap[i2]), null, 10);
                double sum = fac.getSumOfWeights();
                System.out.println("num " + i2 + ": " + fac.getNumberOfElements() + ", " + fac.getSumOfWeights());
                double k = 0.0;
                int j = 0;
                while ((double)j < (double)fac.getNumberOfElements() * 0.01) {
                    k += fac.getWeight(j);
                    ++j;
                }
                j = 0;
                while (j < fac.getNumberOfElements()) {
                    int n = i2;
                    ens[n] = ens[n] + fac.getWeight(j) / sum * Math.log(fac.getWeight(j) / sum);
                    ++j;
                }
                weightMap[i2] = k / sum;
                k = 0.0;
                j = 0;
                while (k < sum * 0.01) {
                    k += fac.getWeight(j);
                    ++j;
                }
                rels[i2] = (double)j / (double)fac.getNumberOfElements();
                if (mi > weightMap[i2]) {
                    mi = weightMap[i2];
                }
                if (ma < weightMap[i2]) {
                    ma = weightMap[i2];
                }
            }
            ++i2;
        }
        System.out.println(Arrays.toString(ens));
        System.out.println(Arrays.toString(rels));
        System.out.println(Arrays.toString(weightMap));
        i2 = 0;
        while (i2 < weightMap.length) {
            weightMap[i2] = weightMap[i2] < mi ? 0.0 : (weightMap[i2] - mi) / (ma - mi) * 0.9 + 0.05;
            ++i2;
        }
        System.out.println(Arrays.toString(weightMap));
        return weightMap;
    }

    public static double[] getBgWeight(double[] weights) {
        double[] bgWeights = new double[weights.length];
        int i = 0;
        while (i < bgWeights.length) {
            bgWeights[i] = 1.0 - weights[i];
            ++i;
        }
        return bgWeights;
    }
}

