/*
 * Decompiled with CFR 0.152.
 */
package projects.dimont;

import de.jstacs.Storable;
import de.jstacs.algorithms.optimization.ConstantStartDistance;
import de.jstacs.algorithms.optimization.NegativeDifferentiableFunction;
import de.jstacs.algorithms.optimization.Optimizer;
import de.jstacs.algorithms.optimization.termination.CombinedCondition;
import de.jstacs.algorithms.optimization.termination.IterationCondition;
import de.jstacs.algorithms.optimization.termination.MultipleIterationsCondition;
import de.jstacs.algorithms.optimization.termination.SmallDifferenceOfFunctionEvaluationsCondition;
import de.jstacs.classifiers.differentiableSequenceScoreBased.AbstractMultiThreadedOptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LogGenDisMixFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.EmptyDataSetException;
import de.jstacs.data.WrongAlphabetException;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.ArbitraryFloatSequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.SparseSequence;
import de.jstacs.data.sequences.WrongSequenceTypeException;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.SequenceAnnotation;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.ArrayHandler;
import de.jstacs.io.FileManager;
import de.jstacs.motifDiscovery.MotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscoverer;
import de.jstacs.motifDiscovery.MutableMotifDiscovererToolbox;
import de.jstacs.motifDiscovery.SignificantMotifOccurrencesFinder;
import de.jstacs.parameters.ParameterSetTagger;
import de.jstacs.results.CategoricalResult;
import de.jstacs.results.ImageResult;
import de.jstacs.results.ListResult;
import de.jstacs.results.NumericalResult;
import de.jstacs.results.Result;
import de.jstacs.results.ResultSet;
import de.jstacs.results.StorableResult;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.MarkovModelDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.UniformHomogeneousDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.localMixture.SparseLocalInhomogeneousMixtureDiffSM;
import de.jstacs.utils.ComparableElement;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.PFMComparator;
import de.jstacs.utils.Pair;
import de.jstacs.utils.SafeOutputStream;
import de.jstacs.utils.SeqLogoPlotter;
import de.jstacs.utils.ToolBox;
import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import projects.dimont.AbstractSingleMotifChIPper;
import projects.dimont.HeuristicOneDataSetLogGenDisMixFunction;
import projects.dimont.Interpolation;
import projects.dimont.ThresholdedStrandChIPper;
import projects.slim.SlimDimontParameterSet;

public class SlimDimont4 {
    private static final double ALPHA = 0.001;

    public static void main(String[] args) throws Exception {
        ParameterSetTagger cParams = new ParameterSetTagger(SlimDimontParameterSet.PREFIX, new SlimDimontParameterSet());
        cParams.fillParameters("=", args);
        System.out.println("parameters:");
        System.out.println(cParams);
        System.out.println("_________________________________");
        if (!cParams.hasDefaultOrIsSet()) {
            System.out.println("Some of the required parameters are not specified.");
            System.exit(1);
        }
        String home = cParams.getValueFromTag("home", String.class);
        String fgData = String.valueOf(home) + File.separator + cParams.getValueFromTag("data", String.class);
        String infix = cParams.getValueFromTag("infix", String.class);
        int motifLength = cParams.getValueFromTag("motifWidth", Integer.class);
        int restarts = cParams.getValueFromTag("starts", Integer.class);
        int fgOrder = cParams.getValueFromTag("motifOrder", Integer.class);
        int bgOrder = cParams.getValueFromTag("bgOrder", Integer.class);
        String position = cParams.getValueFromTag("position", String.class);
        String value = cParams.getValueFromTag("value", String.class);
        String weightingFactor = cParams.getValueFromTag("weightingFactor", String.class);
        double ess = cParams.getValueFromTag("ess", Double.class);
        boolean delete = cParams.getValueFromTag("delete", Boolean.class);
        int threads = cParams.isSet("threads") ? cParams.getValueFromTag("threads", Integer.class) : AbstractMultiThreadedOptimizableFunction.getNumberOfAvailableProcessors();
        SplitSequenceAnnotationParser parser = new SplitSequenceAnnotationParser(":", ";");
        Result[][] res = SlimDimont4.run(SparseSequence.getDataSet((AlphabetContainer)DNAAlphabetContainer.SINGLETON, fgData, parser), motifLength, restarts, fgOrder, bgOrder, position, value, weightingFactor, ess, delete, threads, SafeOutputStream.getSafeOutputStream(System.out));
        int i = 0;
        while (i < res.length) {
            StorableResult sr = (StorableResult)res[i][0];
            FileManager.writeFile(new File(String.valueOf(home) + File.separator + infix + "-model-" + (i + 1) + ".xml"), (CharSequence)sr.getValue());
            System.out.println("+++++++++++++++++++++++++++++++++++++++++++++\nMotif model " + (i + 1) + ":");
            System.out.println(((GenDisMixClassifier)sr.getResultInstance()).getDifferentiableSequenceScore(0));
            ListResult lr = (ListResult)res[i][1];
            FileManager.writeFile(new File(String.valueOf(home) + File.separator + infix + "-predictions-" + (i + 1) + ".txt"), (CharSequence)lr.toString());
            ++i;
        }
    }

    public static Result[][] run(DataSet fgData, int motifLength, int restarts, int fgOrder, int bgOrder, String position, String value, String weightingFactor, double ess, boolean delete, int threads, SafeOutputStream out) throws Exception {
        double wf;
        double sd = 75.0;
        double filterThreshold = 0.3;
        double filterThresholdEnd = 0.3;
        DNAAlphabetContainer con = DNAAlphabetContainer.SINGLETON;
        boolean free = false;
        DataSet[] data = new DataSet[]{fgData};
        Sequence[] annotated = new Sequence[data[0].getNumberOfElements()];
        Object weights = new double[2][data[0].getNumberOfElements()];
        double[] raw = (double[])weights[0].clone();
        double[] mean = new double[weights[0].length];
        Arrays.fill(mean, Double.NaN);
        int j = 0;
        while (j < weights[0].length) {
            annotated[j] = data[0].getElementAt(j);
            SequenceAnnotation[] seqAn = annotated[j].getAnnotation();
            mean[j] = Double.NaN;
            int i = 0;
            while (i < seqAn.length) {
                if (seqAn[i].getType().equals(value)) {
                    raw[j] = Double.parseDouble(seqAn[i].getIdentifier());
                } else if (seqAn[i].getType().equals(position)) {
                    mean[j] = Double.parseDouble(seqAn[i].getIdentifier());
                }
                ++i;
            }
            ++j;
        }
        if (weightingFactor.endsWith("sd")) {
            double h = Double.parseDouble(weightingFactor.substring(0, weightingFactor.length() - 2));
            double meanRaw = ToolBox.sum(raw) / (double)raw.length;
            double sdRaw = 0.0;
            int i = 0;
            while (i < raw.length) {
                sdRaw += (raw[i] - meanRaw) * (raw[i] - meanRaw);
                ++i;
            }
            sdRaw = Math.sqrt(sdRaw / (double)raw.length);
            h = meanRaw + h * sdRaw;
            double anz = 0.0;
            int i2 = 0;
            while (i2 < raw.length) {
                if (raw[i2] >= h) {
                    anz += 1.0;
                }
                ++i2;
            }
            anz = Math.max(50.0, anz);
            wf = anz / (double)raw.length;
        } else {
            wf = Double.parseDouble(weightingFactor);
        }
        weights[0] = Interpolation.getWeight(data[0], raw, wf, Interpolation.RANK_LOG);
        weights[1] = Interpolation.getBgWeight(weights[0]);
        boolean[][] allowed = new boolean[annotated.length][];
        int i = 0;
        while (i < annotated.length) {
            allowed[i] = new boolean[annotated[i].getLength()];
            Arrays.fill(allowed[i], true);
            ++i;
        }
        data[0] = SlimDimont4.annotate(annotated, weights, mean, sd, allowed);
        DataSet completeData = data[0];
        double[][] completeWeight = new double[][]{weights[0], weights[1]};
        MarkovModelDiffSM motif = null;
        motif = fgOrder >= 0 ? new MarkovModelDiffSM((AlphabetContainer)con, motifLength, ess, true, fgOrder, null) : new MarkovModelDiffSM((AlphabetContainer)con, motifLength, ess, true, 1, null);
        ThresholdedStrandChIPper fg = new ThresholdedStrandChIPper(1, 0.5, motif);
        fg.initializeFunctionRandomly(false);
        double fac = (1.0 - wf) / wf;
        DifferentiableStatisticalModel bg = SlimDimont4.getBgSF(con, bgOrder, ess * fac, data[0].getAverageElementLength());
        bg.initializeFunction(0, false, data, (double[][])weights);
        Cloneable[] score = new DifferentiableStatisticalModel[]{fg, bg};
        double[] beta = LearningPrinciple.getBeta(LearningPrinciple.MSP);
        LearningPrinciple initKey = beta[0] > 0.0 ? LearningPrinciple.MCL : LearningPrinciple.ML;
        HeuristicOneDataSetLogGenDisMixFunction initObjective = new HeuristicOneDataSetLogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, completeData, (double[][])completeWeight.clone(), (LogPrior)new CompositeLogPrior(), LearningPrinciple.getBeta(initKey), true, free);
        HeuristicOneDataSetLogGenDisMixFunction objective = new HeuristicOneDataSetLogGenDisMixFunction(threads, (DifferentiableSequenceScore[])score, data[0], (double[][])weights, (LogPrior)new CompositeLogPrior(), beta, true, free);
        NegativeDifferentiableFunction neg = new NegativeDifferentiableFunction(objective);
        double eps = 1.0E-4;
        CombinedCondition stop = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(100));
        ConstantStartDistance start = new ConstantStartDistance(1.0);
        Object params = null;
        double[][] pwm = null;
        double[] entropy = new double[motifLength];
        double[] kl = new double[motifLength];
        byte algo = 18;
        GenDisMixClassifierParameterSet genDisMixParams = new GenDisMixClassifierParameterSet(con, 0, algo, eps, eps * 0.1, 1.0, free, OptimizableFunction.KindOfParameter.PLUGIN, true, threads);
        objective.reset((DifferentiableSequenceScore[])score);
        DataSet smallData = null;
        Object smallWeight = new double[2][];
        double[] p = null;
        Pair<DataSet, double[][]> small = SlimDimont4.getSmallDataSets(completeWeight, annotated, 0.3, 1000);
        smallData = small.getFirstElement();
        smallWeight = small.getSecondElement();
        initObjective.setDataAndWeights(new DataSet[]{smallData}, (double[][])smallWeight);
        initObjective.reset((DifferentiableSequenceScore[])score);
        double percentKmers = 1.0;
        Object[] sortedPars = new ComparableElement[restarts];
        int numKmers = 0;
        if (percentKmers > 0.0) {
            int k = 7;
            ComparableElement<String, Double>[] array = SlimDimont4.getKmereSequenceStatistic(Math.max(50, (int)Math.ceil(percentKmers * (double)restarts)), k, smallData, smallWeight[0]);
            Object[] array2 = new ComparableElement[array.length];
            int a = 4;
            double d = 0.1 / (double)(a - 1);
            d = (1.0 - (double)a * d) / ((double)a * d);
            double h = d * motif.getESS();
            int z = 0;
            while (z < array.length) {
                ((AbstractSingleMotifChIPper)score[0]).initializeMotif(0, new DataSet("", Sequence.create(con, array[z].getElement())), new double[]{h});
                p = objective.getParameters(OptimizableFunction.KindOfParameter.PLUGIN);
                initObjective.reset((DifferentiableSequenceScore[])score);
                initObjective.resetHeuristics();
                double val = initObjective.evaluateFunction(p);
                array2[z] = new ComparableElement<double[], Double>(p, val);
                ++z;
            }
            Arrays.sort(array2);
            numKmers = Math.min(array2.length, (int)Math.ceil((double)restarts * percentKmers));
            z = 0;
            while (z < numKmers) {
                sortedPars[z] = array2[array2.length - 1 - z];
                ++z;
            }
        }
        if (numKmers != sortedPars.length) {
            MutableMotifDiscovererToolbox.InitMethodForDiffSM[] initMeth = new MutableMotifDiscovererToolbox.InitMethodForDiffSM[]{MutableMotifDiscovererToolbox.InitMethodForDiffSM.PLUG_IN, MutableMotifDiscovererToolbox.InitMethodForDiffSM.NOTHING};
            ComparableElement<double[], Double>[] sortedPars2 = MutableMotifDiscovererToolbox.getSortedInitialParameters((DifferentiableSequenceScore[])score, initMeth, initObjective, Math.max(100, restarts), SafeOutputStream.getSafeOutputStream(null), 0);
            int z = 0;
            while (z < sortedPars.length - numKmers) {
                sortedPars[numKmers + z] = sortedPars2[sortedPars2.length - 1 - z];
                ++z;
            }
            Arrays.sort(sortedPars);
        }
        CombinedCondition stop2 = new CombinedCondition(2, new MultipleIterationsCondition(5, new SmallDifferenceOfFunctionEvaluationsCondition(eps)), new IterationCondition(25));
        Object[] preOpt = new ComparableElement[restarts];
        int r = 0;
        while (r < restarts) {
            data[0] = smallData;
            weights = smallWeight;
            objective.setDataAndWeights(data, (double[][])weights);
            objective.resetHeuristics();
            out.writeln("-----------------------------------------\npre-optimization " + r);
            start.reset();
            p = (double[])((ComparableElement)sortedPars[sortedPars.length - 1 - r]).getElement();
            objective.setParams(p);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, null);
            data[0] = completeData;
            weights = completeWeight;
            objective.setDataAndWeights(data, (double[][])weights);
            preOpt[r] = new ComparableElement<double[], Double>(p, objective.evaluateFunction(p));
            out.writeln("model: " + ((AbstractSingleMotifChIPper)score[0]).getFunction(0));
            out.writeln("score: " + ((ComparableElement)preOpt[r]).getWeight());
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            ++r;
        }
        out.writeln("-----------------------------------------");
        Arrays.sort(preOpt);
        ArrayList<ComparableElement<double[], Double>> list = SlimDimont4.filter2((AbstractSingleMotifChIPper)score[0], preOpt, smallData, filterThreshold, motifLength, out);
        MutableMotifDiscoverer[] best = new MutableMotifDiscoverer[list.size()];
        Storable[] storables = new Storable[best.length];
        double[] opts = new double[best.length];
        Pair[] pairs = new Pair[best.length];
        DifferentiableStatisticalModel[] backup = (DifferentiableStatisticalModel[])ArrayHandler.clone((Cloneable[])score);
        int m = 0;
        while (m < best.length) {
            Pair<double[][][], int[][]> pair;
            out.writeln("+++++++++++++++++++++++++++++++++++++++++++++++++++\n\nfinalOpt " + m + " -----------------------------------------");
            if (fgOrder < 0) {
                score[0] = (DifferentiableStatisticalModel)backup[0].clone();
            }
            best[m] = (MutableMotifDiscoverer)score[0];
            int j2 = 0;
            while (j2 < best[m].getNumberOfMotifs()) {
                if (best[m].getMotifLength(j2) != motifLength) {
                    best[m].modifyMotif(j2, 0, motifLength - best[m].getMotifLength(j2));
                }
                ++j2;
            }
            ((AbstractSingleMotifChIPper)score[0]).reset();
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            objective.reset((DifferentiableSequenceScore[])score);
            objective.resetHeuristics();
            start.reset();
            p = list.get(m).getElement();
            objective.setParams(p);
            data[0] = SlimDimont4.annotate(annotated, weights, mean, sd, allowed);
            objective.setDataAndWeights(data, (double[][])weights);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, SafeOutputStream.getSafeOutputStream(null));
            if (fgOrder < 0) {
                SparseLocalInhomogeneousMixtureDiffSM slim = new SparseLocalInhomogeneousMixtureDiffSM(con, motifLength, -fgOrder, ess, false, 0.9, SparseLocalInhomogeneousMixtureDiffSM.PriorType.Complex_Mixture);
                SlimDimont4.replaceMotifModel(objective, (ThresholdedStrandChIPper)score[0], slim, completeData, completeWeight);
                objective.reset((DifferentiableSequenceScore[])score);
                objective.resetHeuristics();
                p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
            }
            objective.setDataAndWeights(data, (double[][])weights);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, SafeOutputStream.getSafeOutputStream(null));
            double[] sds = new double[1];
            SlimDimont4.heuristic((MutableMotifDiscoverer)score[0], completeData, completeWeight, objective, mean, sds, out);
            ((AbstractSingleMotifChIPper)score[0]).reset();
            double newSd = Math.sqrt(sds[0] * sd);
            if (Double.isNaN(newSd) || Double.isInfinite(newSd) || newSd <= 0.0) {
                out.writeln("Did not adjust sd to " + newSd + " using " + sds[0] + " and " + sd);
                newSd = sd;
            }
            data[0] = SlimDimont4.annotate(annotated, weights, mean, newSd, allowed);
            objective.setDataAndWeights(data, (double[][])weights);
            ((AbstractSingleMotifChIPper)score[0]).resetPositions();
            objective.reset((DifferentiableSequenceScore[])score);
            p = objective.getParameters(OptimizableFunction.KindOfParameter.LAST);
            objective.setParams(p);
            Optimizer.optimize(algo, neg, p, stop, eps * 0.1, start, SafeOutputStream.getSafeOutputStream(null));
            out.writeln("model: " + ((AbstractSingleMotifChIPper)score[0]).getFunction(0));
            best[m] = (MutableMotifDiscoverer)score[0].clone();
            opts[m] = objective.evaluateFunction(p);
            GenDisMixClassifier cl = new GenDisMixClassifier(genDisMixParams, (LogPrior)new CompositeLogPrior(), opts[m], LearningPrinciple.getBeta(LearningPrinciple.MSP), (DifferentiableStatisticalModel[])score);
            cl.setClassWeights(false, objective.getClassParams(p));
            storables[m] = cl;
            SignificantMotifOccurrencesFinder smof = new SignificantMotifOccurrencesFinder(best[m], completeData, completeWeight[1], 0.001);
            pairs[m] = pair = smof.getPWMAndPositions(0, completeData, completeWeight[0], 0, 0);
            if (delete && m + 1 < best.length) {
                SlimDimont4.delete(pair.getSecondElement(), allowed, motifLength);
            }
            ++m;
        }
        int[] o = ToolBox.rank(opts, ToolBox.TiedRanks.IN_ORDER);
        int[] index = new int[o.length];
        int i3 = 0;
        while (i3 < o.length) {
            index[o[i3]] = i3;
            ++i3;
        }
        boolean[] use = SlimDimont4.postFilter(best, index, smallData, filterThresholdEnd, motifLength);
        LinkedList<Result[]> results = new LinkedList<Result[]>();
        int m2 = 0;
        int n = 0;
        while (m2 < best.length) {
            if (use[m2]) {
                LinkedList<Result> result = new LinkedList<Result>();
                result.add(new StorableResult("Dimont " + (n + 1), "The Dimont classifier", storables[m2]));
                result.add(SlimDimont4.getListResult(fgData, completeWeight[0], pairs[m2], ((ThresholdedStrandChIPper)((GenDisMixClassifier)storables[m2]).getDifferentiableSequenceScore(0)).getMotifLength(0), n));
                pwm = ((double[][][])pairs[m2].getFirstElement())[0];
                if (!Double.isNaN(pwm[0][0])) {
                    try {
                        int height = SeqLogoPlotter.getHeight(750, pwm);
                        result.add(new ImageResult("Motif " + (n + 1), "Sequence logo of motif " + (n + 1), SeqLogoPlotter.plotLogoToBufferedImage(height, pwm)));
                        result.add(new ImageResult("Motif " + (n + 1) + " (rc)", "Sequence logo of the reverse complement of motif " + (n + 1), SeqLogoPlotter.plotLogoToBufferedImage(height, PFMComparator.getReverseComplement(DNAAlphabet.SINGLETON, pwm))));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                results.add(result.toArray(new Result[0]));
                ++n;
            }
            ++m2;
        }
        initObjective.stopThreads();
        objective.stopThreads();
        return (Result[][])results.toArray((T[])new Result[0][]);
    }

    private static void replaceMotifModel(HeuristicOneDataSetLogGenDisMixFunction objective, ThresholdedStrandChIPper thresholdedStrandChIPper, SparseLocalInhomogeneousMixtureDiffSM slim, DataSet completeData, double[][] completeWeight) throws Exception {
        double normOld = thresholdedStrandChIPper.getLogNormalizationConstant();
        MarkovModelDiffSM mm = (MarkovModelDiffSM)thresholdedStrandChIPper.getFunction(0);
        slim.initializeFunctionFromIMM1(mm);
        thresholdedStrandChIPper.setMotifModel(slim);
        double w = normOld - thresholdedStrandChIPper.getLogNormalizationConstant();
        objective.addTermToClassParameter(0, w);
    }

    public static ListResult getListResult(DataSet data, double[] weights, Pair<double[][][], int[][]> pair, int motifLength, int motifIndex) throws Exception {
        SplitSequenceAnnotationParser pars = new SplitSequenceAnnotationParser(":", ";");
        LinkedList<ResultSet> set = new LinkedList<ResultSet>();
        int[][] pos = pair.getSecondElement();
        double[][] pvals = pair.getFirstElement()[1];
        int i = 0;
        while (i < pos.length) {
            int j = 0;
            while (j < pos[i].length) {
                Sequence sub;
                int curr = pos[i][j];
                boolean rc = false;
                if (curr < 0) {
                    curr = -curr - 1;
                    rc = true;
                }
                Sequence sub2 = sub = data.getElementAt(i).getSubSequence(curr, motifLength);
                if (rc) {
                    sub2 = sub.reverseComplement();
                }
                ResultSet rs = new ResultSet(new Result[][]{{new NumericalResult("Sequence index", "The index of the sequence", i + 1), new NumericalResult("Position", "The starting position of the motif within the sequence", curr + 1), new CategoricalResult("Strand", "The strand of the predicted BS", rc ? "-" : "+"), new NumericalResult("p-value", "The p-value of the predicted BS", pvals[i][j]), new CategoricalResult("Binding site", "The binding site as in the sequence", sub.toString()), new CategoricalResult("Adjusted binding site", "The binding site in predicted orientation", sub2.toString()), new CategoricalResult("Sequence annotation", "The annotation of the original sequence", pars.parseAnnotationToComment(' ', data.getElementAt(i).getAnnotation()).substring(1))}});
                set.add(rs);
                ++j;
            }
            ++i;
        }
        ListResult lr = new ListResult("Predictions for motif " + (motifIndex + 1), "", null, set.toArray(new ResultSet[0]));
        return lr;
    }

    private static void delete(int[][] positions, boolean[][] allowed, int length) {
        int i = 0;
        while (i < positions.length) {
            int j = 0;
            while (j < positions[i].length) {
                int pos = positions[i][j];
                if (pos < 0) {
                    pos = -pos - 1;
                }
                Arrays.fill(allowed[i], Math.max(0, pos - length / 2), Math.min(allowed[i].length, pos + length / 2), false);
                ++j;
            }
            ++i;
        }
    }

    private static Pair<DataSet, double[][]> getSmallDataSets(double[][] completeWeight, Sequence[] data, double percent, int maxN) throws EmptyDataSetException, WrongAlphabetException {
        int[] ofg = ToolBox.order(completeWeight[0], false);
        int[] obg = ToolBox.order(completeWeight[1], false);
        boolean[] used = new boolean[completeWeight[0].length];
        double[] sums = new double[]{ToolBox.sum(completeWeight[0]), ToolBox.sum(completeWeight[1])};
        double[] currSums = new double[2];
        int idxFg = ofg.length;
        int idxBg = obg.length;
        int totN = 0;
        int nfg = 0;
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        DoubleList w = new DoubleList();
        while (totN < maxN && currSums[0] + completeWeight[0][ofg[idxFg - 1]] < sums[0] * percent) {
            currSums[0] = currSums[0] + completeWeight[0][ofg[idxFg - 1]];
            if (!used[ofg[idxFg - 1]]) {
                seqs.add(data[ofg[idxFg - 1]]);
                w.add(completeWeight[0][ofg[idxFg - 1]]);
                used[ofg[idxFg - 1]] = true;
                ++totN;
                ++nfg;
            }
            --idxFg;
            double tempPerc = currSums[0] / sums[0];
            while (totN < maxN && currSums[1] + completeWeight[1][obg[idxBg - 1]] < sums[1] * tempPerc) {
                currSums[1] = currSums[1] + completeWeight[1][obg[idxBg - 1]];
                if (!used[obg[idxBg - 1]]) {
                    seqs.add(data[obg[idxBg - 1]]);
                    w.add(completeWeight[0][obg[idxBg - 1]]);
                    used[obg[idxBg - 1]] = true;
                    ++totN;
                }
                --idxBg;
            }
        }
        double[] rw = w.toArray();
        return new Pair<DataSet, double[][]>(new DataSet("", seqs.toArray(new Sequence[0])), new double[][]{rw, Interpolation.getBgWeight(rw)});
    }

    private static DataSet annotate(Sequence[] annotated, double[][] weights, double[] mean, double sd, boolean[][] allowed) throws WrongAlphabetException, WrongSequenceTypeException, EmptyDataSetException {
        AlphabetContainer ref = new AlphabetContainer((Alphabet)new ContinuousAlphabet());
        float[][] histogram = new float[annotated.length][];
        int j = 0;
        while (j < weights[0].length) {
            histogram[j] = new float[annotated[j].getLength()];
            float max = 0.0f;
            float sum = 0.0f;
            int i = 0;
            while (i < histogram[j].length) {
                if (allowed[j][i]) {
                    histogram[j][i] = (float)(((double)i - mean[j]) / sd);
                    histogram[j][i] = (float)Math.exp(-0.5 * (double)histogram[j][i] * (double)histogram[j][i]);
                    sum += histogram[j][i];
                }
                ++i;
            }
            i = 0;
            while (i < histogram[j].length) {
                float[] fArray = histogram[j];
                int n = i;
                fArray[n] = fArray[n] / sum;
                if (histogram[j][i] > max) {
                    max = histogram[j][i];
                }
                ++i;
            }
            float[] histBg = (float[])histogram[j].clone();
            sum = 0.0f;
            int i2 = 0;
            while (i2 < histBg.length) {
                if (allowed[j][i2]) {
                    histBg[i2] = max - histBg[i2];
                    sum += histBg[i2];
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < histBg.length) {
                int n = i2++;
                histBg[n] = histBg[n] / sum;
            }
            i2 = 0;
            while (i2 < histogram[j].length) {
                histogram[j][i2] = (float)(weights[0][j] * (double)histogram[j][i2] + weights[1][j] * (double)histBg[i2]);
                ++i2;
            }
            annotated[j] = annotated[j].annotate(false, new ReferenceSequenceAnnotation("reads", new ArbitraryFloatSequence(ref, histogram[j]), new Result[0]));
            ++j;
        }
        return new DataSet("", annotated);
    }

    private static boolean heuristic(MutableMotifDiscoverer mutableMotifDiscoverer, DataSet dataSet, double[][] dArray, LogGenDisMixFunction logGenDisMixFunction, double[] dArray2, double[] dArray3, SafeOutputStream safeOutputStream) throws Exception {
        throw new Error("Unresolved compilation problem: \n\tThe method getPWMAndPosDist(int, DataSet, double[], double[], int, int, LinkedList<Sequence>, DoubleList, DoubleList) in the type SignificantMotifOccurrencesFinder is not applicable for the arguments (int, DataSet, double[], double[], int, int, LinkedList<Sequence>, DoubleList)\n");
    }

    private static double[] getCounts(DataSet completeData, double[] ds) {
        double[] counts = new double[(int)completeData.getAlphabetContainer().getAlphabetLengthAt(0)];
        int i = 0;
        while (i < completeData.getNumberOfElements()) {
            Sequence seq = completeData.getElementAt(i);
            Sequence ref = ((ReferenceSequenceAnnotation)seq.getSequenceAnnotationByTypeAndIdentifier("reference", "reads")).getReferenceSequence();
            int j = 0;
            while (j < seq.getLength()) {
                int n = seq.discreteVal(j);
                counts[n] = counts[n] + ds[i] * ref.continuousVal(j);
                ++j;
            }
            ++i;
        }
        return counts;
    }

    private static DifferentiableStatisticalModel getBgSF(AlphabetContainer con, int order, double ess, double length) throws Exception {
        if (order >= 0) {
            return new HomogeneousMMDiffSM(con, order, ess, (int)Math.round(length));
        }
        return new UniformHomogeneousDiffSM(con, ess);
    }

    private static ArrayList<ComparableElement<double[], Double>> filter2(AbstractSingleMotifChIPper chipper, ComparableElement<double[], Double>[] pars, DataSet fg, double t, int length, SafeOutputStream out) throws Exception {
        int k;
        double[][] profile;
        ArrayList<ComparableElement<double[], Double>> list = new ArrayList<ComparableElement<double[], Double>>(10);
        ArrayList<double[][]> profiles = new ArrayList<double[][]>();
        int i = pars.length - 1;
        while (i >= 0) {
            block6: {
                chipper.setParameters(pars[i].getElement(), 2);
                profile = new double[fg.getNumberOfElements()][];
                k = 0;
                while (k < profile.length) {
                    profile[k] = chipper.getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                    ++k;
                }
                int j = 0;
                while (j < profiles.size()) {
                    double corr = SlimDimont4.getCorrelation((double[][])profiles.get(j), profile, length);
                    if (!(corr > t)) {
                        ++j;
                        continue;
                    }
                    break block6;
                }
                profiles.add(profile);
                list.add(pars[i]);
            }
            --i;
        }
        if (list.size() == 0) {
            i = pars.length - 1;
            profile = new double[fg.getNumberOfElements()][];
            k = 0;
            while (k < profile.length) {
                profile[k] = chipper.getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                ++k;
            }
            profiles.add(profile);
            list.add(pars[i]);
            chipper.setParameters(pars[i].getElement(), 2);
        }
        out.writeln("number of motifs: " + list.size());
        return list;
    }

    private static boolean[] postFilter(MutableMotifDiscoverer[] disc, int[] order, DataSet fg, double t, int length) throws Exception {
        ArrayList<double[][]> profiles = new ArrayList<double[][]>();
        boolean[] use = new boolean[disc.length];
        int i = 0;
        while (i < order.length) {
            block4: {
                double[][] profile = new double[fg.getNumberOfElements()][];
                int k = 0;
                while (k < profile.length) {
                    profile[k] = disc[order[i]].getProfileOfScoresFor(0, 0, fg.getElementAt(k), 0, MotifDiscoverer.KindOfProfile.UNNORMALIZED_JOINT);
                    ++k;
                }
                int j = 0;
                while (j < profiles.size()) {
                    double corr = SlimDimont4.getCorrelation((double[][])profiles.get(j), profile, length);
                    if (!(corr > t)) {
                        ++j;
                        continue;
                    }
                    break block4;
                }
                profiles.add(profile);
                use[i] = true;
            }
            ++i;
        }
        return use;
    }

    private static double getCorrelation(double[][] ds, double[][] profile, int length) throws Exception {
        double max = Double.NEGATIVE_INFINITY;
        int off = 0;
        while (off < length) {
            double currCorr1 = 0.0;
            double currCorr2 = 0.0;
            int i = 0;
            while (i < ds.length) {
                double p1 = ToolBox.pearsonCorrelation(ds[i], profile[i], 0, off);
                double p2 = ToolBox.pearsonCorrelation(ds[i], profile[i], off, 0);
                currCorr1 += p1;
                currCorr2 += p2;
                ++i;
            }
            if (currCorr1 > max) {
                max = currCorr1;
            }
            if (currCorr2 > max) {
                max = currCorr2;
            }
            ++off;
        }
        return max / (double)ds.length;
    }

    public static String getConsensus(AlphabetContainer con, double[][] pfm) {
        String c = "";
        int l = 0;
        while (l < pfm.length) {
            int m = pfm[l][0] > pfm[l][1] ? 0 : 1;
            int s = 1 - m;
            int p = 2;
            while (p < pfm[l].length) {
                if (pfm[l][m] < pfm[l][p]) {
                    s = m;
                    m = p;
                } else if (pfm[l][s] < pfm[l][p]) {
                    s = p;
                }
                ++p;
            }
            c = pfm[l][m] > 0.4 ? (pfm[l][m] - pfm[l][s] > 0.1 ? String.valueOf(c) + con.getSymbol(l, m) : String.valueOf(c) + con.getSymbol(l, m).toLowerCase()) : String.valueOf(c) + "N";
            ++l;
        }
        return c;
    }

    public static ComparableElement<String, Double>[] getKmereSequenceStatistic(int numWanted, int k, DataSet data, double[] weights) throws Exception {
        AlphabetContainer con = data.getAlphabetContainer();
        if (!con.isSimple() || !con.isDiscrete()) {
            throw new WrongAlphabetException();
        }
        Hashtable<String, double[]> res = new Hashtable<String, double[]>();
        HashSet<String> used = new HashSet<String>();
        String[] s = new String[2];
        int n = 0;
        while (n < weights.length) {
            Sequence seq = data.getElementAt(n);
            s[0] = seq.toString();
            s[1] = seq.reverseComplement().toString();
            int m = seq.getLength() - k + 1;
            used.clear();
            int l = 0;
            while (l < m) {
                String h1;
                String h0 = s[0].substring(l, l + k);
                String string = h0 = h0.compareTo(h1 = s[1].substring(s[0].length() - k - l, s[0].length() - l)) < 0 ? h0 : h1;
                if (!used.contains(h0)) {
                    used.add(h0);
                }
                ++l;
            }
            Iterator it = used.iterator();
            while (it.hasNext()) {
                s[0] = (String)it.next();
                if (res.containsKey(s[0])) {
                    double[] h = (double[])res.get(s[0]);
                    h[0] = h[0] + weights[n];
                    h[1] = h[1] + (1.0 - weights[n]);
                    continue;
                }
                res.put(s[0], new double[]{weights[n], 1.0 - weights[n]});
            }
            ++n;
        }
        double sumFg = ToolBox.sum(weights);
        Object[] array = new ComparableElement[res.size()];
        Iterator it = res.entrySet().iterator();
        int a = 0;
        while (a < array.length) {
            Map.Entry e = it.next();
            double[] val = (double[])e.getValue();
            array[a] = new ComparableElement<String, Double>((String)e.getKey(), Math.log(val[0] + 1.0) * (val[0] + 1.0) / (val[1] + 1.0));
            ++a;
        }
        Arrays.sort(array);
        if (numWanted > array.length) {
            numWanted = array.length;
        }
        ComparableElement[] resArray = new ComparableElement[numWanted];
        Sequence[] prevs = new Sequence[numWanted];
        int j = resArray.length - 1;
        int i = array.length - 1;
        while (i >= 0) {
            block11: {
                String curr = (String)((ComparableElement)array[i]).getElement();
                Sequence currs = Sequence.create(DNAAlphabetContainer.SINGLETON, curr);
                int a2 = resArray.length - 1;
                while (a2 > j) {
                    Sequence prev = prevs[a2];
                    if (SlimDimont4.getMinimumHammingDistance(currs, prev) >= 2) {
                        --a2;
                        continue;
                    }
                    break block11;
                }
                resArray[j] = array[i];
                prevs[j] = currs;
                if (--j < 0) break;
            }
            --i;
        }
        return resArray;
    }

    private static int getMinimumHammingDistance(Sequence curr, Sequence seq2) throws Exception {
        int d2;
        int d1;
        Sequence sub2;
        Sequence subRc;
        Sequence sub1;
        int min = Integer.MAX_VALUE;
        int i = 0;
        while (i <= curr.getLength() / 3) {
            sub1 = curr.getSubSequence(i);
            subRc = curr.reverseComplement().getSubSequence(i);
            sub2 = seq2.getSubSequence(0, seq2.getLength() - i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        i = 1;
        while (i <= curr.getLength() / 3) {
            sub1 = curr.getSubSequence(0, curr.getLength() - i);
            subRc = curr.reverseComplement().getSubSequence(0, curr.getLength() - i);
            sub2 = seq2.getSubSequence(i);
            d1 = sub1.getHammingDistance(sub2);
            d2 = subRc.getHammingDistance(sub2);
            if (d1 < min) {
                min = d1;
            }
            if (d2 < min) {
                min = d2;
            }
            ++i;
        }
        return min;
    }
}

