/*
 * Decompiled with CFR 0.152.
 */
package projects.mspd;

import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.assessment.KFoldCrossValidation;
import de.jstacs.classifiers.assessment.KFoldCrossValidationAssessParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifier;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.CompositeLogPrior;
import de.jstacs.classifiers.differentiableSequenceScoreBased.logPrior.LogPrior;
import de.jstacs.classifiers.performanceMeasures.AucPR;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModelFactory;
import de.jstacs.sequenceScores.statisticalModels.differentiable.UniformDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.directedGraphicalModels.BayesianNetworkDiffSM;
import java.util.LinkedList;
import projects.mspd.MSPDModel;

public class MSPDTest {
    public static void main(String[] args) throws Exception {
        DNADataSet fg = new DNADataSet("/Users/dev/Desktop/old/data/donor-fg-cut.txt", '#');
        DNADataSet bg = new DNADataSet("/Users/dev/Desktop/old/data/donor-bg-cut.txt", '#');
        double ess = 256.0;
        UniformDiffSM bgModel = new UniformDiffSM(fg.getAlphabetContainer(), fg.getElementLength(), ess);
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(fg.getAlphabetContainer(), fg.getElementLength(), 20, 1.0E-6, 1.0E-6, 1.0E-4, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 4);
        LinkedList<GenDisMixClassifier> cls = new LinkedList<GenDisMixClassifier>();
        int i = 0;
        while (i < 4) {
            BayesianNetworkDiffSM model = DifferentiableStatisticalModelFactory.createInhomogeneousMarkovModel(fg.getAlphabetContainer(), fg.getElementLength(), ess, i);
            GenDisMixClassifier cl = new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), LearningPrinciple.MSP, model, bgModel);
            cls.add(cl);
            ++i;
        }
        MSPDModel model = new MSPDModel(DNAAlphabetContainer.SINGLETON, fg.getElementLength(), ess, 100.0, 5);
        model.initializeFunction(0, false, new DataSet[]{fg, bg}, null);
        System.out.println(model);
        GenDisMixClassifier cl = new GenDisMixClassifier(params, (LogPrior)new CompositeLogPrior(), LearningPrinciple.MSP, model, bgModel);
        cls.add(cl);
        NumericalPerformanceMeasureParameterSet mp = new NumericalPerformanceMeasureParameterSet(new AucROC(), new AucPR());
        KFoldCrossValidation cv = new KFoldCrossValidation(cls.toArray(new AbstractClassifier[0]));
        KFoldCrossValidationAssessParameterSet assessPS = new KFoldCrossValidationAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, fg.getElementLength(), true, 10);
        System.out.println(cv.assess(mp, assessPS, fg, bg));
    }
}

