/*
 * Decompiled with CFR 0.152.
 */
package projects.robot;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SimpleSequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.results.Result;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedList;

public class GenerateVolumeImport {
    private static String delim = ";";

    public static void main(String[] args) throws Exception {
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        DataSet talSeqs = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor(args[0], '>', (SequenceAnnotationParser)new SimpleSequenceAnnotationParser()), "-");
        int assemblyUnitLength = 6;
        double rvdVolume = 1.0;
        double assVolume = 2.0;
        String plateId = "10";
        String[] columnIds = new String[]{"A", "B", "C", "D", "E", "F", "G", "H"};
        String[] rowIds = new String[]{"1", "2", "3", "4", "5", "6", "7", "8", "9", "10", "11", "12"};
        String[][] standardMixes = new String[][]{{"M1", "13"}, {"H20", "10"}};
        String[][] assembly = new String[][]{{"L"}, {"A", "B", "C", "D"}, {"R"}};
        BufferedReader read = new BufferedReader(new FileReader(args[1]));
        String str = read.readLine();
        String[] header = str.split(";");
        LinkedList<String[]> list = new LinkedList<String[]>();
        while ((str = read.readLine()) != null) {
            str = str.trim();
            String[] parts = str.split(delim);
            list.add(parts);
        }
        String[][] layout = (String[][])list.toArray((T[])new String[0][0]);
        list.clear();
        read.close();
        read = new BufferedReader(new FileReader(args[2]));
        while ((str = read.readLine()) != null) {
            str = str.trim();
            String[] parts = str.split(delim);
            list.add(parts);
        }
        String[][] assLayout = (String[][])list.toArray((T[])new String[0][0]);
        GenerateVolumeImport.run(talSeqs, layout, header, standardMixes, assembly, assLayout, assemblyUnitLength, rvdVolume, assVolume, plateId, columnIds, rowIds);
    }

    public static Result[] run(DataSet talSeqs, String[][] inputLayout, String[] layoutHeader, String[][] standardMixes, String[][] assembly, String[][] assLayout, int assemblyUnitLength, double rvdVolume, double assVolume, String plateId, String[] columnIds, String[] rowIds) {
        TAL[] tals = new TAL[talSeqs.getNumberOfElements()];
        int i = 0;
        while (i < tals.length) {
            tals[i] = new TAL(talSeqs.getElementAt(i), assemblyUnitLength);
            System.out.println(String.valueOf(i) + " " + tals[i]);
            ++i;
        }
        InputLayout layout = new InputLayout(inputLayout, layoutHeader, assembly, assLayout);
        StandardMixes mixes = new StandardMixes(standardMixes);
        System.out.println("name;target;" + mixes.getStandardMixHeader() + layout.getPseudoHeader());
        System.out.println("name;target;" + mixes.getStandardMixHeader() + layout.getLayoutHeader());
        int column = 0;
        int row = 0;
        int i2 = 0;
        while (i2 < tals.length) {
            String[] lines = layout.getLayoutVectorsFor(tals[i2], rvdVolume, assVolume);
            int j = 0;
            while (j < lines.length) {
                String name = String.valueOf(tals[i2].getId()) + "_part" + (j + 1);
                String target = String.valueOf(plateId) + "." + columnIds[column] + rowIds[row];
                System.out.println(String.valueOf(name) + ";" + target + ";" + mixes.getStandardMixRow() + lines[j]);
                if (++column >= columnIds.length) {
                    column = 0;
                    ++row;
                }
                ++j;
            }
            ++i2;
        }
        return null;
    }

    private static class InputLayout {
        private HashMap<String, String[]> layout = new HashMap();
        private String[] orderedKeys;
        private String[] pseudoKeys;
        HashMap<String, Integer> positions;
        int[] rvdCols;
        int[] stopCols;
        String start;
        String end;
        String[] trans;

        public InputLayout(String[][] inputLayout, String[] layoutHeader, String[][] assembly, String[][] assemblyLayout) {
            LinkedList<String> keyTemp = new LinkedList<String>();
            LinkedList<String> pseudoTemp = new LinkedList<String>();
            this.positions = new HashMap();
            this.start = assembly[0][0];
            this.end = assembly[2][0];
            this.trans = assembly[1];
            this.rvdCols = new int[6];
            this.stopCols = new int[5];
            int i = 1;
            while (i < layoutHeader.length) {
                int idx;
                if (layoutHeader[i].startsWith("Stop")) {
                    idx = Integer.parseInt(layoutHeader[i].substring("Stop".length()));
                    this.stopCols[idx - 1] = i - 1;
                } else {
                    idx = Integer.parseInt(layoutHeader[i]);
                    this.rvdCols[idx - 1] = i - 1;
                }
                ++i;
            }
            int k = 0;
            int i2 = 0;
            while (i2 < inputLayout.length) {
                String key = inputLayout[i2][0];
                String[] values = new String[inputLayout[i2].length - 1];
                System.arraycopy(inputLayout[i2], 1, values, 0, values.length);
                this.layout.put(key, values);
                int j = 0;
                while (j < values.length) {
                    keyTemp.add(values[j]);
                    pseudoTemp.add(String.valueOf(key) + layoutHeader[j + 1]);
                    this.positions.put(values[j], k);
                    ++j;
                    ++k;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < assemblyLayout.length) {
                keyTemp.add(assemblyLayout[i2][1]);
                pseudoTemp.add(assemblyLayout[i2][0]);
                this.positions.put(assemblyLayout[i2][0], k);
                ++i2;
                ++k;
            }
            this.orderedKeys = keyTemp.toArray(new String[0]);
            this.pseudoKeys = pseudoTemp.toArray(new String[0]);
        }

        public String getLayoutHeader() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.orderedKeys.length) {
                sb.append(this.orderedKeys[i]);
                if (i < this.orderedKeys.length - 1) {
                    sb.append(delim);
                }
                ++i;
            }
            return sb.toString();
        }

        public String getPseudoHeader() {
            StringBuffer sb = new StringBuffer();
            int i = 0;
            while (i < this.pseudoKeys.length) {
                sb.append(this.pseudoKeys[i]);
                if (i < this.pseudoKeys.length - 1) {
                    sb.append(delim);
                }
                ++i;
            }
            return sb.toString();
        }

        public String[] getLayoutVectorsFor(TAL tal, double volume, double assVolume) {
            String[] layoutS = new String[tal.getNumberOfVectors()];
            String last = "L";
            int i = 0;
            while (i < layoutS.length) {
                String curr = i < layoutS.length - 1 ? this.trans[i] : this.end;
                StringBuffer sb = new StringBuffer();
                double[] volumes = new double[this.orderedKeys.length];
                int j = 0;
                while (j < tal.getNumberOfRVDsForVector(i)) {
                    String rvd = tal.getRVDFor(i, j);
                    int pos = tal.isLastRVD(i, j) ? this.stopCols[j] : this.rvdCols[j];
                    String id = this.layout.get(rvd)[pos];
                    volumes[this.positions.get((Object)id).intValue()] = volume;
                    ++j;
                }
                String key = String.valueOf(last) + curr;
                volumes[this.positions.get((Object)key).intValue()] = assVolume;
                int j2 = 0;
                while (j2 < volumes.length) {
                    sb.append(volumes[j2]);
                    if (i < volumes.length - 1) {
                        sb.append(";");
                    }
                    ++j2;
                }
                layoutS[i] = sb.toString();
                last = curr;
                ++i;
            }
            return layoutS;
        }
    }

    private static class StandardMixes {
        private String[] mixIds;
        private double[] mixVolumes;

        public StandardMixes(String[][] standardMixes) {
            this.mixIds = new String[standardMixes.length];
            this.mixVolumes = new double[standardMixes.length];
            int i = 0;
            while (i < standardMixes.length) {
                this.mixIds[i] = standardMixes[i][0];
                this.mixVolumes[i] = Double.parseDouble(standardMixes[i][1]);
                ++i;
            }
        }

        public String getStandardMixHeader() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.mixIds.length) {
                buf.append(this.mixIds[i]);
                buf.append(delim);
                ++i;
            }
            return buf.toString();
        }

        public String getStandardMixRow() {
            StringBuffer buf = new StringBuffer();
            int i = 0;
            while (i < this.mixIds.length) {
                buf.append(this.mixVolumes[i]);
                buf.append(delim);
                ++i;
            }
            return buf.toString();
        }
    }

    private static class TAL {
        private String id;
        private String[][] RVDs;
        private int assemblyUnitLength;

        public TAL(Sequence seq, int assemblyUnitLength) {
            this.assemblyUnitLength = assemblyUnitLength;
            AlphabetContainer alph = seq.getAlphabetContainer();
            this.RVDs = new String[(int)Math.ceil((double)seq.getLength() / (double)assemblyUnitLength)][];
            int i = 0;
            while (i < this.RVDs.length) {
                this.RVDs[i] = new String[(i + 1) * assemblyUnitLength <= seq.getLength() ? assemblyUnitLength : seq.getLength() % assemblyUnitLength];
                ++i;
            }
            i = 0;
            while (i < seq.getLength()) {
                int idx = i / assemblyUnitLength;
                int idx2 = i % assemblyUnitLength;
                this.RVDs[idx][idx2] = alph.getSymbol(i, seq.discreteVal(i));
                ++i;
            }
            this.id = (String)seq.getSequenceAnnotationByType("unparsed comment line", 0).getResults()[0].getValue();
        }

        public String getId() {
            return this.id;
        }

        public boolean isLastRVD(int vector, int position) {
            return position < this.assemblyUnitLength - 1 && position == this.RVDs[vector].length - 1;
        }

        public String getRVDFor(int vector, int position) {
            return this.RVDs[vector][position];
        }

        public int getNumberOfVectors() {
            return this.RVDs.length;
        }

        public int getNumberOfRVDsForVector(int vector) {
            return this.RVDs[vector].length;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer(String.valueOf(this.id) + "\n");
            int i = 0;
            while (i < this.RVDs.length) {
                sb.append(String.valueOf(Arrays.toString(this.RVDs[i])) + "\n");
                ++i;
            }
            return sb.toString();
        }
    }
}

