/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import projects.taleningner.MonomerScoring;
import projects.taleningner.TALENDiffSM;
import projects.tals.TALgetterDiffSM;

public class DesignScanner {
    private TALENDiffSM sm;
    MonomerScoring scoring;

    public DesignScanner(TALENDiffSM sm, MonomerScoring scoring) {
        this.sm = sm;
        this.scoring = scoring;
    }

    public void scan(Sequence seq, int minl, int maxl, int minspacer, int maxspacer, int optspacer, String[] allowed, boolean[] allowedInit) throws Exception {
        DiscreteAlphabet rvds = this.scoring.getRvds();
        TALgetterDiffSM model = this.scoring.getModel();
        int[] alloCode = new int[allowed.length];
        int i = 0;
        while (i < alloCode.length) {
            alloCode[i] = rvds.getCode(allowed[i]);
            ++i;
        }
        double[] all = null;
        AlphabetContainer cont = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        int l1 = minl;
        while (l1 <= maxl) {
            int l2 = minl;
            while (l2 <= maxl) {
                int s = minspacer;
                while (s <= maxspacer) {
                    int l = 0;
                    while (l < seq.getLength() - l1 - l2 - s - 1) {
                        if (allowedInit[seq.discreteVal(l)] && allowedInit[3 - seq.discreteVal(l + 1 + l1 + s + l2)]) {
                            Sequence seq1 = seq.getSubSequence(l, l1 + 1);
                            Sequence seq2 = seq.getSubSequence(l + 1 + l1 + s, l2 + 1).reverseComplement();
                            Sequence rvds1 = model.getBestRVDsFor(seq1, alloCode);
                            Sequence rvds2 = model.getBestRVDsFor(seq2, alloCode);
                            double[] rep1 = this.scoring.getValues(rvds1);
                            double[] rep2 = this.scoring.getValues(rvds2);
                            if (all == null) {
                                all = new double[rep1.length + rep2.length + 1];
                            }
                            System.arraycopy(rep1, 0, all, 0, rep1.length);
                            System.arraycopy(rep2, 0, all, rep1.length, rep2.length);
                            all[all.length - 1] = (double)s / (double)optspacer;
                            all[all.length - 1] = 1.0;
                            double sc = this.sm.getLogScoreFor(new ArbitrarySequence(cont, all));
                            System.out.println(String.valueOf(l1) + " " + l2 + " " + s + " " + l + " " + seq1 + " " + seq2 + " " + rvds1 + " " + rvds2 + " " + sc);
                        }
                        ++l;
                    }
                    ++s;
                }
                ++l2;
            }
            ++l1;
        }
    }
}

