/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import de.jstacs.classifiers.differentiableSequenceScoreBased.OptimizableFunction;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.GenDisMixClassifierParameterSet;
import de.jstacs.classifiers.differentiableSequenceScoreBased.msp.MSPClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.SequenceAnnotationParser;
import de.jstacs.data.sequences.annotation.SplitSequenceAnnotationParser;
import de.jstacs.io.AbstractStringExtractor;
import de.jstacs.io.SparseStringExtractor;
import de.jstacs.sequenceScores.differentiable.AbstractDifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.differentiable.IndependentProductDiffSS;
import de.jstacs.sequenceScores.differentiable.UniformDiffSS;
import de.jstacs.sequenceScores.differentiable.logistic.LogisticDiffSS;
import de.jstacs.sequenceScores.differentiable.logistic.ProductConstraint;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.ExpGammaDiffSM;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.Pair;
import de.jstacs.utils.ToolBox;
import java.util.Arrays;
import java.util.LinkedList;
import projects.dimont.Interpolation;
import projects.taleningner.DifferenceDiffSS;
import projects.taleningner.MonomerScoring;

public class MonomerTest {
    private static Pair<DataSet, double[]> getData(String path) throws Exception {
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer alphabetsRVD = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        DataSet data = new DataSet(alphabetsRVD, (AbstractStringExtractor)new SparseStringExtractor(path, '>', (SequenceAnnotationParser)new SplitSequenceAnnotationParser(":", ";")), "-");
        MonomerScoring mono = new MonomerScoring(alphabetsRVD);
        LinkedList<Sequence> seqs = new LinkedList<Sequence>();
        DoubleList w = new DoubleList();
        int i = 0;
        while (i < data.getNumberOfElements()) {
            Sequence seq = data.getElementAt(i);
            String ann = seq.getSequenceAnnotationByType("w", 0).getIdentifier();
            w.add(Double.parseDouble(ann));
            double[] vals = mono.getValues(seq);
            Sequence temp = new ArbitrarySequence(new AlphabetContainer((Alphabet)new ContinuousAlphabet()), vals);
            temp = temp.annotate(true, seq.getAnnotation());
            seqs.add(temp);
            ++i;
        }
        DataSet contData = new DataSet("", seqs);
        double[] intensa = w.toArray();
        return new Pair<DataSet, double[]>(contData, intensa);
    }

    public static void main(String[] args) throws Exception {
        Pair<DataSet, double[]> pair = MonomerTest.getData(args[0]);
        DataSet contData = pair.getFirstElement();
        double[] intensa = pair.getSecondElement();
        double[] weights = Interpolation.getWeight(contData, intensa, 0.5, Interpolation.PERCENTILE_LOGISTIC);
        double[] bgWeights = Interpolation.getBgWeight(weights);
        LinkedList<AbstractDifferentiableSequenceScore> sslist = new LinkedList<AbstractDifferentiableSequenceScore>();
        LinkedList<ProductConstraint> constraints = new LinkedList<ProductConstraint>();
        constraints.add(new ProductConstraint(0));
        constraints.add(new ProductConstraint(1));
        constraints.add(new ProductConstraint(2));
        constraints.add(new ProductConstraint(0, 2));
        constraints.add(new ProductConstraint(1, 2));
        constraints.add(new ProductConstraint(0, 1));
        constraints.add(new ProductConstraint(0, 1, 2));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        sslist.add(new ExpGammaDiffSM(contData.getAlphabetContainer(), 1, 4.0, new double[]{10.0}, new double[]{9.0}, true));
        LogisticDiffSS ss = new LogisticDiffSS(contData.getAlphabetContainer(), 3, constraints.toArray(new ProductConstraint[0]));
        sslist.add(ss);
        AbstractDifferentiableSequenceScore fg = new IndependentProductDiffSS(true, sslist.toArray(new DifferentiableSequenceScore[0]));
        fg = new DifferenceDiffSS(fg, fg.clone());
        System.out.println(fg.getLength());
        UniformDiffSS bg = new UniformDiffSS(contData.getAlphabetContainer(), contData.getElementLength());
        GenDisMixClassifierParameterSet params = new GenDisMixClassifierParameterSet(fg.getAlphabetContainer(), fg.getLength(), 20, 1.0E-12, 1.0E-12, 1.0E-4, false, OptimizableFunction.KindOfParameter.PLUGIN, true, 1);
        MSPClassifier cl = new MSPClassifier(params, fg, bg);
        cl.train(new DataSet[]{contData, contData}, new double[][]{weights, bgWeights});
        double[] pred = cl.getScores(contData);
        System.out.println(ToolBox.spearmanCorrelation(intensa, pred));
        Pair<DataSet, double[]> test = MonomerTest.getData(args[1]);
        pred = cl.getScores(test.getFirstElement());
        System.out.println(Arrays.toString(pred));
        System.out.println(ToolBox.spearmanCorrelation(test.getSecondElement(), pred));
        intensa = test.getSecondElement();
        DoubleList pos = new DoubleList();
        DoubleList neg = new DoubleList();
        int i = 0;
        while (i < intensa.length) {
            if (intensa[i] > 10.0) {
                pos.add(pred[i]);
            } else {
                neg.add(pred[i]);
            }
            ++i;
        }
        System.out.println(pos);
        System.out.println(neg);
    }
}

