/*
 * Decompiled with CFR 0.152.
 */
package projects.taleningner;

import de.jstacs.classifiers.differentiableSequenceScoreBased.msp.MSPClassifier;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.alphabets.DiscreteAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.differentiable.DifferentiableSequenceScore;
import de.jstacs.sequenceScores.statisticalModels.differentiable.homogeneous.HomogeneousMMDiffSM;
import projects.taleningner.MonomerScoring;
import projects.taleningner.TALENDiffSM;
import projects.tals.TALgetterDiffSM;

public class ScoreKmers {
    public static void main(String[] args) throws Exception {
        HomogeneousMMDiffSM mm = new HomogeneousMMDiffSM(DNAAlphabetContainer.SINGLETON, 0, 4.0, 10);
        mm.initializeFunctionRandomly(false);
        mm.setParameters(new double[4], 0);
        String[] alph = new String[]{"NI", "NG", "NN", "NS", "N*", "ND", "NK", "NC", "NV", "NA", "NH", "HD", "HG", "HA", "H*", "HH", "HI", "HN", "S*", "SN", "SS", "IG", "YG", "NP", "NT", "IS"};
        AlphabetContainer rvdsCont = new AlphabetContainer((Alphabet)new DiscreteAlphabet(true, alph));
        MonomerScoring scoring = new MonomerScoring(rvdsCont);
        DiscreteAlphabet rvds = scoring.getRvds();
        TALgetterDiffSM model = scoring.getModel();
        String[] allowed = new String[]{"HD", "NI", "NG", "NK"};
        int[] alloCode = new int[allowed.length];
        int i = 0;
        while (i < alloCode.length) {
            alloCode[i] = rvds.getCode(allowed[i]);
            ++i;
        }
        MSPClassifier cl = new MSPClassifier(FileManager.readFile("/Users/dev/Desktop/TAL-Chips/Designer/model/model_test.xml"));
        AlphabetContainer contA = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        DifferentiableSequenceScore score = ((TALENDiffSM)cl.getDifferentiableSequenceScore(0)).getMonomerScore();
        double max = Double.NEGATIVE_INFINITY;
        Sequence best = null;
        int i2 = 0;
        while (i2 < 1000) {
            DataSet ds = mm.emitDataSet(10000, 18);
            int j = 0;
            while (j < ds.getNumberOfElements()) {
                Sequence seq = ds.getElementAt(j);
                Sequence mono = model.getBestRVDsFor(seq = Sequence.create(DNAAlphabetContainer.SINGLETON, "T" + seq), alloCode);
                double[] rep = scoring.getValues(mono);
                double sc = score.getLogScoreFor(new ArbitrarySequence(contA, rep));
                if (sc > max) {
                    max = sc;
                    best = seq;
                    System.out.println(String.valueOf(max) + " " + best + " " + mono);
                }
                ++j;
            }
            ++i2;
        }
    }
}

