/*
 * Decompiled with CFR 0.152.
 */
package projects.talmodel;

import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.FileManager;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.models.HigherOrderHMM;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.Emission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.states.emissions.discrete.DiscreteEmission;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.BasicHigherOrderTransition;
import de.jstacs.sequenceScores.statisticalModels.trainable.hmm.transitions.elements.TransitionElement;
import de.jstacs.utils.ToolBox;
import java.io.PrintWriter;
import java.util.Arrays;
import projects.talmodel.TALModelFactory;

public class FindTALEs {
    public static void main(String[] args) throws Exception {
        DNADataSet genome = new DNADataSet("/Users/dev/Desktop/TAL-Chips/Genomes/PXO83/PXO83_shifted.fa");
        FindTALEs.findRepeats(genome.getElementAt(0), 165);
    }

    public static int[] findRepeats(Sequence genome, int windowWidth) throws Exception {
        HigherOrderHMM hmm = new HigherOrderHMM(FileManager.readFile("/Users/dev/Desktop/TAL-Chips/Genomes/binding_domain.xml"));
        long time = System.currentTimeMillis();
        double[] scores = new double[genome.getLength() - windowWidth + 1];
        int i = 0;
        while (i < genome.getLength() - windowWidth + 1) {
            if (i % 1000 == 0) {
                System.out.println(String.valueOf(i) + " " + (System.currentTimeMillis() - time) / 1000L);
            }
            scores[i] = hmm.getViterbiPathFor(i, i + windowWidth - 1, genome).getSecondElement();
            ++i;
        }
        System.out.println(ToolBox.getMaxIndex(scores));
        PrintWriter wr = new PrintWriter("/Users/dev/Desktop/TAL-Chips/Genomes/binding_domain_scores.txt");
        int i2 = 0;
        while (i2 < scores.length) {
            wr.println(scores[i2]);
            ++i2;
        }
        wr.close();
        return null;
    }

    public static int[] findStart(Sequence genome, int windowWidth) throws Exception {
        HigherOrderHMM hmm = new HigherOrderHMM(FileManager.readFile("/Users/dev/Desktop/TAL-Chips/Genomes/starts1.xml"));
        Emission[] emissions = hmm.getEmissions();
        TransitionElement[] tes = hmm.getTransisionElements();
        int[] emissionIdx = hmm.getEmissionIndexes();
        Emission[] emissions2 = new Emission[emissions.length + 1];
        System.arraycopy(emissions, 0, emissions2, 0, emissions.length);
        emissions2[emissions2.length - 1] = new DiscreteEmission((AlphabetContainer)DNAAlphabetContainer.SINGLETON, TALModelFactory.ess);
        emissionIdx[emissionIdx.length - 1] = emissions2.length - 1;
        BasicHigherOrderTransition.AbstractTransitionElement[] tes2 = new TransitionElement[tes.length];
        System.arraycopy(tes, 0, tes2, 0, tes.length);
        tes2[tes2.length - 1] = new TransitionElement(new int[]{emissionIdx.length - 1}, new int[]{emissionIdx.length - 1}, new double[]{TALModelFactory.ess});
        boolean[] forward = new boolean[emissionIdx.length];
        Arrays.fill(forward, true);
        hmm = new HigherOrderHMM(hmm.getTrainingParams(), hmm.getNames(), emissionIdx, forward, emissions2, tes2);
        double[] scores = new double[genome.getLength() - windowWidth + 1];
        long time = System.currentTimeMillis();
        int i = 0;
        while (i < genome.getLength() - windowWidth) {
            if (i % 100 == 0) {
                System.out.println(String.valueOf(i) + " " + (System.currentTimeMillis() - time) / 1000L);
            }
            scores[i] = hmm.getViterbiPathFor(i, i + windowWidth - 1, genome).getSecondElement();
            ++i;
        }
        System.out.println(ToolBox.getMaxIndex(scores));
        return null;
    }
}

