/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.data.DNADataSet;
import de.jstacs.data.alphabets.DNAAlphabetContainer;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotation;
import de.jstacs.data.sequences.annotation.ReferenceSequenceAnnotationParser;
import de.jstacs.utils.DoubleList;
import de.jstacs.utils.REnvironment;
import de.jstacs.utils.ToolBox;
import java.util.LinkedList;

public class CRISPRRelativeActivity {
    public static void main(String[] args) throws Exception {
        DNADataSet data = new DNADataSet(args[0], '>', new ReferenceSequenceAnnotationParser("seq", DNAAlphabetContainer.SINGLETON, ":", ";"));
        DoubleList[] relVals = new DoubleList[20];
        LinkedList[] seqs = new LinkedList[20];
        int i = 0;
        while (i < relVals.length) {
            relVals[i] = new DoubleList();
            seqs[i] = new LinkedList();
            ++i;
        }
        int[] n = new int[20];
        int[][] ns = new int[4][20];
        DoubleList[] mmscores = new DoubleList[5];
        DoubleList[][] seedmmscores = new DoubleList[5][];
        int i2 = 0;
        while (i2 < mmscores.length) {
            mmscores[i2] = new DoubleList();
            seedmmscores[i2] = new DoubleList[]{new DoubleList(), new DoubleList(), new DoubleList()};
            ++i2;
        }
        Sequence grnaAll = null;
        int i3 = 0;
        while (i3 < data.getNumberOfElements()) {
            Sequence ts = data.getElementAt(i3);
            if (ts.toString().endsWith("GG")) {
                Sequence grna = ((ReferenceSequenceAnnotation)ts.getSequenceAnnotationByType("reference", 0)).getReferenceSequence();
                double w = Double.parseDouble(ts.getSequenceAnnotationByType("rank", 0).getIdentifier());
                int numMM = 0;
                int numSeed = 0;
                int numOut = 0;
                int lastIdx = -1;
                int j = 0;
                while (j < 20) {
                    if (ts.discreteVal(j) != grna.discreteVal(j)) {
                        ++numMM;
                        lastIdx = j;
                        if (j >= 10) {
                            ++numSeed;
                        } else {
                            ++numOut;
                        }
                    }
                    ++j;
                }
                if (numMM < mmscores.length) {
                    mmscores[numMM].add(w);
                    if (numSeed > 0 & numOut > 0) {
                        seedmmscores[numMM][2].add(w);
                    } else if (numOut > 0) {
                        seedmmscores[numMM][1].add(w);
                    } else {
                        seedmmscores[numMM][0].add(w);
                    }
                }
                if (numMM == 0) {
                    grnaAll = grna;
                }
                if (numMM == 1) {
                    relVals[lastIdx].add(w);
                    seqs[lastIdx].add(ts);
                }
            }
            ++i3;
        }
        System.out.print(grnaAll);
        i3 = 0;
        while (i3 < mmscores.length) {
            double med = ToolBox.median(mmscores[i3].toArray());
            System.out.print("\t" + med);
            ++i3;
        }
        System.out.println();
        REnvironment re = new REnvironment();
        re.voidEval("l<-list()");
        int i4 = 0;
        while (i4 < relVals.length) {
            int j = 0;
            while (j < seqs[i4].size()) {
                System.out.println(seqs[i4].get(j));
                ++j;
            }
            System.out.println();
            re.createVector("temp", relVals[i4].toArray());
            re.voidEval("l<-c(l,list(temp))");
            ++i4;
        }
        re.voidEval("nam<-sapply(1:length(l),function(i){paste(i,\" (\",length(l[[i]]),\")\",sep=\"\",collapse=\"\")});");
        re.plotToPDF("boxplot(l,xlab=\"Position\",ylab=\"Rank\",names=nam,las=2)", 10.0, 3.5, String.valueOf(args[1]) + "_positions.pdf", true);
        re.voidEval("l<-list()");
        i4 = 0;
        while (i4 < mmscores.length) {
            re.createVector("temp", mmscores[i4].toArray());
            re.voidEval("l<-c(l,list(temp))");
            ++i4;
        }
        re.voidEval("nam<-sapply(1:length(l),function(i){paste(i-1,\" (\",length(l[[i]]),\")\",sep=\"\",collapse=\"\")});");
        re.plotToPDF("boxplot(l,xlab=\"# Mismatches\",ylab=\"Rank\",names=nam,las=2)", 5.0, 5.0, String.valueOf(args[1]) + "_number.pdf", true);
        re.voidEval("l<-list()");
        re.voidEval("nam<-c()");
        i4 = 0;
        while (i4 < seedmmscores.length) {
            re.createVector("temp", seedmmscores[i4][0].toArray());
            re.voidEval("l<-c(l,list(temp))");
            re.voidEval("nam<-c(nam,\"seed " + i4 + " (" + seedmmscores[i4][0].length() + ")\")");
            re.createVector("temp", seedmmscores[i4][1].toArray());
            re.voidEval("l<-c(l,list(temp))");
            re.voidEval("nam<-c(nam,\"out " + i4 + " (" + seedmmscores[i4][1].length() + ")\")");
            re.createVector("temp", seedmmscores[i4][2].toArray());
            re.voidEval("l<-c(l,list(temp))");
            re.voidEval("nam<-c(nam,\"both " + i4 + " (" + seedmmscores[i4][2].length() + ")\")");
            ++i4;
        }
        re.plotToPDF("boxplot(l,xlab=\"# Mismatches\",ylab=\"Rank\",names=nam,las=2)", 5.0, 5.0, String.valueOf(args[1]) + "_seednumber.pdf", true);
        re.close();
    }
}

