/*
 * Decompiled with CFR 0.152.
 */
import de.jstacs.classifiers.AbstractClassifier;
import de.jstacs.classifiers.ClassifierFactory;
import de.jstacs.classifiers.assessment.RepeatedHoldOutAssessParameterSet;
import de.jstacs.classifiers.assessment.RepeatedHoldOutExperiment;
import de.jstacs.classifiers.differentiableSequenceScoreBased.gendismix.LearningPrinciple;
import de.jstacs.classifiers.performanceMeasures.AucROC;
import de.jstacs.classifiers.performanceMeasures.NumericalPerformanceMeasureParameterSet;
import de.jstacs.data.AlphabetContainer;
import de.jstacs.data.DataSet;
import de.jstacs.data.alphabets.Alphabet;
import de.jstacs.data.alphabets.ContinuousAlphabet;
import de.jstacs.data.sequences.ArbitrarySequence;
import de.jstacs.data.sequences.Sequence;
import de.jstacs.io.ArrayHandler;
import de.jstacs.results.ListResult;
import de.jstacs.sequenceScores.statisticalModels.differentiable.DifferentiableStatisticalModel;
import de.jstacs.sequenceScores.statisticalModels.differentiable.IndependentProductDiffSM;
import de.jstacs.sequenceScores.statisticalModels.differentiable.continuous.SingleGaussianDiffSM;
import java.io.BufferedReader;
import java.io.FileReader;
import java.util.LinkedList;

public class DreamAML {
    public static void main(String[] args) throws Exception {
        DataSet[] data = DreamAML.getData("/Users/dev/Desktop/old/Lehre/AusgewaehlteKapitel-2014/Projekte/MachLearn/trainingData-release.csv");
        int len = data[0].getElementLength();
        AlphabetContainer con = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        SingleGaussianDiffSM gauss = new SingleGaussianDiffSM(con, 4.0, 0.0, 1.0, 1.0, false);
        IndependentProductDiffSM ip = new IndependentProductDiffSM(4.0, true, (DifferentiableStatisticalModel[])ArrayHandler.createArrayOf((Cloneable)gauss, (int)len));
        AbstractClassifier cl = ClassifierFactory.createClassifier(LearningPrinciple.MCL, ip, ip.clone());
        RepeatedHoldOutAssessParameterSet assessPS = new RepeatedHoldOutAssessParameterSet(DataSet.PartitionMethod.PARTITION_BY_NUMBER_OF_ELEMENTS, len, true, 100, new double[]{0.3, 0.3});
        RepeatedHoldOutExperiment exp = new RepeatedHoldOutExperiment(cl);
        NumericalPerformanceMeasureParameterSet mp = new NumericalPerformanceMeasureParameterSet(new AucROC());
        ListResult lr = exp.assess(mp, assessPS, data);
        System.out.println(lr);
    }

    private static DataSet[] getData(String path) throws Exception {
        BufferedReader read = new BufferedReader(new FileReader(path));
        read.readLine();
        String str = null;
        LinkedList<Sequence> pos = new LinkedList<Sequence>();
        LinkedList<Sequence> neg = new LinkedList<Sequence>();
        AlphabetContainer cont = new AlphabetContainer((Alphabet)new ContinuousAlphabet(true));
        int i = 1;
        while ((str = read.readLine()) != null) {
            System.out.println(i);
            ++i;
            String[] parts = str.split(",");
            System.out.println(parts.length);
            double[] dat = new double[256];
            dat[0] = Double.parseDouble(parts[2]);
            int j = 18;
            while (j < parts.length) {
                dat[j - 17] = "NA".equals(parts[j]) ? Double.NaN : Double.parseDouble(parts[j]);
                ++j;
            }
            ArbitrarySequence seq = new ArbitrarySequence(cont, dat);
            if ("CR".equals(parts[13])) {
                pos.add(seq);
                continue;
            }
            neg.add(seq);
        }
        return new DataSet[]{new DataSet("", pos), new DataSet("", neg)};
    }
}

